/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.klf;

import dev.nyon.klf.AutomaticEventSubscriber;
import dev.nyon.klf.KlfLoadingContext;
import dev.nyon.klf.mv.ExtensionsKt;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.EventBusErrorMessage;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 62\u00060\u0001j\u0002`\u0002:\u00016B5\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\n\u0010\r\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0015\u001a\u00060\u0013j\u0002`\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u001b\u0010\u001a\u001a\u00020\u00102\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0012J+\u0010!\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"R\u001b\u0010\u0005\u001a\u00060\u0003j\u0002`\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%R\u001b\u0010\r\u001a\u00060\u000bj\u0002`\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010&\u001a\u0004\b'\u0010(R\u001e\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001a\u0010/\u001a\u00020.8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u001e\u00103\u001a\u00060\u0013j\u0002`\u00148\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u0010\u0016\u00a8\u00067"}, d2={"Ldev/nyon/klf/KotlinModContainer;", "Lnet/neoforged/fml/ModContainer;", "Ldev/nyon/klf/mv/ModContainer;", "Lnet/neoforged/neoforgespi/language/IModInfo;", "Ldev/nyon/klf/mv/IModInfo;", "info", "", "", "entrypoints", "Ljava/lang/ModuleLayer;", "gameLayer", "Lnet/neoforged/neoforgespi/language/ModFileScanData;", "Ldev/nyon/klf/mv/ModFileScanData;", "scanResults", "<init>", "(Lnet/neoforged/neoforgespi/language/IModInfo;Ljava/util/List;Ljava/lang/ModuleLayer;Lnet/neoforged/neoforgespi/language/ModFileScanData;)V", "", "constructMod", "()V", "Lnet/neoforged/bus/api/IEventBus;", "Ldev/nyon/klf/mv/IEventBus;", "getEventBus", "()Lnet/neoforged/bus/api/IEventBus;", "createMod", "Ljava/lang/Class;", "modClass", "initModClass", "(Ljava/lang/Class;)V", "injectAutomaticEventSubscriber", "T", "errorMessage", "Lkotlin/Function0;", "block", "tryAndThrowWithModLoadingException", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lnet/neoforged/neoforgespi/language/IModInfo;", "getInfo", "()Lnet/neoforged/neoforgespi/language/IModInfo;", "Lnet/neoforged/neoforgespi/language/ModFileScanData;", "getScanResults", "()Lnet/neoforged/neoforgespi/language/ModFileScanData;", "modClasses", "Ljava/util/List;", "Ljava/lang/Module;", "layer", "Ljava/lang/Module;", "Ldev/nyon/klf/KlfLoadingContext;", "context", "Ldev/nyon/klf/KlfLoadingContext;", "getContext$KotlinLangForge", "()Ldev/nyon/klf/KlfLoadingContext;", "modBus", "Lnet/neoforged/bus/api/IEventBus;", "getModBus$KotlinLangForge", "Companion", "KotlinLangForge"})
@SourceDebugExtension(value={"SMAP\nKotlinModContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModContainer.kt\ndev/nyon/klf/KotlinModContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,139:1\n1563#2:140\n1634#2,3:141\n1869#2,2:144\n11561#3:146\n11896#3,3:147\n37#4,2:150\n*S KotlinDebug\n*F\n+ 1 KotlinModContainer.kt\ndev/nyon/klf/KotlinModContainer\n*L\n40#1:140\n40#1:141,3\n91#1:144,2\n111#1:146\n111#1:147,3\n114#1:150,2\n*E\n"})
public final class KotlinModContainer
extends ModContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IModInfo info;
    @NotNull
    private final ModFileScanData scanResults;
    @NotNull
    private final List<Class<?>> modClasses;
    @NotNull
    private final Module layer;
    @NotNull
    private final KlfLoadingContext context;
    @NotNull
    private final IEventBus modBus;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Marker LOADING;

    /*
     * WARNING - void declaration
     */
    public KotlinModContainer(@NotNull IModInfo info, @NotNull List<String> entrypoints, @NotNull ModuleLayer gameLayer, @NotNull ModFileScanData scanResults) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(entrypoints, (String)"entrypoints");
        Intrinsics.checkNotNullParameter((Object)gameLayer, (String)"gameLayer");
        Intrinsics.checkNotNullParameter((Object)scanResults, (String)"scanResults");
        super(info);
        this.info = info;
        this.scanResults = scanResults;
        LOGGER.debug(LOADING, "Creating KotlinModContainer instance with klf for {}", entrypoints);
        this.context = new KlfLoadingContext(this);
        IModFileInfo iModFileInfo = this.info.getOwningFile();
        Intrinsics.checkNotNullExpressionValue((Object)iModFileInfo, (String)"getOwningFile(...)");
        Module module = gameLayer.findModule(ExtensionsKt.getModuleName(iModFileInfo)).orElseThrow();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"orElseThrow(...)");
        this.layer = module;
        IEventBus iEventBus = BusBuilder.builder().setExceptionHandler(KotlinModContainer::_init_$lambda$0).markerType(IModBusEvent.class).allowPerPhasePost().build();
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"build(...)");
        this.modBus = iEventBus;
        Iterable iterable = entrypoints;
        KotlinModContainer kotlinModContainer = this;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entrypoint;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Class)this.tryAndThrowWithModLoadingException("Failed to load class {} " + (String)entrypoint + ".", () -> KotlinModContainer.lambda$1$0(this, (String)entrypoint)));
        }
        kotlinModContainer.modClasses = (List)destination$iv$iv;
        try {
            Field contextExtensionField = ModContainer.class.getDeclaredField("contextExtension");
            Supplier<KlfLoadingContext.Companion> legacyExtension = KotlinModContainer::_init_$lambda$2;
            contextExtensionField.set((Object)this, legacyExtension);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
    }

    @NotNull
    public final IModInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final ModFileScanData getScanResults() {
        return this.scanResults;
    }

    @NotNull
    public final KlfLoadingContext getContext$KotlinLangForge() {
        return this.context;
    }

    @NotNull
    public final IEventBus getModBus$KotlinLangForge() {
        return this.modBus;
    }

    protected void constructMod() {
        this.createMod();
    }

    @NotNull
    public IEventBus getEventBus() {
        return this.modBus;
    }

    private final void createMod() {
        Iterable $this$forEach$iv = this.modClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class modClass = (Class)element$iv;
            boolean bl = false;
            this.initModClass(modClass);
            this.injectAutomaticEventSubscriber();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initModClass(Class<?> modClass) {
        try {
            void $this$mapTo$iv$iv;
            Object[] constructors = modClass.getConstructors();
            if (constructors.length == 0 && JvmClassMappingKt.getKotlinClass(modClass).getObjectInstance() != null) {
                return;
            }
            if (constructors.length > 1) {
                throw new RuntimeException("Mod class " + modClass + " must have exactly 1 public constructor, found " + constructors.length + ".");
            }
            Intrinsics.checkNotNull(constructors);
            Constructor constructor = (Constructor)ArraysKt.first((Object[])constructors);
            Pair[] pairArray = new Pair[]{TuplesKt.to(IEventBus.class, (Object)this.modBus), TuplesKt.to(ModContainer.class, (Object)((Object)this)), TuplesKt.to(KotlinModContainer.class, (Object)((Object)this)), TuplesKt.to(Dist.class, (Object)ExtensionsKt.getDist())};
            Map allowedConstructorArguments = MapsKt.mapOf((Pair[])pairArray);
            Class<?>[] classArray = constructor.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
            Object[] $this$map$iv = classArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void type;
                Class clazz = (Class)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object v = allowedConstructorArguments.get(type);
                if (v == null) {
                    throw new RuntimeException("Mod constructor has unsupported argument " + (Class)type + ".");
                }
                collection.add(v);
            }
            List constructorArgs = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = constructorArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            constructor.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
            LOGGER.trace(LOADING, "Loaded mod instance {} of type {}", (Object)this.modId, (Object)modClass.getName());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)modClass.getName(), (Object)(e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause() : e));
            IModInfo iModInfo = this.modInfo;
            Intrinsics.checkNotNullExpressionValue((Object)iModInfo, (String)"modInfo");
            throw ExtensionsKt.modLoadingException(e, iModInfo);
        }
    }

    private final void injectAutomaticEventSubscriber() {
        this.tryAndThrowWithModLoadingException("Failed to register automatic event subscribers of mod " + this.modId + ".", () -> KotlinModContainer.injectAutomaticEventSubscriber$lambda$0(this));
    }

    private final <T> T tryAndThrowWithModLoadingException(String errorMessage, Function0<? extends T> block) {
        try {
            return (T)block.invoke();
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, errorMessage, e);
            IModInfo iModInfo = this.modInfo;
            Intrinsics.checkNotNullExpressionValue((Object)iModInfo, (String)"modInfo");
            throw ExtensionsKt.modLoadingException(e, iModInfo);
        }
    }

    private static final void _init_$lambda$0(IEventBus iEventBus, Event event, EventListener[] listeners, int busId, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, busId, listeners, throwable));
    }

    private static final Class lambda$1$0(KotlinModContainer this$0, String $entrypoint) {
        Class<?> cls = Class.forName(this$0.layer, $entrypoint);
        if (cls == null) {
            throw new ClassNotFoundException("Class '" + $entrypoint + "' could not be found!");
        }
        LOGGER.trace(LOADING, "Loaded modclass {} with {}", (Object)cls.getName(), (Object)cls.getClassLoader());
        return cls;
    }

    private static final KlfLoadingContext.Companion _init_$lambda$2() {
        return KlfLoadingContext.Companion;
    }

    private static final Unit injectAutomaticEventSubscriber$lambda$0(KotlinModContainer this$0) {
        LOGGER.trace(LOADING, "Injecting automatic event subscribers for " + this$0.modId + ".");
        AutomaticEventSubscriber.INSTANCE.inject(this$0, this$0.scanResults, this$0.layer);
        LOGGER.trace(LOADING, "Completed injecting automatic event subscribers for " + this$0.modId + ".");
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        Marker marker = MarkerManager.getMarker((String)"LOADING");
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"getMarker(...)");
        LOADING = marker;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\t8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/nyon/klf/KotlinModContainer$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER$KotlinLangForge", "()Lorg/apache/logging/log4j/Logger;", "Lorg/apache/logging/log4j/Marker;", "LOADING", "Lorg/apache/logging/log4j/Marker;", "getLOADING$KotlinLangForge", "()Lorg/apache/logging/log4j/Marker;", "KotlinLangForge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER$KotlinLangForge() {
            return LOGGER;
        }

        @NotNull
        public final Marker getLOADING$KotlinLangForge() {
            return LOADING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

