/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.klf;

import dev.nyon.klf.AutomaticEventSubscriber;
import dev.nyon.klf.KlfLoadingContext;
import dev.nyon.klf.mv.ExtensionsKt;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 A2\u00060\u0001j\u0002`\u0002:\u0001AB5\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\n\u0010\r\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J1\u0010\u001d\u001a\u00020\u001c\"\u0016\b\u0000\u0010\u001a*\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018*\u0004\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010#\u001a\u00020\u001c2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030!H\u0002\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b%\u0010 J+\u0010)\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001a2\u0006\u0010&\u001a\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0002\u00a2\u0006\u0004\b)\u0010*R\u001b\u0010\u0005\u001a\u00060\u0003j\u0002`\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010+\u001a\u0004\b,\u0010-R\u001b\u0010\r\u001a\u00060\u000bj\u0002`\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010.\u001a\u0004\b/\u00100R\u001e\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001a\u00107\u001a\u0002068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u001e\u0010=\u001a\u00060;j\u0002`<8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\u00a8\u0006B"}, d2={"Ldev/nyon/klf/KotlinModContainer;", "Lnet/minecraftforge/fml/ModContainer;", "Ldev/nyon/klf/mv/ModContainer;", "Lnet/minecraftforge/forgespi/language/IModInfo;", "Ldev/nyon/klf/mv/IModInfo;", "info", "", "", "entrypoints", "Ljava/lang/ModuleLayer;", "gameLayer", "Lnet/minecraftforge/forgespi/language/ModFileScanData;", "Ldev/nyon/klf/mv/ModFileScanData;", "scanResults", "<init>", "(Lnet/minecraftforge/forgespi/language/IModInfo;Ljava/util/List;Ljava/lang/ModuleLayer;Lnet/minecraftforge/forgespi/language/ModFileScanData;)V", "", "mod", "", "matches", "(Ljava/lang/Object;)Z", "getMod", "()Ljava/lang/Object;", "Lnet/minecraftforge/eventbus/api/Event;", "Ldev/nyon/klf/mv/Event;", "Lnet/minecraftforge/fml/event/IModBusEvent;", "T", "e", "", "acceptEvent", "(Lnet/minecraftforge/eventbus/api/Event;)V", "createMod", "()V", "Ljava/lang/Class;", "modClass", "initModClass", "(Ljava/lang/Class;)V", "injectAutomaticEventSubscriber", "errorMessage", "Lkotlin/Function0;", "block", "tryAndThrowWithModLoadingException", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lnet/minecraftforge/forgespi/language/IModInfo;", "getInfo", "()Lnet/minecraftforge/forgespi/language/IModInfo;", "Lnet/minecraftforge/forgespi/language/ModFileScanData;", "getScanResults", "()Lnet/minecraftforge/forgespi/language/ModFileScanData;", "modClasses", "Ljava/util/List;", "Ljava/lang/Module;", "layer", "Ljava/lang/Module;", "Ldev/nyon/klf/KlfLoadingContext;", "context", "Ldev/nyon/klf/KlfLoadingContext;", "getContext$KotlinLangForge", "()Ldev/nyon/klf/KlfLoadingContext;", "Lnet/minecraftforge/eventbus/api/IEventBus;", "Ldev/nyon/klf/mv/IEventBus;", "modBus", "Lnet/minecraftforge/eventbus/api/IEventBus;", "getModBus$KotlinLangForge", "()Lnet/minecraftforge/eventbus/api/IEventBus;", "Companion", "KotlinLangForge"})
@SourceDebugExtension(value={"SMAP\nKotlinModContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModContainer.kt\ndev/nyon/klf/KotlinModContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,139:1\n1563#2:140\n1634#2,3:141\n1869#2,2:144\n11561#3:146\n11896#3,3:147\n37#4,2:150\n*S KotlinDebug\n*F\n+ 1 KotlinModContainer.kt\ndev/nyon/klf/KotlinModContainer\n*L\n40#1:140\n40#1:141,3\n91#1:144,2\n111#1:146\n111#1:147,3\n114#1:150,2\n*E\n"})
public final class KotlinModContainer
extends ModContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IModInfo info;
    @NotNull
    private final ModFileScanData scanResults;
    @NotNull
    private final List<Class<?>> modClasses;
    @NotNull
    private final Module layer;
    @NotNull
    private final KlfLoadingContext context;
    @NotNull
    private final IEventBus modBus;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Marker LOADING;

    /*
     * WARNING - void declaration
     */
    public KotlinModContainer(@NotNull IModInfo info, @NotNull List<String> entrypoints, @NotNull ModuleLayer gameLayer, @NotNull ModFileScanData scanResults) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(entrypoints, "entrypoints");
        Intrinsics.checkNotNullParameter(gameLayer, "gameLayer");
        Intrinsics.checkNotNullParameter(scanResults, "scanResults");
        super(info);
        this.info = info;
        this.scanResults = scanResults;
        LOGGER.debug(LOADING, "Creating KotlinModContainer instance with klf for {}", entrypoints);
        this.context = new KlfLoadingContext(this);
        IModFileInfo iModFileInfo = this.info.getOwningFile();
        Intrinsics.checkNotNullExpressionValue(iModFileInfo, "getOwningFile(...)");
        Module module = gameLayer.findModule(ExtensionsKt.getModuleName(iModFileInfo)).orElseThrow();
        Intrinsics.checkNotNullExpressionValue(module, "orElseThrow(...)");
        this.layer = module;
        IEventBus iEventBus = BusBuilder.builder().setExceptionHandler(KotlinModContainer::_init_$lambda$0).markerType(IModBusEvent.class).build();
        Intrinsics.checkNotNullExpressionValue(iEventBus, "build(...)");
        this.modBus = iEventBus;
        Object object = entrypoints;
        KotlinModContainer kotlinModContainer = this;
        boolean $i$f$map = false;
        Runnable runnable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entrypoint;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.tryAndThrowWithModLoadingException("Failed to load class {} " + (String)entrypoint + ".", () -> KotlinModContainer.lambda$1$0(this, (String)entrypoint)));
        }
        kotlinModContainer.modClasses = (List)destination$iv$iv;
        try {
            Field contextExtensionField = ModContainer.class.getDeclaredField("contextExtension");
            Supplier<KlfLoadingContext.Companion> legacyExtension = KotlinModContainer::_init_$lambda$2;
            contextExtensionField.set((Object)this, legacyExtension);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        Map map2 = this.activityMap;
        Intrinsics.checkNotNullExpressionValue(map2, "activityMap");
        object = map2;
        ModLoadingStage modLoadingStage = ModLoadingStage.CONSTRUCT;
        runnable = this::createMod;
        object.put(modLoadingStage, runnable);
    }

    @NotNull
    public final IModInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final ModFileScanData getScanResults() {
        return this.scanResults;
    }

    @NotNull
    public final KlfLoadingContext getContext$KotlinLangForge() {
        return this.context;
    }

    @NotNull
    public final IEventBus getModBus$KotlinLangForge() {
        return this.modBus;
    }

    public boolean matches(@Nullable Object mod) {
        return Intrinsics.areEqual(CollectionsKt.firstOrNull(this.modClasses), mod);
    }

    @Nullable
    public Object getMod() {
        return CollectionsKt.firstOrNull(this.modClasses);
    }

    protected <T extends Event> void acceptEvent(@Nullable T e) {
        this.tryAndThrowWithModLoadingException("Caught exception during event " + e + " dispatch for mod " + this.modId + ".", () -> KotlinModContainer.acceptEvent$lambda$0(e, this));
    }

    private final void createMod() {
        Iterable $this$forEach$iv = this.modClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class modClass = (Class)element$iv;
            boolean bl = false;
            this.initModClass(modClass);
            this.injectAutomaticEventSubscriber();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initModClass(Class<?> modClass) {
        try {
            void $this$mapTo$iv$iv;
            Constructor<?>[] constructors2 = modClass.getConstructors();
            if (constructors2.length == 0 && JvmClassMappingKt.getKotlinClass(modClass).getObjectInstance() != null) {
                return;
            }
            if (constructors2.length > 1) {
                throw new RuntimeException("Mod class " + modClass + " must have exactly 1 public constructor, found " + constructors2.length + ".");
            }
            Intrinsics.checkNotNull(constructors2);
            Constructor<?> constructor = ArraysKt.first(constructors2);
            Pair[] pairArray = new Pair[]{TuplesKt.to(IEventBus.class, this.modBus), TuplesKt.to(ModContainer.class, this), TuplesKt.to(KotlinModContainer.class, this), TuplesKt.to(Dist.class, ExtensionsKt.getDist())};
            Map allowedConstructorArguments = MapsKt.mapOf(pairArray);
            Class<?>[] classArray = constructor.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, "getParameterTypes(...)");
            Object[] $this$map$iv = classArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void type;
                Class clazz = (Class)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object v = allowedConstructorArguments.get(type);
                if (v == null) {
                    throw new RuntimeException("Mod constructor has unsupported argument " + (Class)type + ".");
                }
                collection.add(v);
            }
            List constructorArgs = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = constructorArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            constructor.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
            LOGGER.trace(LOADING, "Loaded mod instance {} of type {}", (Object)this.modId, (Object)modClass.getName());
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, "Failed to create mod instance. ModID: {}, class {}", (Object)this.getModId(), (Object)modClass.getName(), (Object)(e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause() : e));
            IModInfo iModInfo = this.modInfo;
            Intrinsics.checkNotNullExpressionValue(iModInfo, "modInfo");
            throw ExtensionsKt.modLoadingException(e, iModInfo);
        }
    }

    private final void injectAutomaticEventSubscriber() {
        this.tryAndThrowWithModLoadingException("Failed to register automatic event subscribers of mod " + this.modId + ".", () -> KotlinModContainer.injectAutomaticEventSubscriber$lambda$0(this));
    }

    private final <T> T tryAndThrowWithModLoadingException(String errorMessage, Function0<? extends T> block) {
        try {
            return block.invoke();
        }
        catch (Throwable e) {
            LOGGER.error(LOADING, errorMessage, e);
            IModInfo iModInfo = this.modInfo;
            Intrinsics.checkNotNullExpressionValue(iModInfo, "modInfo");
            throw ExtensionsKt.modLoadingException(e, iModInfo);
        }
    }

    private static final void _init_$lambda$0(IEventBus iEventBus, Event event, IEventListener[] listeners, int busId, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, busId, listeners, throwable));
    }

    private static final Class lambda$1$0(KotlinModContainer this$0, String $entrypoint) {
        Class<?> cls = Class.forName(this$0.layer, $entrypoint);
        if (cls == null) {
            throw new ClassNotFoundException("Class '" + $entrypoint + "' could not be found!");
        }
        LOGGER.trace(LOADING, "Loaded modclass {} with {}", (Object)cls.getName(), (Object)cls.getClassLoader());
        return cls;
    }

    private static final KlfLoadingContext.Companion _init_$lambda$2() {
        return KlfLoadingContext.Companion;
    }

    private static final Unit acceptEvent$lambda$0(Event $e, KotlinModContainer this$0) {
        LOGGER.trace(LOADING, "Firing event " + $e + " for mod " + this$0.modId + ".");
        this$0.modBus.post($e);
        LOGGER.trace(LOADING, "Fired event " + $e + " for mod " + this$0.modId + ".");
        return Unit.INSTANCE;
    }

    private static final Unit injectAutomaticEventSubscriber$lambda$0(KotlinModContainer this$0) {
        LOGGER.trace(LOADING, "Injecting automatic event subscribers for " + this$0.modId + ".");
        AutomaticEventSubscriber.INSTANCE.inject(this$0, this$0.scanResults, this$0.layer);
        LOGGER.trace(LOADING, "Completed injecting automatic event subscribers for " + this$0.modId + ".");
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        LOGGER = logger;
        Marker marker = MarkerManager.getMarker((String)"LOADING");
        Intrinsics.checkNotNullExpressionValue(marker, "getMarker(...)");
        LOADING = marker;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\t8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/nyon/klf/KotlinModContainer$Companion;", "", "<init>", "()V", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER$KotlinLangForge", "()Lorg/apache/logging/log4j/Logger;", "Lorg/apache/logging/log4j/Marker;", "LOADING", "Lorg/apache/logging/log4j/Marker;", "getLOADING$KotlinLangForge", "()Lorg/apache/logging/log4j/Marker;", "KotlinLangForge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER$KotlinLangForge() {
            return LOGGER;
        }

        @NotNull
        public final Marker getLOADING$KotlinLangForge() {
            return LOADING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

