/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.locks;

import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\r\u001a\u00020\f2\n\u0010\b\u001a\u00060\u0004j\u0002`\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0011\u001a\u00020\f2\n\u0010\b\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0013\u001a\u00020\f2\n\u0010\b\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0015\u001a\u00020\f2\n\u0010\b\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0004\b\u0015\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lkotlinx/atomicfu/locks/ParkingDelegator;", "", "<init>", "()V", "Ljava/lang/Thread;", "Lkotlinx/atomicfu/locks/ParkingData;", "createRef", "()Ljava/lang/Thread;", "ref", "Lkotlin/Function0;", "", "shouldWait", "", "wait", "(Ljava/lang/Thread;Lkotlin/jvm/functions/Function0;)V", "", "nanos", "timedWait", "(Ljava/lang/Thread;JLkotlin/jvm/functions/Function0;)V", "wake", "(Ljava/lang/Thread;)V", "destroyRef", "atomicfu"})
public final class ParkingDelegator {
    @NotNull
    public static final ParkingDelegator INSTANCE = new ParkingDelegator();

    private ParkingDelegator() {
    }

    @NotNull
    public final Thread createRef() {
        Thread thread2 = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue(thread2, "currentThread(...)");
        return thread2;
    }

    public final void wait(@NotNull Thread ref, @NotNull Function0<Boolean> shouldWait) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(shouldWait, "shouldWait");
        LockSupport.park();
    }

    public final void timedWait(@NotNull Thread ref, long nanos, @NotNull Function0<Boolean> shouldWait) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        Intrinsics.checkNotNullParameter(shouldWait, "shouldWait");
        LockSupport.parkNanos(nanos);
    }

    public final void wake(@NotNull Thread ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
        LockSupport.unpark(ref);
    }

    public final void destroyRef(@NotNull Thread ref) {
        Intrinsics.checkNotNullParameter(ref, "ref");
    }
}

