/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.DateTimePeriodKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeComponentsKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.internal.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=5, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a'\u0010\u0007\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\b\u001a!\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000e\u001a!\u0010\u0013\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a!\u0010\u0016\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a!\u0010\u0018\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0018\u0010\u0017\u001a!\u0010\u0019\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u0017\u001a!\u0010\r\u001a\u00020\t*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u001a\u001a#\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u001c\u001a\u001b\u0010\u001d\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u001b\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\r\u0010\u001e\u001a!\u0010\u001d\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010 \u001a!\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\r\u0010 \u001a)\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010!\u001a!\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\r\u0010\"\u001a)\u0010\r\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010#\u001a!\u0010\r\u001a\u00020\u0012*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\r\u0010\u0014\u001a)\u0010\u0005\u001a\u00020&*\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010%\u001a\u00020$\u00a2\u0006\u0004\b\u0005\u0010'\"\u0014\u0010(\u001a\u00020\u00128\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b(\u0010)\"\u0014\u0010*\u001a\u00020\u00128\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b*\u0010)\u00a8\u0006+"}, d2={"Lkotlin/time/Instant$Companion;", "", "input", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "format", "Lkotlin/time/Instant;", "parse", "(Lkotlin/time/Instant$Companion;Ljava/lang/CharSequence;Lkotlinx/datetime/format/DateTimeFormat;)Lkotlin/time/Instant;", "Lkotlinx/datetime/DateTimePeriod;", "period", "Lkotlinx/datetime/TimeZone;", "timeZone", "minus", "(Lkotlin/time/Instant;Lkotlinx/datetime/DateTimePeriod;Lkotlinx/datetime/TimeZone;)Lkotlin/time/Instant;", "other", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "unit", "", "until", "(Lkotlin/time/Instant;Lkotlin/time/Instant;Lkotlinx/datetime/DateTimeUnit$TimeBased;)J", "", "daysUntil", "(Lkotlin/time/Instant;Lkotlin/time/Instant;Lkotlinx/datetime/TimeZone;)I", "monthsUntil", "yearsUntil", "(Lkotlin/time/Instant;Lkotlin/time/Instant;Lkotlinx/datetime/TimeZone;)Lkotlinx/datetime/DateTimePeriod;", "Lkotlinx/datetime/DateTimeUnit;", "(Lkotlin/time/Instant;Lkotlinx/datetime/DateTimeUnit;Lkotlinx/datetime/TimeZone;)Lkotlin/time/Instant;", "plus", "(Lkotlin/time/Instant;Lkotlinx/datetime/DateTimeUnit$TimeBased;)Lkotlin/time/Instant;", "value", "(Lkotlin/time/Instant;ILkotlinx/datetime/DateTimeUnit$TimeBased;)Lkotlin/time/Instant;", "(Lkotlin/time/Instant;JLkotlinx/datetime/DateTimeUnit;Lkotlinx/datetime/TimeZone;)Lkotlin/time/Instant;", "(Lkotlin/time/Instant;JLkotlinx/datetime/DateTimeUnit$TimeBased;)Lkotlin/time/Instant;", "(Lkotlin/time/Instant;Lkotlin/time/Instant;Lkotlinx/datetime/DateTimeUnit;Lkotlinx/datetime/TimeZone;)J", "Lkotlinx/datetime/UtcOffset;", "offset", "", "(Lkotlin/time/Instant;Lkotlinx/datetime/format/DateTimeFormat;Lkotlinx/datetime/UtcOffset;)Ljava/lang/String;", "DISTANT_PAST_SECONDS", "J", "DISTANT_FUTURE_SECONDS", "kotlinx-datetime"}, xs="kotlinx/datetime/InstantKt")
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlinx/datetime/InstantKt__InstantKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,417:1\n1#2:418\n*E\n"})
final class InstantKt__InstantKt {
    @NotNull
    public static final Instant parse(@NotNull Instant.Companion $this$parse, @NotNull CharSequence input, @NotNull DateTimeFormat<DateTimeComponents> format) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$parse, "<this>");
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(format, "format");
        try {
            instant = DateTimeComponents.toInstantUsingOffset$default(format.parse(input), null, 1, null);
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeFormatException("Failed to parse an instant from '" + input + '\'', e);
        }
        return instant;
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(period, "period");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (period.getTotalNanoseconds$kotlinx_datetime() != Long.MIN_VALUE) {
            DateTimePeriod $this$minus_u24lambda_u240 = period;
            boolean bl = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u240.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u240.getDays(), -$this$minus_u24lambda_u240.getTotalNanoseconds$kotlinx_datetime());
            instant = InstantJvmKt.plus($this$minus, negatedPeriod, timeZone);
        } else {
            DateTimePeriod $this$minus_u24lambda_u241 = period;
            boolean bl = false;
            DateTimePeriod negatedPeriod = DateTimePeriodKt.buildDateTimePeriod(-$this$minus_u24lambda_u241.getTotalMonths$kotlinx_datetime(), -$this$minus_u24lambda_u241.getDays(), -($this$minus_u24lambda_u241.getTotalNanoseconds$kotlinx_datetime() + 1L));
            instant = InstantKt.plus(InstantJvmKt.plus($this$minus, negatedPeriod, timeZone), 1, DateTimeUnit.Companion.getNANOSECOND());
        }
        return instant;
    }

    public static final long until(@NotNull Instant $this$until, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        long l;
        Intrinsics.checkNotNullParameter($this$until, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        try {
            l = MathKt.multiplyAddAndDivide(other.getEpochSeconds() - $this$until.getEpochSeconds(), 1000000000L, other.getNanosecondsOfSecond() - $this$until.getNanosecondsOfSecond(), unit.getNanoseconds());
        }
        catch (ArithmeticException arithmeticException) {
            l = $this$until.compareTo(other) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }

    public static final int daysUntil(@NotNull Instant $this$daysUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$daysUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$daysUntil, other, (DateTimeUnit)DateTimeUnit.Companion.getDAY(), timeZone));
    }

    public static final int monthsUntil(@NotNull Instant $this$monthsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$monthsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$monthsUntil, other, (DateTimeUnit)DateTimeUnit.Companion.getMONTH(), timeZone));
    }

    public static final int yearsUntil(@NotNull Instant $this$yearsUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$yearsUntil, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return MathKt.clampToInt(InstantJvmKt.until($this$yearsUntil, other, (DateTimeUnit)DateTimeUnit.Companion.getYEAR(), timeZone));
    }

    @NotNull
    public static final DateTimePeriod minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.periodUntil(other, $this$minus, timeZone);
    }

    @Deprecated(message="Use the minus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.minus(1, unit, timeZone)", imports={}))
    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.plus($this$minus, -1, unit, timeZone);
    }

    @Deprecated(message="Use the plus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.plus(1, unit)", imports={}))
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$plus, 1L, unit);
    }

    @Deprecated(message="Use the minus overload with an explicit number of units", replaceWith=@ReplaceWith(expression="this.minus(1, unit)", imports={}))
    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$minus, -1L, unit);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantJvmKt.plus($this$plus, (long)value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, int value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantKt.minus($this$minus, (long)value, unit);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit, timeZone) : InstantJvmKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit, timeZone), 1, unit, timeZone);
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $this$minus, long value, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value != Long.MIN_VALUE ? InstantJvmKt.plus($this$minus, -value, unit) : InstantKt.plus(InstantJvmKt.plus($this$minus, -(value + 1L), unit), 1, unit);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        return InstantJvmKt.until(other, $this$minus, unit, timeZone);
    }

    public static final long minus(@NotNull Instant $this$minus, @NotNull Instant other, @NotNull DateTimeUnit.TimeBased unit) {
        Intrinsics.checkNotNullParameter($this$minus, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return InstantKt.until(other, $this$minus, unit);
    }

    @NotNull
    public static final String format(@NotNull Instant $this$format, @NotNull DateTimeFormat<DateTimeComponents> format, @NotNull UtcOffset offset) {
        Intrinsics.checkNotNullParameter($this$format, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(offset, "offset");
        Instant instant = $this$format;
        return DateTimeComponentsKt.format(format, arg_0 -> InstantKt__InstantKt.format$lambda$2$InstantKt__InstantKt(instant, offset, arg_0));
    }

    public static /* synthetic */ String format$default(Instant instant, DateTimeFormat dateTimeFormat, UtcOffset utcOffset, int n, Object object) {
        if ((n & 2) != 0) {
            utcOffset = UtcOffset.Companion.getZERO();
        }
        return InstantKt.format(instant, (DateTimeFormat<DateTimeComponents>)dateTimeFormat, utcOffset);
    }

    private static final Unit format$lambda$2$InstantKt__InstantKt(Instant $instant, UtcOffset $offset, DateTimeComponents $this$format) {
        Intrinsics.checkNotNullParameter($this$format, "$this$format");
        $this$format.setDateTimeOffset($instant, $offset);
        return Unit.INSTANCE;
    }
}

