/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlinx.datetime.internal.DivRemResult;
import kotlinx.datetime.internal.MathJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\b\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001f\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001f\u0010\b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\b\u0010\u0007\u001a'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0018\u0010\u000e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0082\b\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0082\b\u00a2\u0006\u0004\b\u0010\u0010\u000f\u001a \u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a/\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001a'\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001d\u0010 \u001a\u00020\u0000*\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u001eH\u0000\u00a2\u0006\u0004\b \u0010!\u001a\u001f\u0010\"\u001a\u0004\u0018\u00010\u0000*\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u001eH\u0000\u00a2\u0006\u0004\b\"\u0010#\u001a\u001b\u0010%\u001a\u00020$*\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b%\u0010&\"\u001a\u0010(\u001a\u00020'8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0018\u0010.\u001a\u00020\u0001*\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"", "", "clampToInt", "(J)I", "a", "b", "safeMultiplyOrZero", "(JJ)J", "safeMultiplyOrClamp", "c", "Lkotlinx/datetime/internal/DivRemResult;", "multiplyAndDivide", "(JJJ)Lkotlinx/datetime/internal/DivRemResult;", "x", "low", "(J)J", "high", "value", "bit", "indexBit", "(JI)J", "d", "n", "r", "m", "multiplyAddAndDivide", "(JJJJ)J", "multiplyAndAdd", "(JJJ)J", "Lkotlin/ranges/LongProgression;", "Lkotlin/random/Random;", "random", "randomUnsafe", "(Lkotlin/ranges/LongProgression;Lkotlin/random/Random;)J", "randomUnsafeOrNull", "(Lkotlin/ranges/LongProgression;Lkotlin/random/Random;)Ljava/lang/Long;", "", "containsUnsafe", "(Lkotlin/ranges/LongProgression;J)Z", "", "POWERS_OF_TEN", "[I", "getPOWERS_OF_TEN", "()[I", "getSizeUnsafe", "(Lkotlin/ranges/LongProgression;)I", "sizeUnsafe", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nmath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/MathKt\n*L\n1#1,288:1\n155#1:289\n157#1:290\n155#1:291\n157#1:292\n155#1:293\n155#1,3:294\n155#1:297\n157#1:298\n155#1,3:299\n155#1:302\n157#1:303\n155#1:304\n160#1:305\n160#1:306\n*S KotlinDebug\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/MathKt\n*L\n88#1:289\n89#1:290\n90#1:291\n91#1:292\n102#1:293\n103#1:294,3\n104#1:297\n105#1:298\n105#1:299,3\n106#1:302\n109#1:303\n109#1:304\n115#1:305\n133#1:306\n*E\n"})
public final class MathKt {
    @NotNull
    private static final int[] POWERS_OF_TEN;

    public static final int clampToInt(long $this$clampToInt) {
        return $this$clampToInt > Integer.MAX_VALUE ? Integer.MAX_VALUE : ($this$clampToInt < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)$this$clampToInt);
    }

    private static final long safeMultiplyOrZero(long a, long b) {
        long l = b;
        if (l == -1L) {
            if (a == Long.MIN_VALUE) {
                return 0L;
            }
            return -a;
        }
        if (l == 1L) {
            return a;
        }
        long total = a * b;
        if (total / b != a) {
            return 0L;
        }
        return total;
    }

    public static final long safeMultiplyOrClamp(long a, long b) {
        long l = b;
        if (l == -1L) {
            if (a == Long.MIN_VALUE) {
                return Long.MAX_VALUE;
            }
            return -a;
        }
        if (l == 1L) {
            return a;
        }
        long total = a * b;
        if (total / b != a) {
            return a > 0L == b > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return total;
    }

    @NotNull
    public static final DivRemResult multiplyAndDivide(long a, long b, long c) {
        int sign2;
        if (a == 0L || b == 0L) {
            return new DivRemResult(0L, 0L);
        }
        long ab = MathKt.safeMultiplyOrZero(a, b);
        if (ab != 0L) {
            return new DivRemResult(ab / c, ab % c);
        }
        if (b == c) {
            return new DivRemResult(a, 0L);
        }
        if (a == c) {
            return new DivRemResult(b, 0L);
        }
        long ae = a >= 0L ? 0L : -1L;
        long be = b >= 0L ? 0L : -1L;
        boolean $i$f$low = false;
        long al = a & 0xFFFFFFFFL;
        boolean $i$f$high = false;
        long ah = a >> 32 & 0xFFFFFFFFL;
        boolean $i$f$low2 = false;
        long bl = b & 0xFFFFFFFFL;
        boolean $i$f$high2 = false;
        long bh = b >> 32 & 0xFFFFFFFFL;
        long w = ae * bh + ah * be;
        long x = ae * bl + ah * bh + al * be;
        long y1 = ah * bl;
        long y2 = al * bh;
        long z = al * bl;
        boolean $i$f$low3 = false;
        long r4 = z & 0xFFFFFFFFL;
        boolean $i$f$low4 = false;
        $i$f$low4 = false;
        boolean $i$f$high3 = false;
        long r3c = (y1 & 0xFFFFFFFFL) + (y2 & 0xFFFFFFFFL) + (z >> 32 & 0xFFFFFFFFL);
        boolean $i$f$low5 = false;
        long r3 = r3c & 0xFFFFFFFFL;
        boolean $i$f$high4 = false;
        boolean $i$f$low6 = false;
        $i$f$high4 = false;
        $i$f$high4 = false;
        long r2c = (r3c >> 32 & 0xFFFFFFFFL) + (x & 0xFFFFFFFFL) + (y1 >> 32 & 0xFFFFFFFFL) + (y2 >> 32 & 0xFFFFFFFFL);
        boolean $i$f$low7 = false;
        long r2 = r2c & 0xFFFFFFFFL;
        boolean $i$f$high5 = false;
        $i$f$high5 = false;
        boolean $i$f$low8 = false;
        long r1 = (r2c >> 32 & 0xFFFFFFFFL) + (x >> 32 & 0xFFFFFFFFL) + (w & 0xFFFFFFFFL);
        long abl = r3 << 32 | r4;
        long abh = r1 << 32 | r2;
        int bit$iv = 63;
        boolean $i$f$indexBit = false;
        int n = sign2 = (abh >> bit$iv & 1L) == 1L ? -1 : 1;
        if (sign2 == -1) {
            abl = (abl ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
            abh ^= 0xFFFFFFFFFFFFFFFFL;
            if (abl == 0L) {
                ++abh;
            }
        }
        long q = 0L;
        long r = 0L;
        for (int bitNo = 127; -1 < bitNo; --bitNo) {
            long l;
            if (bitNo < 64) {
                boolean $i$f$indexBit2 = false;
                l = abl >> bitNo & 1L;
            } else {
                int bit$iv2 = bitNo - 64;
                boolean $i$f$indexBit3 = false;
                l = abh >> bit$iv2 & 1L;
            }
            long nextBit = l;
            r = r << 1 | nextBit;
            if (r < c && r >= 0L) continue;
            r -= c;
            if (bitNo < 63) {
                q |= 1L << bitNo;
                continue;
            }
            throw new ArithmeticException("The result of a multiplication followed by division overflows a long");
        }
        return new DivRemResult((long)sign2 * q, (long)sign2 * r);
    }

    private static final long low(long x) {
        boolean $i$f$low = false;
        return x & 0xFFFFFFFFL;
    }

    private static final long high(long x) {
        boolean $i$f$high = false;
        return x >> 32 & 0xFFFFFFFFL;
    }

    private static final long indexBit(long value, int bit) {
        boolean $i$f$indexBit = false;
        return value >> bit & 1L;
    }

    public static final long multiplyAddAndDivide(long d, long n, long r, long m) {
        long l;
        long md = d;
        long mr = r;
        if (d > 0L && r < 0L) {
            l = md;
            md = l + -1L;
            mr += n;
        } else if (d < 0L && r > 0L) {
            l = md;
            md = l + 1L;
            mr -= n;
        }
        if (md == 0L) {
            return mr / m;
        }
        DivRemResult divRemResult = MathKt.multiplyAndDivide(md, n, m);
        long rd = divRemResult.component1();
        long rr = divRemResult.component2();
        return MathJvmKt.safeAdd(rd, MathJvmKt.safeAdd(mr / m, MathJvmKt.safeAdd(mr % m, rr) / m));
    }

    public static final long multiplyAndAdd(long d, long n, long r) {
        long md = d;
        long mr = r;
        if (d > 0L && r < 0L) {
            long l = md;
            md = l + -1L;
            mr += n;
        } else if (d < 0L && r > 0L) {
            long l = md;
            md = l + 1L;
            mr -= n;
        }
        return MathJvmKt.safeAdd(MathJvmKt.safeMultiply(md, n), mr);
    }

    @NotNull
    public static final int[] getPOWERS_OF_TEN() {
        return POWERS_OF_TEN;
    }

    public static final long randomUnsafe(@NotNull LongProgression $this$randomUnsafe, @NotNull Random random) {
        Intrinsics.checkNotNullParameter($this$randomUnsafe, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        return RandomKt.nextLong(random, new LongRange(0L, ($this$randomUnsafe.getLast() - $this$randomUnsafe.getFirst()) / $this$randomUnsafe.getStep())) * $this$randomUnsafe.getStep() + $this$randomUnsafe.getFirst();
    }

    public static /* synthetic */ long randomUnsafe$default(LongProgression longProgression, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return MathKt.randomUnsafe(longProgression, random);
    }

    @Nullable
    public static final Long randomUnsafeOrNull(@NotNull LongProgression $this$randomUnsafeOrNull, @NotNull Random random) {
        Intrinsics.checkNotNullParameter($this$randomUnsafeOrNull, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        return $this$randomUnsafeOrNull.isEmpty() ? null : Long.valueOf(MathKt.randomUnsafe($this$randomUnsafeOrNull, random));
    }

    public static /* synthetic */ Long randomUnsafeOrNull$default(LongProgression longProgression, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return MathKt.randomUnsafeOrNull(longProgression, random);
    }

    public static final boolean containsUnsafe(@NotNull LongProgression $this$containsUnsafe, long value) {
        Intrinsics.checkNotNullParameter($this$containsUnsafe, "<this>");
        LongRange longRange = $this$containsUnsafe.getStep() > 0L ? new LongRange($this$containsUnsafe.getFirst(), $this$containsUnsafe.getLast()) : new LongRange($this$containsUnsafe.getLast(), $this$containsUnsafe.getFirst());
        long l = longRange.getFirst();
        return (value <= longRange.getLast() ? l <= value : false) && (value - $this$containsUnsafe.getFirst()) % $this$containsUnsafe.getStep() == 0L;
    }

    public static final int getSizeUnsafe(@NotNull LongProgression $this$sizeUnsafe) {
        int n;
        Intrinsics.checkNotNullParameter($this$sizeUnsafe, "<this>");
        if ($this$sizeUnsafe.isEmpty()) {
            n = 0;
        } else {
            int n2;
            try {
                n2 = MathKt.clampToInt(MathJvmKt.safeAdd($this$sizeUnsafe.getLast(), -$this$sizeUnsafe.getFirst()) / $this$sizeUnsafe.getStep() + 1L);
            }
            catch (ArithmeticException e) {
                n2 = Integer.MAX_VALUE;
            }
            n = n2;
        }
        return n;
    }

    static {
        int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        POWERS_OF_TEN = nArray;
    }
}

