/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.internal.DecimalFraction;
import kotlinx.datetime.internal.format.parser.AssignableField;
import kotlinx.datetime.internal.format.parser.NumberConsumer;
import kotlinx.datetime.internal.format.parser.NumberConsumerKt;
import kotlinx.datetime.internal.format.parser.NumberConsumptionError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u00028\u00000\u0002B3\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lkotlinx/datetime/internal/format/parser/FractionPartConsumer;", "Receiver", "Lkotlinx/datetime/internal/format/parser/NumberConsumer;", "", "minLength", "maxLength", "Lkotlinx/datetime/internal/format/parser/AssignableField;", "Lkotlinx/datetime/internal/DecimalFraction;", "setter", "", "name", "<init>", "(IILkotlinx/datetime/internal/format/parser/AssignableField;Ljava/lang/String;)V", "storage", "", "input", "start", "end", "Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "consume", "(Ljava/lang/Object;Ljava/lang/CharSequence;II)Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "I", "Lkotlinx/datetime/internal/format/parser/AssignableField;", "kotlinx-datetime"})
public final class FractionPartConsumer<Receiver>
extends NumberConsumer<Receiver> {
    private final int minLength;
    private final int maxLength;
    @NotNull
    private final AssignableField<Receiver, DecimalFraction> setter;

    public FractionPartConsumer(int minLength, int maxLength, @NotNull AssignableField<? super Receiver, DecimalFraction> setter, @NotNull String name) {
        Intrinsics.checkNotNullParameter(setter, "setter");
        Intrinsics.checkNotNullParameter(name, "name");
        super(minLength == maxLength ? Integer.valueOf(minLength) : null, name, null);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.setter = setter;
        int n = this.minLength;
        if (!(1 <= n ? n < 10 : false)) {
            boolean $i$a$-require-FractionPartConsumer$32 = false;
            String $i$a$-require-FractionPartConsumer$32 = "Invalid minimum length " + this.minLength + " for field " + this.getWhatThisExpects() + ": expected 1..9";
            throw new IllegalArgumentException($i$a$-require-FractionPartConsumer$32.toString());
        }
        n = this.minLength;
        int $i$a$-require-FractionPartConsumer$32 = this.maxLength;
        if (!(n <= $i$a$-require-FractionPartConsumer$32 ? $i$a$-require-FractionPartConsumer$32 < 10 : false)) {
            boolean bl = false;
            String string = "Invalid maximum length " + this.maxLength + " for field " + this.getWhatThisExpects() + ": expected " + this.minLength + "..9";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public NumberConsumptionError consume(Receiver storage, @NotNull CharSequence input, int start, int end) {
        Intrinsics.checkNotNullParameter(input, "input");
        return end - start < this.minLength ? (NumberConsumptionError)new NumberConsumptionError.TooFewDigits(this.minLength) : (end - start > this.maxLength ? (NumberConsumptionError)new NumberConsumptionError.TooManyDigits(this.maxLength) : NumberConsumerKt.access$setWithoutReassigning(this.setter, storage, new DecimalFraction(NumberConsumerKt.access$parseAsciiInt(input, start, end), end - start)));
    }
}

