/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.unsafe;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.AlwaysSharedCopyTracker;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.UnsafeIoApi;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.BufferIterationContext;
import kotlinx.io.unsafe.SegmentReadContext;
import kotlinx.io.unsafe.SegmentWriteContext;
import kotlinx.io.unsafe.UnsafeBufferOperationsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJu\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042K\u0010\u0013\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\b0\u000eH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015JB\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0\u0016H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0004\b\u0014\u0010\u0019J}\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\b2K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\b0\u000eH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0003 \u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJh\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\b26\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b( \u0012\u0004\u0012\u00020\b0\u0016H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0003 \u0001\u00a2\u0006\u0004\b\u001c\u0010!Jb\u0010%\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000428\u0010$\u001a4\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u000b0\u0016H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0004\b%\u0010&J\u007f\u0010%\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'2M\u0010$\u001aI\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b()\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u000b0\u000eH\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0003 \u0001\u00a2\u0006\u0004\b%\u0010+JS\u0010-\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u000426\u0010,\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u000b0\u0016H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010&R\u0011\u00100\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lkotlinx/io/unsafe/UnsafeBufferOperations;", "", "<init>", "()V", "Lkotlinx/io/Buffer;", "buffer", "", "bytes", "", "startIndex", "endIndex", "", "moveToTail", "(Lkotlinx/io/Buffer;[BII)V", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "startIndexInclusive", "endIndexExclusive", "readAction", "readFromHead", "(Lkotlinx/io/Buffer;Lkotlin/jvm/functions/Function3;)I", "Lkotlin/Function2;", "Lkotlinx/io/unsafe/SegmentReadContext;", "Lkotlinx/io/Segment;", "(Lkotlinx/io/Buffer;Lkotlin/jvm/functions/Function2;)I", "minimumCapacity", "writeAction", "writeToTail", "(Lkotlinx/io/Buffer;ILkotlin/jvm/functions/Function3;)I", "Lkotlinx/io/unsafe/SegmentWriteContext;", "context", "tail", "(Lkotlinx/io/Buffer;ILkotlin/jvm/functions/Function2;)I", "Lkotlinx/io/unsafe/BufferIterationContext;", "head", "iterationAction", "iterate", "(Lkotlinx/io/Buffer;Lkotlin/jvm/functions/Function2;)V", "", "offset", "segment", "startOfTheSegmentOffset", "(Lkotlinx/io/Buffer;JLkotlin/jvm/functions/Function3;)V", "action", "forEachSegment", "getMaxSafeWriteCapacity", "()I", "maxSafeWriteCapacity", "kotlinx-io-core"})
@UnsafeIoApi
@SourceDebugExtension(value={"SMAP\nUnsafeBufferOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,568:1\n38#2:569\n1#3:570\n659#4,25:571\n*S KotlinDebug\n*F\n+ 1 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n43#1:569\n352#1:571,25\n*E\n"})
public final class UnsafeBufferOperations {
    @NotNull
    public static final UnsafeBufferOperations INSTANCE = new UnsafeBufferOperations();

    private UnsafeBufferOperations() {
    }

    public final int getMaxSafeWriteCapacity() {
        return 8192;
    }

    /*
     * WARNING - void declaration
     */
    public final void moveToTail(@NotNull Buffer buffer, @NotNull byte[] bytes, int startIndex, int endIndex) {
        void startIndex$iv;
        void size$iv;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        int n = bytes.length;
        int n2 = startIndex;
        int endIndex$iv = endIndex;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex$iv, (long)endIndex$iv);
        Segment segment = Segment.Companion.new$kotlinx_io_core(bytes, startIndex, endIndex, AlwaysSharedCopyTracker.INSTANCE, false);
        Segment tail = buffer.getTail();
        if (tail == null) {
            buffer.setHead(segment);
            buffer.setTail(segment);
        } else {
            buffer.setTail(tail.push$kotlinx_io_core(segment));
        }
        buffer.setSizeMut(buffer.getSizeMut() + (long)(endIndex - startIndex));
    }

    public static /* synthetic */ void moveToTail$default(UnsafeBufferOperations unsafeBufferOperations, Buffer buffer, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = byArray.length;
        }
        unsafeBufferOperations.moveToTail(buffer, byArray, n, n2);
    }

    public final int readFromHead(@NotNull Buffer buffer, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, Integer> readAction) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(readAction, "readAction");
        boolean $i$f$readFromHead = false;
        if (!(!buffer.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$22.toString());
        }
        Segment segment = buffer.getHead();
        Intrinsics.checkNotNull(segment);
        Segment head = segment;
        int bytesRead = ((Number)readAction.invoke((byte[])head.dataAsByteArray(true), (Integer)head.getPos(), (Integer)head.getLimit())).intValue();
        if (bytesRead != 0) {
            if (bytesRead < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead > head.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer.skip(bytesRead);
        }
        return bytesRead;
    }

    public final int readFromHead(@NotNull Buffer buffer, @NotNull Function2<? super SegmentReadContext, ? super Segment, Integer> readAction) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(readAction, "readAction");
        boolean $i$f$readFromHead = false;
        if (!(!buffer.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$32 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$32 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$32.toString());
        }
        Segment segment = buffer.getHead();
        Intrinsics.checkNotNull(segment);
        Segment head = segment;
        int bytesRead = ((Number)readAction.invoke(UnsafeBufferOperationsKt.getSegmentReadContextImpl(), head)).intValue();
        if (bytesRead != 0) {
            if (bytesRead < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead > head.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer.skip(bytesRead);
        }
        return bytesRead;
    }

    public final int writeToTail(@NotNull Buffer buffer, int minimumCapacity, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, Integer> writeAction) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(writeAction, "writeAction");
        boolean $i$f$writeToTail = false;
        Segment tail = buffer.writableSegment(minimumCapacity);
        byte[] data = tail.dataAsByteArray(false);
        int bytesWritten = ((Number)writeAction.invoke((byte[])data, (Integer)tail.getLimit(), (Integer)data.length)).intValue();
        if (bytesWritten == minimumCapacity) {
            tail.writeBackData(data, bytesWritten);
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (!(0 <= bytesWritten ? bytesWritten <= tail.getRemainingCapacity() : false)) {
            boolean bl = false;
            String string = "Invalid number of bytes written: " + bytesWritten + ". Should be in 0.." + tail.getRemainingCapacity();
            throw new IllegalStateException(string.toString());
        }
        if (bytesWritten != 0) {
            tail.writeBackData(data, bytesWritten);
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (SegmentKt.isEmpty(tail)) {
            buffer.recycleTail();
        }
        return bytesWritten;
    }

    public final int writeToTail(@NotNull Buffer buffer, int minimumCapacity, @NotNull Function2<? super SegmentWriteContext, ? super Segment, Integer> writeAction) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(writeAction, "writeAction");
        boolean $i$f$writeToTail = false;
        Segment tail = buffer.writableSegment(minimumCapacity);
        int bytesWritten = ((Number)writeAction.invoke(UnsafeBufferOperationsKt.getSegmentWriteContextImpl(), tail)).intValue();
        if (bytesWritten == minimumCapacity) {
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (!(0 <= bytesWritten ? bytesWritten <= tail.getRemainingCapacity() : false)) {
            boolean bl = false;
            String string = "Invalid number of bytes written: " + bytesWritten + ". Should be in 0.." + tail.getRemainingCapacity();
            throw new IllegalStateException(string.toString());
        }
        if (bytesWritten != 0) {
            tail.setLimit(tail.getLimit() + bytesWritten);
            buffer.setSizeMut(buffer.getSizeMut() + (long)bytesWritten);
            return bytesWritten;
        }
        if (SegmentKt.isEmpty(tail)) {
            buffer.recycleTail();
        }
        return bytesWritten;
    }

    public final void iterate(@NotNull Buffer buffer, @NotNull Function2<? super BufferIterationContext, ? super Segment, Unit> iterationAction) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(iterationAction, "iterationAction");
        boolean $i$f$iterate = false;
        iterationAction.invoke(UnsafeBufferOperationsKt.getBufferIterationContextImpl(), buffer.getHead());
    }

    /*
     * WARNING - void declaration
     */
    public final void iterate(@NotNull Buffer buffer, long offset, @NotNull Function3<? super BufferIterationContext, ? super Segment, ? super Long, Unit> iterationAction) {
        void $this$seek$iv;
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(iterationAction, "iterationAction");
        boolean $i$f$iterate = false;
        if (!(offset >= 0L)) {
            boolean $i$a$-require-UnsafeBufferOperations$iterate$22 = false;
            String $i$a$-require-UnsafeBufferOperations$iterate$22 = "Offset must be non-negative: " + offset;
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$iterate$22.toString());
        }
        if (offset >= buffer.getSize()) {
            throw new IndexOutOfBoundsException("Offset should be less than buffer's size (" + buffer.getSize() + "): " + offset);
        }
        Buffer buffer2 = buffer;
        long fromIndex$iv = offset;
        boolean $i$f$seek = false;
        if ($this$seek$iv.getHead() == null) {
            void o;
            long l = -1L;
            Object s = null;
            boolean bl = false;
            iterationAction.invoke(UnsafeBufferOperationsKt.getBufferIterationContextImpl(), (Segment)s, (Long)((long)o));
        } else if ($this$seek$iv.getSize() - fromIndex$iv < fromIndex$iv) {
            void o;
            Segment s$iv;
            long offset$iv = $this$seek$iv.getSize();
            for (s$iv = $this$seek$iv.getTail(); s$iv != null && offset$iv > fromIndex$iv && (offset$iv -= (long)(s$iv.getLimit() - s$iv.getPos())) > fromIndex$iv; s$iv = s$iv.getPrev()) {
            }
            long l = offset$iv;
            Segment s = s$iv;
            boolean bl = false;
            iterationAction.invoke(UnsafeBufferOperationsKt.getBufferIterationContextImpl(), s, (Long)((long)o));
        } else {
            void o;
            long nextOffset$iv;
            Segment s$iv;
            long offset$iv = 0L;
            for (s$iv = $this$seek$iv.getHead(); s$iv != null && (nextOffset$iv = offset$iv + (long)(s$iv.getLimit() - s$iv.getPos())) <= fromIndex$iv; s$iv = s$iv.getNext()) {
                offset$iv = nextOffset$iv;
            }
            long l = offset$iv;
            Segment s = s$iv;
            boolean bl = false;
            iterationAction.invoke(UnsafeBufferOperationsKt.getBufferIterationContextImpl(), s, (Long)((long)o));
        }
    }

    public final void forEachSegment(@NotNull Buffer buffer, @NotNull Function2<? super SegmentReadContext, ? super Segment, Unit> action) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forEachSegment = false;
        for (Segment curr = buffer.getHead(); curr != null; curr = curr.getNext()) {
            action.invoke(UnsafeBufferOperationsKt.getSegmentReadContextImpl(), curr);
        }
    }
}

