/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.atomicfu.locks;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import kotlinx.atomicfu.locks.Free;
import kotlinx.atomicfu.locks.Parked;
import kotlinx.atomicfu.locks.ParkingDelegator;
import kotlinx.atomicfu.locks.ParkingState;
import kotlinx.atomicfu.locks.Unparked;
import kotlinx.atomicfu.locks.Unparking;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\u00020\u00042\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\u00040\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0003R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lkotlinx/atomicfu/locks/ThreadParker;", "", "<init>", "()V", "", "park", "", "nanos", "parkNanos", "(J)V", "Lkotlin/Function1;", "Ljava/lang/Thread;", "Lkotlinx/atomicfu/locks/ParkingData;", "invokeWait", "parkWith", "(Lkotlin/jvm/functions/Function1;)V", "unpark", "Lkotlinx/atomicfu/locks/ParkingDelegator;", "delegator", "Lkotlinx/atomicfu/locks/ParkingDelegator;", "Lkotlinx/atomicfu/AtomicRef;", "Lkotlinx/atomicfu/locks/ParkingState;", "state", "Lkotlinx/atomicfu/AtomicRef;", "atomicfu"})
public final class ThreadParker {
    @NotNull
    private final ParkingDelegator delegator = ParkingDelegator.INSTANCE;
    @NotNull
    private final AtomicRef<ParkingState> state = AtomicFU.atomic(Free.INSTANCE);

    public final void park() {
        this.parkWith(arg_0 -> ThreadParker.park$lambda$1(this, arg_0));
    }

    public final void parkNanos(long nanos) {
        long mark = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        this.parkWith(arg_0 -> ThreadParker.parkNanos$lambda$3(nanos, mark, this, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final void parkWith(Function1<? super Thread, Unit> invokeWait) {
        block8: {
            while (true) {
                block9: {
                    block7: {
                        if (!Intrinsics.areEqual(var2_2 = this.state.getValue(), Free.INSTANCE)) break block9;
                        pd = this.delegator.createRef();
                        if (!this.state.compareAndSet(Free.INSTANCE, new Parked(pd))) {
                            this.delegator.destroyRef(pd);
                            continue;
                        }
                        invokeWait.invoke(pd);
                        do lbl-1000:
                        // 3 sources

                        {
                            block10: {
                                if (!((changedState = this.state.getValue()) instanceof Parked)) break block10;
                                if (!this.state.compareAndSet(changedState, Free.INSTANCE)) ** GOTO lbl-1000
                                this.delegator.destroyRef(pd);
                                return;
                            }
                            if (!(changedState instanceof Unparking)) break block7;
                        } while (!this.state.compareAndSet(changedState, Free.INSTANCE));
                        return;
                    }
                    if (Intrinsics.areEqual(changedState, Free.INSTANCE)) {
                        this.delegator.destroyRef(pd);
                        return;
                    }
                    if (Intrinsics.areEqual(changedState, Unparked.INSTANCE)) {
                        this.delegator.destroyRef(pd);
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (!Intrinsics.areEqual(var2_2, Unparked.INSTANCE)) break block8;
                if (this.state.compareAndSet(Unparked.INSTANCE, Free.INSTANCE)) break;
            }
            return;
        }
        if (var2_2 instanceof Parked) {
            throw new IllegalStateException("Thread should not be able to call park when it is already parked");
        }
        if (var2_2 instanceof Unparking) {
            throw new IllegalStateException("Thread should not be able to call park when it is already parked");
        }
        throw new NoWhenBranchMatchedException();
    }

    public final void unpark() {
        block5: {
            ParkingState currentState;
            Unparking myUnparkingState = new Unparking();
            while (true) {
                if (Intrinsics.areEqual(currentState = this.state.getValue(), Unparked.INSTANCE)) {
                    return;
                }
                if (currentState instanceof Unparking) {
                    return;
                }
                if (Intrinsics.areEqual(currentState, Free.INSTANCE)) {
                    if (!this.state.compareAndSet(Free.INSTANCE, Unparked.INSTANCE)) continue;
                    return;
                }
                if (!(currentState instanceof Parked)) break block5;
                if (this.state.compareAndSet(currentState, myUnparkingState)) break;
            }
            this.delegator.wake(((Parked)currentState).getData());
            if (this.state.compareAndSet(myUnparkingState, Free.INSTANCE)) {
                return;
            }
            this.delegator.destroyRef(((Parked)currentState).getData());
            return;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final boolean park$lambda$1$lambda$0(ThreadParker this$0) {
        return this$0.state.getValue() instanceof Parked;
    }

    private static final Unit park$lambda$1(ThreadParker this$0, Thread data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this$0.delegator.wait(data, () -> ThreadParker.park$lambda$1$lambda$0(this$0));
        return Unit.INSTANCE;
    }

    private static final boolean parkNanos$lambda$3$lambda$2(ThreadParker this$0) {
        return this$0.state.getValue() instanceof Parked;
    }

    private static final Unit parkNanos$lambda$3(long $nanos, long $mark, ThreadParker this$0, Thread data) {
        Intrinsics.checkNotNullParameter(data, "data");
        long remainingTime = $nanos - Duration.toLong-impl(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc($mark), DurationUnit.NANOSECONDS);
        if (remainingTime > 0L) {
            this$0.delegator.timedWait(data, remainingTime, () -> ThreadParker.parkNanos$lambda$3$lambda$2(this$0));
        }
        return Unit.INSTANCE;
    }
}

