/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DayOfWeek;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.FixedOffsetTimeZone;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.Month;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.YearMonth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0004\u001a\u00020\u0000*\u00020\u0001H\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0011\u0010\b\u001a\u00020\u0007*\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0011\u0010\n\u001a\u00020\u0006*\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0011\u0010\u000e\u001a\u00020\r*\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0011\u0010\u0010\u001a\u00020\f*\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0011\u0010\u0014\u001a\u00020\u0013*\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0011\u0010\u0016\u001a\u00020\u0012*\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0011\u0010\u001a\u001a\u00020\u0019*\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0011\u0010\u001c\u001a\u00020\u0018*\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a\u0011\u0010 \u001a\u00020\u001f*\u00020\u001e\u00a2\u0006\u0004\b \u0010!\u001a\u0011\u0010\"\u001a\u00020\u001e*\u00020\u001f\u00a2\u0006\u0004\b\"\u0010#\u001a\u0011\u0010&\u001a\u00020%*\u00020$\u00a2\u0006\u0004\b&\u0010'\u001a\u0011\u0010(\u001a\u00020$*\u00020%\u00a2\u0006\u0004\b(\u0010)\u001a\u0013\u0010*\u001a\u00020$*\u00020%H\u0007\u00a2\u0006\u0004\b*\u0010)\u001a\u0011\u0010&\u001a\u00020%*\u00020+\u00a2\u0006\u0004\b&\u0010,\u001a\u0011\u0010-\u001a\u00020+*\u00020%\u00a2\u0006\u0004\b-\u0010.\u001a\u0011\u00101\u001a\u000200*\u00020/\u00a2\u0006\u0004\b1\u00102\u001a\u0011\u00103\u001a\u00020/*\u000200\u00a2\u0006\u0004\b3\u00104\u001a\u0011\u00107\u001a\u000206*\u000205\u00a2\u0006\u0004\b7\u00108\u001a\u0011\u00109\u001a\u000205*\u000206\u00a2\u0006\u0004\b9\u0010:\u001a\u0011\u0010=\u001a\u00020<*\u00020;\u00a2\u0006\u0004\b=\u0010>\u001a\u0011\u0010?\u001a\u00020;*\u00020<\u00a2\u0006\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lkotlinx/datetime/Instant;", "Ljava/time/Instant;", "toJavaInstant", "(Lkotlinx/datetime/Instant;)Ljava/time/Instant;", "toKotlinInstant", "(Ljava/time/Instant;)Lkotlinx/datetime/Instant;", "Lkotlinx/datetime/LocalDateTime;", "Ljava/time/LocalDateTime;", "toJavaLocalDateTime", "(Lkotlinx/datetime/LocalDateTime;)Ljava/time/LocalDateTime;", "toKotlinLocalDateTime", "(Ljava/time/LocalDateTime;)Lkotlinx/datetime/LocalDateTime;", "Lkotlinx/datetime/LocalTime;", "Ljava/time/LocalTime;", "toJavaLocalTime", "(Lkotlinx/datetime/LocalTime;)Ljava/time/LocalTime;", "toKotlinLocalTime", "(Ljava/time/LocalTime;)Lkotlinx/datetime/LocalTime;", "Lkotlinx/datetime/LocalDate;", "Ljava/time/LocalDate;", "toJavaLocalDate", "(Lkotlinx/datetime/LocalDate;)Ljava/time/LocalDate;", "toKotlinLocalDate", "(Ljava/time/LocalDate;)Lkotlinx/datetime/LocalDate;", "Lkotlinx/datetime/DatePeriod;", "Ljava/time/Period;", "toJavaPeriod", "(Lkotlinx/datetime/DatePeriod;)Ljava/time/Period;", "toKotlinDatePeriod", "(Ljava/time/Period;)Lkotlinx/datetime/DatePeriod;", "Lkotlinx/datetime/TimeZone;", "Ljava/time/ZoneId;", "toJavaZoneId", "(Lkotlinx/datetime/TimeZone;)Ljava/time/ZoneId;", "toKotlinTimeZone", "(Ljava/time/ZoneId;)Lkotlinx/datetime/TimeZone;", "Lkotlinx/datetime/FixedOffsetTimeZone;", "Ljava/time/ZoneOffset;", "toJavaZoneOffset", "(Lkotlinx/datetime/FixedOffsetTimeZone;)Ljava/time/ZoneOffset;", "toKotlinFixedOffsetTimeZone", "(Ljava/time/ZoneOffset;)Lkotlinx/datetime/FixedOffsetTimeZone;", "toKotlinZoneOffset", "Lkotlinx/datetime/UtcOffset;", "(Lkotlinx/datetime/UtcOffset;)Ljava/time/ZoneOffset;", "toKotlinUtcOffset", "(Ljava/time/ZoneOffset;)Lkotlinx/datetime/UtcOffset;", "Lkotlinx/datetime/Month;", "Ljava/time/Month;", "toJavaMonth", "(Lkotlinx/datetime/Month;)Ljava/time/Month;", "toKotlinMonth", "(Ljava/time/Month;)Lkotlinx/datetime/Month;", "Lkotlinx/datetime/DayOfWeek;", "Ljava/time/DayOfWeek;", "toJavaDayOfWeek", "(Lkotlinx/datetime/DayOfWeek;)Ljava/time/DayOfWeek;", "toKotlinDayOfWeek", "(Ljava/time/DayOfWeek;)Lkotlinx/datetime/DayOfWeek;", "Lkotlinx/datetime/YearMonth;", "Ljava/time/YearMonth;", "toJavaYearMonth", "(Lkotlinx/datetime/YearMonth;)Ljava/time/YearMonth;", "toKotlinYearMonth", "(Ljava/time/YearMonth;)Lkotlinx/datetime/YearMonth;", "kotlinx-datetime"})
public final class ConvertersKt {
    @PublishedApi
    @NotNull
    public static final java.time.Instant toJavaInstant(@NotNull Instant $this$toJavaInstant) {
        Intrinsics.checkNotNullParameter($this$toJavaInstant, "<this>");
        return $this$toJavaInstant.getValue$kotlinx_datetime();
    }

    @PublishedApi
    @LowPriorityInOverloadResolution
    @NotNull
    public static final Instant toKotlinInstant(@NotNull java.time.Instant $this$toKotlinInstant) {
        Intrinsics.checkNotNullParameter($this$toKotlinInstant, "<this>");
        return new Instant($this$toKotlinInstant);
    }

    @NotNull
    public static final java.time.LocalDateTime toJavaLocalDateTime(@NotNull LocalDateTime $this$toJavaLocalDateTime) {
        Intrinsics.checkNotNullParameter($this$toJavaLocalDateTime, "<this>");
        return $this$toJavaLocalDateTime.getValue$kotlinx_datetime();
    }

    @NotNull
    public static final LocalDateTime toKotlinLocalDateTime(@NotNull java.time.LocalDateTime $this$toKotlinLocalDateTime) {
        Intrinsics.checkNotNullParameter($this$toKotlinLocalDateTime, "<this>");
        return new LocalDateTime($this$toKotlinLocalDateTime);
    }

    @NotNull
    public static final java.time.LocalTime toJavaLocalTime(@NotNull LocalTime $this$toJavaLocalTime) {
        Intrinsics.checkNotNullParameter($this$toJavaLocalTime, "<this>");
        return $this$toJavaLocalTime.getValue$kotlinx_datetime();
    }

    @NotNull
    public static final LocalTime toKotlinLocalTime(@NotNull java.time.LocalTime $this$toKotlinLocalTime) {
        Intrinsics.checkNotNullParameter($this$toKotlinLocalTime, "<this>");
        return new LocalTime($this$toKotlinLocalTime);
    }

    @NotNull
    public static final java.time.LocalDate toJavaLocalDate(@NotNull LocalDate $this$toJavaLocalDate) {
        Intrinsics.checkNotNullParameter($this$toJavaLocalDate, "<this>");
        return $this$toJavaLocalDate.getValue$kotlinx_datetime();
    }

    @NotNull
    public static final LocalDate toKotlinLocalDate(@NotNull java.time.LocalDate $this$toKotlinLocalDate) {
        Intrinsics.checkNotNullParameter($this$toKotlinLocalDate, "<this>");
        return new LocalDate($this$toKotlinLocalDate);
    }

    @NotNull
    public static final Period toJavaPeriod(@NotNull DatePeriod $this$toJavaPeriod) {
        Intrinsics.checkNotNullParameter($this$toJavaPeriod, "<this>");
        Period period = Period.of($this$toJavaPeriod.getYears(), $this$toJavaPeriod.getMonths(), $this$toJavaPeriod.getDays());
        Intrinsics.checkNotNullExpressionValue(period, "of(...)");
        return period;
    }

    @NotNull
    public static final DatePeriod toKotlinDatePeriod(@NotNull Period $this$toKotlinDatePeriod) {
        Intrinsics.checkNotNullParameter($this$toKotlinDatePeriod, "<this>");
        return new DatePeriod($this$toKotlinDatePeriod.getYears(), $this$toKotlinDatePeriod.getMonths(), $this$toKotlinDatePeriod.getDays());
    }

    @NotNull
    public static final ZoneId toJavaZoneId(@NotNull TimeZone $this$toJavaZoneId) {
        Intrinsics.checkNotNullParameter($this$toJavaZoneId, "<this>");
        return $this$toJavaZoneId.getZoneId$kotlinx_datetime();
    }

    @NotNull
    public static final TimeZone toKotlinTimeZone(@NotNull ZoneId $this$toKotlinTimeZone) {
        Intrinsics.checkNotNullParameter($this$toKotlinTimeZone, "<this>");
        return TimeZone.Companion.ofZone$kotlinx_datetime($this$toKotlinTimeZone);
    }

    @NotNull
    public static final ZoneOffset toJavaZoneOffset(@NotNull FixedOffsetTimeZone $this$toJavaZoneOffset) {
        Intrinsics.checkNotNullParameter($this$toJavaZoneOffset, "<this>");
        return $this$toJavaZoneOffset.getOffset().getZoneOffset$kotlinx_datetime();
    }

    @NotNull
    public static final FixedOffsetTimeZone toKotlinFixedOffsetTimeZone(@NotNull ZoneOffset $this$toKotlinFixedOffsetTimeZone) {
        Intrinsics.checkNotNullParameter($this$toKotlinFixedOffsetTimeZone, "<this>");
        return new FixedOffsetTimeZone(new UtcOffset($this$toKotlinFixedOffsetTimeZone));
    }

    @Deprecated(message="Use toKotlinFixedOffsetTimeZone() instead.", replaceWith=@ReplaceWith(expression="this.toKotlinFixedOffsetTimeZone()", imports={}))
    @NotNull
    public static final FixedOffsetTimeZone toKotlinZoneOffset(@NotNull ZoneOffset $this$toKotlinZoneOffset) {
        Intrinsics.checkNotNullParameter($this$toKotlinZoneOffset, "<this>");
        return ConvertersKt.toKotlinFixedOffsetTimeZone($this$toKotlinZoneOffset);
    }

    @NotNull
    public static final ZoneOffset toJavaZoneOffset(@NotNull UtcOffset $this$toJavaZoneOffset) {
        Intrinsics.checkNotNullParameter($this$toJavaZoneOffset, "<this>");
        return $this$toJavaZoneOffset.getZoneOffset$kotlinx_datetime();
    }

    @NotNull
    public static final UtcOffset toKotlinUtcOffset(@NotNull ZoneOffset $this$toKotlinUtcOffset) {
        Intrinsics.checkNotNullParameter($this$toKotlinUtcOffset, "<this>");
        return new UtcOffset($this$toKotlinUtcOffset);
    }

    @NotNull
    public static final java.time.Month toJavaMonth(@NotNull Month $this$toJavaMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaMonth, "<this>");
        java.time.Month month2 = java.time.Month.of(MonthKt.getNumber($this$toJavaMonth));
        Intrinsics.checkNotNullExpressionValue(month2, "of(...)");
        return month2;
    }

    @NotNull
    public static final Month toKotlinMonth(@NotNull java.time.Month $this$toKotlinMonth) {
        Intrinsics.checkNotNullParameter($this$toKotlinMonth, "<this>");
        return (Month)((Object)Month.getEntries().get($this$toKotlinMonth.getValue() - 1));
    }

    @NotNull
    public static final java.time.DayOfWeek toJavaDayOfWeek(@NotNull DayOfWeek $this$toJavaDayOfWeek) {
        Intrinsics.checkNotNullParameter((Object)$this$toJavaDayOfWeek, "<this>");
        java.time.DayOfWeek dayOfWeek = java.time.DayOfWeek.of(DayOfWeekKt.getIsoDayNumber($this$toJavaDayOfWeek));
        Intrinsics.checkNotNullExpressionValue(dayOfWeek, "of(...)");
        return dayOfWeek;
    }

    @NotNull
    public static final DayOfWeek toKotlinDayOfWeek(@NotNull java.time.DayOfWeek $this$toKotlinDayOfWeek) {
        Intrinsics.checkNotNullParameter($this$toKotlinDayOfWeek, "<this>");
        return (DayOfWeek)((Object)DayOfWeek.getEntries().get($this$toKotlinDayOfWeek.getValue() - 1));
    }

    @NotNull
    public static final java.time.YearMonth toJavaYearMonth(@NotNull YearMonth $this$toJavaYearMonth) {
        Intrinsics.checkNotNullParameter($this$toJavaYearMonth, "<this>");
        return $this$toJavaYearMonth.getValue$kotlinx_datetime();
    }

    @NotNull
    public static final YearMonth toKotlinYearMonth(@NotNull java.time.YearMonth $this$toKotlinYearMonth) {
        Intrinsics.checkNotNullParameter($this$toKotlinYearMonth, "<this>");
        return new YearMonth($this$toKotlinYearMonth);
    }
}

