/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.Clock;
import java.time.DateTimeException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.serializers.InstantSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated(message="Use kotlin.time.Instant instead", replaceWith=@ReplaceWith(expression="kotlin.time.Instant", imports={"kotlin.time.Instant"}), level=DeprecationLevel.WARNING)
@Serializable(with=InstantSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0007\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001)B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0000H\u0087\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0000H\u0097\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0016H\u0096\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010%\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010$\u001a\u0004\b\"\u0010\bR\u001a\u0010(\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b'\u0010$\u001a\u0004\b&\u0010\u001b\u00a8\u0006*"}, d2={"Lkotlinx/datetime/Instant;", "", "Ljava/time/Instant;", "value", "<init>", "(Ljava/time/Instant;)V", "", "toEpochMilliseconds", "()J", "Lkotlin/time/Duration;", "duration", "plus-LRDsOJo", "(J)Lkotlinx/datetime/Instant;", "plus", "minus-LRDsOJo", "minus", "other", "minus-5sfh64U", "(Lkotlinx/datetime/Instant;)J", "", "compareTo", "(Lkotlinx/datetime/Instant;)I", "", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/time/Instant;", "getValue$kotlinx_datetime", "()Ljava/time/Instant;", "getEpochSeconds", "getEpochSeconds$annotations", "()V", "epochSeconds", "getNanosecondsOfSecond", "getNanosecondsOfSecond$annotations", "nanosecondsOfSecond", "Companion", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nDeprecatedInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedInstant.kt\nkotlinx/datetime/Instant\n+ 2 Duration.kt\nkotlin/time/Duration\n*L\n1#1,254:1\n549#2:255\n*S KotlinDebug\n*F\n+ 1 DeprecatedInstant.kt\nkotlinx/datetime/Instant\n*L\n59#1:255\n*E\n"})
public final class Instant
implements Comparable<Instant> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.Instant value;
    @NotNull
    private static final Instant DISTANT_PAST;
    @NotNull
    private static final Instant DISTANT_FUTURE;
    @NotNull
    private static final Instant MIN;
    @NotNull
    private static final Instant MAX;

    public Instant(@NotNull java.time.Instant value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final java.time.Instant getValue$kotlinx_datetime() {
        return this.value;
    }

    public final long getEpochSeconds() {
        return this.value.getEpochSecond();
    }

    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().epochSeconds", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getEpochSeconds$annotations() {
    }

    public final int getNanosecondsOfSecond() {
        return this.value.getNano();
    }

    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().nanosecondsOfSecond", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getNanosecondsOfSecond$annotations() {
    }

    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().nanosecondsOfSecond", imports={}), level=DeprecationLevel.WARNING)
    public final long toEpochMilliseconds() {
        long l;
        try {
            l = this.value.toEpochMilli();
        }
        catch (ArithmeticException e) {
            l = this.value.isAfter(java.time.Instant.EPOCH) ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="(this.toStdlibInstant() + duration).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final Instant plus-LRDsOJo(long duration) {
        Instant instant;
        boolean bl = false;
        int n = Duration.getNanosecondsComponent-impl(duration);
        long seconds = Duration.getInWholeSeconds-impl(duration);
        boolean bl2 = false;
        try {
            void nanoseconds;
            java.time.Instant instant2 = this.value.plusSeconds(seconds).plusNanos((long)nanoseconds);
            Intrinsics.checkNotNullExpressionValue(instant2, "plusNanos(...)");
            instant = new Instant(instant2);
        }
        catch (Exception e) {
            if (!(e instanceof ArithmeticException) && !(e instanceof DateTimeException)) {
                throw e;
            }
            instant = Duration.isPositive-impl(duration) ? MAX : MIN;
        }
        return instant;
    }

    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="(this.toStdlibInstant() - duration).toDeprecatedInstant()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final Instant minus-LRDsOJo(long duration) {
        return this.plus-LRDsOJo(Duration.unaryMinus-UwyO8pc(duration));
    }

    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant() - other.toStdlibInstant()", imports={}), level=DeprecationLevel.WARNING)
    public final long minus-5sfh64U(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Duration.plus-LRDsOJo(DurationKt.toDuration(this.value.getEpochSecond() - other.value.getEpochSecond(), DurationUnit.SECONDS), DurationKt.toDuration(this.value.getNano() - other.value.getNano(), DurationUnit.NANOSECONDS));
    }

    @Override
    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().compareTo(other.toStdlibInstant())", imports={}), level=DeprecationLevel.WARNING)
    public int compareTo(@NotNull Instant other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value.compareTo(other.value);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Instant && Intrinsics.areEqual(this.value, ((Instant)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().toString()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    static {
        java.time.Instant instant = java.time.Instant.ofEpochSecond(-3217862419201L, 999999999L);
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochSecond(...)");
        DISTANT_PAST = new Instant(instant);
        java.time.Instant instant2 = java.time.Instant.ofEpochSecond(3093527980800L, 0L);
        Intrinsics.checkNotNullExpressionValue(instant2, "ofEpochSecond(...)");
        DISTANT_FUTURE = new Instant(instant2);
        java.time.Instant instant3 = java.time.Instant.MIN;
        Intrinsics.checkNotNullExpressionValue(instant3, "MIN");
        MIN = new Instant(instant3);
        java.time.Instant instant4 = java.time.Instant.MAX;
        Intrinsics.checkNotNullExpressionValue(instant4, "MAX");
        MAX = new Instant(instant4);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0019\u00a2\u0006\u0004\b\u0017\u0010\u001aJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010\u0006R\u0017\u0010!\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001f\u001a\u0004\b\"\u0010\u0006R\u001a\u0010#\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010\u0006R\u001a\u0010%\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b%\u0010\u001f\u001a\u0004\b&\u0010\u0006\u00a8\u0006'"}, d2={"Lkotlinx/datetime/Instant$Companion;", "", "<init>", "()V", "Lkotlinx/datetime/Instant;", "now", "()Lkotlinx/datetime/Instant;", "", "epochMilliseconds", "fromEpochMilliseconds", "(J)Lkotlinx/datetime/Instant;", "", "input", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "format", "parse", "(Ljava/lang/CharSequence;Lkotlinx/datetime/format/DateTimeFormat;)Lkotlinx/datetime/Instant;", "", "isoString", "(Ljava/lang/String;)Lkotlinx/datetime/Instant;", "epochSeconds", "nanosecondAdjustment", "fromEpochSeconds", "(JJ)Lkotlinx/datetime/Instant;", "", "(JI)Lkotlinx/datetime/Instant;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "DISTANT_PAST", "Lkotlinx/datetime/Instant;", "getDISTANT_PAST", "DISTANT_FUTURE", "getDISTANT_FUTURE", "MIN", "getMIN$kotlinx_datetime", "MAX", "getMAX$kotlinx_datetime", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use Clock.System.now() instead", replaceWith=@ReplaceWith(expression="Clock.System.now()", imports={"kotlin.time.Clock"}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Instant now() {
            java.time.Instant instant = Clock.systemUTC().instant();
            Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
            return new Instant(instant);
        }

        @NotNull
        public final Instant fromEpochMilliseconds(long epochMilliseconds) {
            java.time.Instant instant = java.time.Instant.ofEpochMilli(epochMilliseconds);
            Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(...)");
            return new Instant(instant);
        }

        @NotNull
        public final Instant parse(@NotNull CharSequence input, @NotNull DateTimeFormat<DateTimeComponents> format) {
            Instant instant;
            Intrinsics.checkNotNullParameter(input, "input");
            Intrinsics.checkNotNullParameter(format, "format");
            try {
                instant = InstantKt.toDeprecatedInstant(DateTimeComponents.toInstantUsingOffset$default(format.parse(input), null, 1, null));
            }
            catch (IllegalArgumentException e) {
                throw new DateTimeFormatException("Failed to parse an instant from '" + input + '\'', e);
            }
            return instant;
        }

        public static /* synthetic */ Instant parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = DateTimeComponents.Formats.INSTANCE.getISO_DATE_TIME_OFFSET();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        @Deprecated(message="This overload is only kept for binary compatibility", level=DeprecationLevel.HIDDEN)
        public final /* synthetic */ Instant parse(String isoString) {
            Intrinsics.checkNotNullParameter(isoString, "isoString");
            return kotlinx.datetime.Instant$Companion.parse$default(this, isoString, null, 2, null);
        }

        @NotNull
        public final Instant fromEpochSeconds(long epochSeconds, long nanosecondAdjustment) {
            Instant instant;
            try {
                java.time.Instant instant2 = java.time.Instant.ofEpochSecond(epochSeconds, nanosecondAdjustment);
                Intrinsics.checkNotNullExpressionValue(instant2, "ofEpochSecond(...)");
                instant = new Instant(instant2);
            }
            catch (Exception e) {
                if (!(e instanceof ArithmeticException) && !(e instanceof DateTimeException)) {
                    throw e;
                }
                instant = epochSeconds > 0L ? this.getMAX$kotlinx_datetime() : this.getMIN$kotlinx_datetime();
            }
            return instant;
        }

        public static /* synthetic */ Instant fromEpochSeconds$default(Companion companion, long l, long l2, int n, Object object) {
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            return companion.fromEpochSeconds(l, l2);
        }

        @NotNull
        public final Instant fromEpochSeconds(long epochSeconds, int nanosecondAdjustment) {
            return this.fromEpochSeconds(epochSeconds, (long)nanosecondAdjustment);
        }

        @NotNull
        public final Instant getDISTANT_PAST() {
            return DISTANT_PAST;
        }

        @NotNull
        public final Instant getDISTANT_FUTURE() {
            return DISTANT_FUTURE;
        }

        @NotNull
        public final Instant getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final Instant getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final KSerializer<Instant> serializer() {
            return InstantSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

