/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Clock;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.ExperimentalTime;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0015H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u0016*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010#\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010(\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010)R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010*\u00a8\u0006+"}, d2={"Lkotlinx/datetime/InstantTimeMark;", "Lkotlin/time/ComparableTimeMark;", "Lkotlin/time/Instant;", "instant", "Lkotlin/time/Clock;", "clock", "<init>", "(Lkotlin/time/Instant;Lkotlin/time/Clock;)V", "Lkotlin/time/Duration;", "elapsedNow-UwyO8pc", "()J", "elapsedNow", "duration", "plus-LRDsOJo", "(J)Lkotlin/time/ComparableTimeMark;", "plus", "minus-LRDsOJo", "minus", "other", "minus-5sfh64U", "(Lkotlin/time/ComparableTimeMark;)J", "", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "isSaturated", "(Lkotlin/time/Instant;)Z", "saturatingAdd-HG0u8IE", "(Lkotlin/time/Instant;J)Lkotlin/time/Instant;", "saturatingAdd", "instant1", "instant2", "saturatingDiff-3nIYWDw", "(Lkotlin/time/Instant;Lkotlin/time/Instant;)J", "saturatingDiff", "Lkotlin/time/Instant;", "Lkotlin/time/Clock;", "kotlinx-datetime"})
@ExperimentalTime
final class InstantTimeMark
implements ComparableTimeMark {
    @NotNull
    private final Instant instant;
    @NotNull
    private final Clock clock;

    public InstantTimeMark(@NotNull Instant instant, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(instant, "instant");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.instant = instant;
        this.clock = clock;
    }

    @Override
    public long elapsedNow-UwyO8pc() {
        return this.saturatingDiff-3nIYWDw(this.clock.now(), this.instant);
    }

    @Override
    @NotNull
    public ComparableTimeMark plus-LRDsOJo(long duration) {
        return new InstantTimeMark(this.saturatingAdd-HG0u8IE(this.instant, duration), this.clock);
    }

    @Override
    @NotNull
    public ComparableTimeMark minus-LRDsOJo(long duration) {
        return new InstantTimeMark(this.saturatingAdd-HG0u8IE(this.instant, Duration.unaryMinus-UwyO8pc(duration)), this.clock);
    }

    public long minus-5sfh64U(@NotNull ComparableTimeMark other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (!(other instanceof InstantTimeMark) || !Intrinsics.areEqual(((InstantTimeMark)other).clock, this.clock)) {
            throw new IllegalArgumentException("Subtracting or comparing time marks from different time sources is not possible: " + this + " and " + other);
        }
        return this.saturatingDiff-3nIYWDw(this.instant, ((InstantTimeMark)other).instant);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof InstantTimeMark && Intrinsics.areEqual(this.clock, ((InstantTimeMark)other).clock) && Intrinsics.areEqual(this.instant, ((InstantTimeMark)other).instant);
    }

    @Override
    public int hashCode() {
        return this.instant.hashCode();
    }

    @NotNull
    public String toString() {
        return "InstantTimeMark(" + this.instant + ", " + this.clock + ')';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSaturated(Instant $this$isSaturated) {
        if (Intrinsics.areEqual($this$isSaturated.plus-LRDsOJo(DurationKt.toDuration(1, DurationUnit.SECONDS)), $this$isSaturated)) return true;
        if (!Intrinsics.areEqual($this$isSaturated.plus-LRDsOJo(DurationKt.toDuration(-1, DurationUnit.SECONDS)), $this$isSaturated)) return false;
        return true;
    }

    private final Instant saturatingAdd-HG0u8IE(Instant $this$saturatingAdd_u2dHG0u8IE, long duration) {
        if (this.isSaturated($this$saturatingAdd_u2dHG0u8IE)) {
            if (Duration.isInfinite-impl(duration) && Duration.isPositive-impl(duration) != $this$saturatingAdd_u2dHG0u8IE.compareTo(Instant.Companion.getDISTANT_FUTURE()) >= 0) {
                throw new IllegalArgumentException("Summing infinities of different signs");
            }
            return $this$saturatingAdd_u2dHG0u8IE;
        }
        return $this$saturatingAdd_u2dHG0u8IE.plus-LRDsOJo(duration);
    }

    private final long saturatingDiff-3nIYWDw(Instant instant1, Instant instant2) {
        return Intrinsics.areEqual(instant1, instant2) ? Duration.Companion.getZERO-UwyO8pc() : (this.isSaturated(instant1) || this.isSaturated(instant2) ? Duration.times-UwyO8pc(instant1.minus-UwyO8pc(instant2), Double.POSITIVE_INFINITY) : instant1.minus-UwyO8pc(instant2));
    }

    @Override
    public int compareTo(@NotNull ComparableTimeMark other) {
        return ComparableTimeMark.DefaultImpls.compareTo(this, other);
    }

    @Override
    public boolean hasPassedNow() {
        return ComparableTimeMark.DefaultImpls.hasPassedNow(this);
    }

    @Override
    public boolean hasNotPassedNow() {
        return ComparableTimeMark.DefaultImpls.hasNotPassedNow(this);
    }
}

