/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.FixedOffsetTimeZone;
import kotlinx.datetime.IllegalTimeZoneException;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.OverloadMarker;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.TimeZoneKt__TimeZoneJvmKt;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.serializers.TimeZoneSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=TimeZoneSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0017\u0018\u0000  2\u00020\u0001:\u0001 B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u0007*\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\f\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\b\u001a\u00020\u0007*\u00020\u000eH\u0007\u00a2\u0006\u0004\b\b\u0010\u000fJ\u0013\u0010\f\u001a\u00020\u000e*\u00020\u0007H\u0001\u00a2\u0006\u0004\b\f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001f\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006!"}, d2={"Lkotlinx/datetime/TimeZone;", "", "Ljava/time/ZoneId;", "zoneId", "<init>", "(Ljava/time/ZoneId;)V", "Lkotlin/time/Instant;", "Lkotlinx/datetime/LocalDateTime;", "toLocalDateTime", "(Lkotlin/time/Instant;)Lkotlinx/datetime/LocalDateTime;", "Lkotlinx/datetime/OverloadMarker;", "youShallNotPass", "toInstant", "(Lkotlinx/datetime/LocalDateTime;Lkotlinx/datetime/OverloadMarker;)Lkotlin/time/Instant;", "Lkotlinx/datetime/Instant;", "(Lkotlinx/datetime/Instant;)Lkotlinx/datetime/LocalDateTime;", "(Lkotlinx/datetime/LocalDateTime;)Lkotlinx/datetime/Instant;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/time/ZoneId;", "getZoneId$kotlinx_datetime", "()Ljava/time/ZoneId;", "getId", "id", "Companion", "kotlinx-datetime"})
public class TimeZone {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoneId zoneId;
    @NotNull
    private static final FixedOffsetTimeZone UTC;

    public TimeZone(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter(zoneId, "zoneId");
        this.zoneId = zoneId;
    }

    @NotNull
    public final ZoneId getZoneId$kotlinx_datetime() {
        return this.zoneId;
    }

    @NotNull
    public final String getId() {
        String string = this.zoneId.getId();
        Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
        return string;
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull kotlin.time.Instant $this$toLocalDateTime) {
        Intrinsics.checkNotNullParameter($this$toLocalDateTime, "<this>");
        return TimeZoneKt.toLocalDateTime($this$toLocalDateTime, this);
    }

    @NotNull
    public final kotlin.time.Instant toInstant(@NotNull LocalDateTime $this$toInstant, @NotNull OverloadMarker youShallNotPass) {
        Intrinsics.checkNotNullParameter($this$toInstant, "<this>");
        Intrinsics.checkNotNullParameter(youShallNotPass, "youShallNotPass");
        return TimeZoneKt.toInstant$default($this$toInstant, this, null, 2, null);
    }

    public static /* synthetic */ kotlin.time.Instant toInstant$default(TimeZone timeZone, LocalDateTime localDateTime, OverloadMarker overloadMarker, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toInstant");
        }
        if ((n & 1) != 0) {
            overloadMarker = OverloadMarker.Companion.getINSTANCE$kotlinx_datetime();
        }
        return timeZone.toInstant(localDateTime, overloadMarker);
    }

    @Deprecated(message="kotlinx.datetime.Instant is superseded by kotlin.time.Instant", replaceWith=@ReplaceWith(expression="this.toStdlibInstant().toLocalDateTime()", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull Instant $this$toLocalDateTime) {
        Intrinsics.checkNotNullParameter($this$toLocalDateTime, "<this>");
        return this.toLocalDateTime(InstantKt.toStdlibInstant($this$toLocalDateTime));
    }

    @PublishedApi
    @LowPriorityInOverloadResolution
    @NotNull
    public final Instant toInstant(@NotNull LocalDateTime $this$toInstant) {
        Intrinsics.checkNotNullParameter($this$toInstant, "<this>");
        return InstantKt.toDeprecatedInstant(TimeZoneKt.toInstant$default($this$toInstant, this, null, 2, null));
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TimeZone && Intrinsics.areEqual(this.zoneId, ((TimeZone)other).zoneId);
    }

    public int hashCode() {
        return this.zoneId.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.zoneId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    static {
        UtcOffset utcOffset = UtcOffset.Companion.getZERO();
        ZoneId zoneId = ZoneId.of("UTC");
        Intrinsics.checkNotNullExpressionValue(zoneId, "of(...)");
        UTC = new FixedOffsetTimeZone(utcOffset, zoneId);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lkotlinx/datetime/TimeZone$Companion;", "", "<init>", "()V", "Lkotlinx/datetime/TimeZone;", "currentSystemDefault", "()Lkotlinx/datetime/TimeZone;", "", "zoneId", "of", "(Ljava/lang/String;)Lkotlinx/datetime/TimeZone;", "Ljava/time/ZoneId;", "ofZone$kotlinx_datetime", "(Ljava/time/ZoneId;)Lkotlinx/datetime/TimeZone;", "ofZone", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/FixedOffsetTimeZone;", "UTC", "Lkotlinx/datetime/FixedOffsetTimeZone;", "getUTC", "()Lkotlinx/datetime/FixedOffsetTimeZone;", "", "getAvailableZoneIds", "()Ljava/util/Set;", "availableZoneIds", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeZone currentSystemDefault() {
            ZoneId zoneId = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue(zoneId, "systemDefault(...)");
            return this.ofZone$kotlinx_datetime(zoneId);
        }

        @NotNull
        public final FixedOffsetTimeZone getUTC() {
            return UTC;
        }

        @NotNull
        public final TimeZone of(@NotNull String zoneId) {
            TimeZone timeZone;
            Intrinsics.checkNotNullParameter(zoneId, "zoneId");
            try {
                ZoneId zoneId2 = ZoneId.of(Intrinsics.areEqual(zoneId, "z") ? "Z" : zoneId);
                Intrinsics.checkNotNullExpressionValue(zoneId2, "of(...)");
                timeZone = this.ofZone$kotlinx_datetime(zoneId2);
            }
            catch (Exception e) {
                if (e instanceof DateTimeException) {
                    throw new IllegalTimeZoneException(e);
                }
                throw e;
            }
            return timeZone;
        }

        @NotNull
        public final TimeZone ofZone$kotlinx_datetime(@NotNull ZoneId zoneId) {
            TimeZone timeZone;
            Intrinsics.checkNotNullParameter(zoneId, "zoneId");
            if (zoneId instanceof ZoneOffset) {
                timeZone = new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId));
            } else if (TimeZoneKt__TimeZoneJvmKt.access$isFixedOffset(zoneId)) {
                ZoneId zoneId2 = zoneId.normalized();
                Intrinsics.checkNotNull(zoneId2, "null cannot be cast to non-null type java.time.ZoneOffset");
                timeZone = new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId2), zoneId);
            } else {
                timeZone = new TimeZone(zoneId);
            }
            return timeZone;
        }

        @NotNull
        public final Set<String> getAvailableZoneIds() {
            Set<String> set = ZoneId.getAvailableZoneIds();
            Intrinsics.checkNotNullExpressionValue(set, "getAvailableZoneIds(...)");
            return set;
        }

        @NotNull
        public final KSerializer<TimeZone> serializer() {
            return TimeZoneSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

