/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.format;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.YearMonth;
import kotlinx.datetime.format.AbstractWithYearMonthBuilder;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import kotlinx.datetime.format.IncompleteYearMonth;
import kotlinx.datetime.format.MonthNames;
import kotlinx.datetime.format.Padding;
import kotlinx.datetime.format.ReducedYearDirective;
import kotlinx.datetime.format.YearDirective;
import kotlinx.datetime.format.YearMonthFormat;
import kotlinx.datetime.format.YearMonthFormatKt;
import kotlinx.datetime.internal.format.BasicFormatStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a'\u0010\u0007\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u001b\u0010\r\u001a\u00020\f*\u00020\t2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001b\u0010\u0011\u001a\u00020\f*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\"\u0014\u0010\u0013\u001a\u00020\u00018\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\"\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\"!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lkotlinx/datetime/format/MonthNames;", "", "toKotlinCode", "(Lkotlinx/datetime/format/MonthNames;)Ljava/lang/String;", "T", "field", "name", "requireParsedField", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithYearMonth;", "Lkotlinx/datetime/format/Padding;", "padding", "", "yearOfEra", "(Lkotlinx/datetime/format/DateTimeFormatBuilder$WithYearMonth;Lkotlinx/datetime/format/Padding;)V", "", "baseYear", "yearOfEraTwoDigits", "(Lkotlinx/datetime/format/DateTimeFormatBuilder$WithYearMonth;I)V", "YEAR_OF_ERA_COMMENT", "Ljava/lang/String;", "Lkotlinx/datetime/format/IncompleteYearMonth;", "emptyIncompleteYearMonth", "Lkotlinx/datetime/format/IncompleteYearMonth;", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/YearMonth;", "ISO_YEAR_MONTH$delegate", "Lkotlin/Lazy;", "getISO_YEAR_MONTH", "()Lkotlinx/datetime/format/DateTimeFormat;", "ISO_YEAR_MONTH", "kotlinx-datetime"})
public final class YearMonthFormatKt {
    @NotNull
    private static final String YEAR_OF_ERA_COMMENT = " /** TODO: the original format had an `y` directive, so the behavior is different on years earlier than 1 AD. See the [kotlinx.datetime.format.byUnicodePattern] documentation for details. */";
    @NotNull
    private static final IncompleteYearMonth emptyIncompleteYearMonth = new IncompleteYearMonth(null, null, 3, null);
    @NotNull
    private static final Lazy ISO_YEAR_MONTH$delegate = LazyKt.lazy(YearMonthFormatKt::ISO_YEAR_MONTH_delegate$lambda$1);

    private static final String toKotlinCode(MonthNames $this$toKotlinCode) {
        List<String> list = $this$toKotlinCode.getNames();
        return Intrinsics.areEqual(list, MonthNames.Companion.getENGLISH_FULL().getNames()) ? "MonthNames." + "ENGLISH_FULL" : (Intrinsics.areEqual(list, MonthNames.Companion.getENGLISH_ABBREVIATED().getNames()) ? "MonthNames." + "ENGLISH_ABBREVIATED" : CollectionsKt.joinToString$default($this$toKotlinCode.getNames(), ", ", "MonthNames(", ")", 0, null, toKotlinCode.1.INSTANCE, 24, null));
    }

    public static final <T> T requireParsedField(@Nullable T field, @NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (field == null) {
            throw new DateTimeFormatException("Can not create a " + name + " from the given input: the field " + name + " is missing");
        }
        return field;
    }

    public static final void yearOfEra(@NotNull DateTimeFormatBuilder.WithYearMonth $this$yearOfEra, @NotNull Padding padding) {
        Intrinsics.checkNotNullParameter($this$yearOfEra, "<this>");
        Intrinsics.checkNotNullParameter((Object)padding, "padding");
        if ($this$yearOfEra instanceof AbstractWithYearMonthBuilder) {
            ((AbstractWithYearMonthBuilder)$this$yearOfEra).addFormatStructureForYearMonth(new BasicFormatStructure(new YearDirective(padding, true)));
        }
    }

    public static final void yearOfEraTwoDigits(@NotNull DateTimeFormatBuilder.WithYearMonth $this$yearOfEraTwoDigits, int baseYear) {
        Intrinsics.checkNotNullParameter($this$yearOfEraTwoDigits, "<this>");
        if ($this$yearOfEraTwoDigits instanceof AbstractWithYearMonthBuilder) {
            ((AbstractWithYearMonthBuilder)$this$yearOfEraTwoDigits).addFormatStructureForYearMonth(new BasicFormatStructure(new ReducedYearDirective(baseYear, true)));
        }
    }

    @NotNull
    public static final DateTimeFormat<YearMonth> getISO_YEAR_MONTH() {
        Lazy lazy = ISO_YEAR_MONTH$delegate;
        return (DateTimeFormat)lazy.getValue();
    }

    private static final Unit ISO_YEAR_MONTH_delegate$lambda$1$lambda$0(DateTimeFormatBuilder.WithYearMonth $this$build) {
        Intrinsics.checkNotNullParameter($this$build, "$this$build");
        DateTimeFormatBuilder.WithYearMonth.year$default($this$build, null, 1, null);
        DateTimeFormatBuilderKt.char($this$build, '-');
        DateTimeFormatBuilder.WithYearMonth.monthNumber$default($this$build, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final DateTimeFormat ISO_YEAR_MONTH_delegate$lambda$1() {
        return YearMonthFormat.Companion.build(YearMonthFormatKt::ISO_YEAR_MONTH_delegate$lambda$1$lambda$0);
    }

    public static final /* synthetic */ String access$toKotlinCode(MonthNames $receiver) {
        return YearMonthFormatKt.toKotlinCode($receiver);
    }

    public static final /* synthetic */ IncompleteYearMonth access$getEmptyIncompleteYearMonth$p() {
        return emptyIncompleteYearMonth;
    }
}

