/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.formatter;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u00028\u00000\u0002B+\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00028\u00002\n\u0010\r\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lkotlinx/datetime/internal/format/formatter/ReducedIntFormatterStructure;", "T", "Lkotlinx/datetime/internal/format/formatter/FormatterStructure;", "Lkotlin/Function1;", "", "number", "digits", "base", "<init>", "(Lkotlin/jvm/functions/Function1;II)V", "obj", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "builder", "", "minusNotRequired", "", "format", "(Ljava/lang/Object;Ljava/lang/Appendable;Z)V", "Lkotlin/jvm/functions/Function1;", "I", "kotlinx-datetime"})
public final class ReducedIntFormatterStructure<T>
implements FormatterStructure<T> {
    @NotNull
    private final Function1<T, Integer> number;
    private final int digits;
    private final int base;

    public ReducedIntFormatterStructure(@NotNull Function1<? super T, Integer> number, int digits, int base) {
        Intrinsics.checkNotNullParameter(number, "number");
        this.number = number;
        this.digits = digits;
        this.base = base;
    }

    @Override
    public void format(T obj, @NotNull Appendable builder, boolean minusNotRequired) {
        Appendable appendable;
        Intrinsics.checkNotNullParameter(builder, "builder");
        int number = ((Number)this.number.invoke(obj)).intValue();
        int n = MathKt.getPOWERS_OF_TEN()[this.digits];
        int n2 = number - this.base;
        boolean bl = 0 <= n2 ? n2 < n : false;
        if (bl) {
            String numberStr = String.valueOf(number % MathKt.getPOWERS_OF_TEN()[this.digits]);
            String zeroPaddingStr = StringsKt.repeat("0", Math.max(0, this.digits - numberStr.length()));
            CharSequence[] charSequenceArray = new CharSequence[]{zeroPaddingStr, numberStr};
            appendable = StringsKt.append(builder, charSequenceArray);
        } else {
            if (number >= 0) {
                builder.append("+");
            }
            appendable = builder.append(String.valueOf(number));
        }
    }
}

