/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.format.parser.AssignableField;
import kotlinx.datetime.internal.format.parser.NumberConsumer;
import kotlinx.datetime.internal.format.parser.NumberConsumerKt;
import kotlinx.datetime.internal.format.parser.NumberConsumptionError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u00028\u00000\u0002B3\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0017R\u0017\u0010\t\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0014\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0014R\u0014\u0010\u001b\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0014R\u0014\u0010\u001c\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lkotlinx/datetime/internal/format/parser/ReducedIntConsumer;", "Receiver", "Lkotlinx/datetime/internal/format/parser/NumberConsumer;", "", "length", "Lkotlinx/datetime/internal/format/parser/AssignableField;", "setter", "", "name", "base", "<init>", "(ILkotlinx/datetime/internal/format/parser/AssignableField;Ljava/lang/String;I)V", "storage", "", "input", "start", "end", "Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "consume", "(Ljava/lang/Object;Ljava/lang/CharSequence;II)Lkotlinx/datetime/internal/format/parser/NumberConsumptionError;", "I", "getLength", "()Ljava/lang/Integer;", "Lkotlinx/datetime/internal/format/parser/AssignableField;", "getBase", "()I", "modulo", "baseMod", "baseFloor", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nNumberConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberConsumer.kt\nkotlinx/datetime/internal/format/parser/ReducedIntConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class ReducedIntConsumer<Receiver>
extends NumberConsumer<Receiver> {
    private final int length;
    @NotNull
    private final AssignableField<Receiver, Integer> setter;
    private final int base;
    private final int modulo;
    private final int baseMod;
    private final int baseFloor;

    public ReducedIntConsumer(int length, @NotNull AssignableField<? super Receiver, Integer> setter, @NotNull String name, int base) {
        Intrinsics.checkNotNullParameter(setter, "setter");
        Intrinsics.checkNotNullParameter(name, "name");
        super(length, name, null);
        this.length = length;
        this.setter = setter;
        this.base = base;
        this.modulo = MathKt.getPOWERS_OF_TEN()[this.getLength()];
        this.baseMod = this.base % this.modulo;
        this.baseFloor = this.base - this.baseMod;
        int n = this.getLength();
        if (!(1 <= n ? n < 10 : false)) {
            boolean bl = false;
            String string = "Invalid length for field " + this.getWhatThisExpects() + ": " + this.getLength();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public Integer getLength() {
        return this.length;
    }

    public final int getBase() {
        return this.base;
    }

    @Override
    @Nullable
    public NumberConsumptionError consume(Receiver storage, @NotNull CharSequence input, int start, int end) {
        Intrinsics.checkNotNullParameter(input, "input");
        int result = NumberConsumerKt.access$parseAsciiInt(input, start, end);
        return NumberConsumerKt.access$setWithoutReassigning(this.setter, storage, result >= this.baseMod ? this.baseFloor + result : this.baseFloor + this.modulo + result);
    }
}

