/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.io.RefCountingCopyTracker;
import kotlinx.io.Segment;
import kotlinx.io.SegmentCopyTracker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u00108\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001e\u0010\u0012R\u0014\u0010\u001f\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0019R\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u00108\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b#\u0010\u0019\u001a\u0004\b$\u0010\u0012R\u0014\u0010%\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\u0019R\u001c\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001c\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0011\u0010+\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0012\u00a8\u0006,"}, d2={"Lkotlinx/io/SegmentPool;", "", "<init>", "()V", "Lkotlinx/io/Segment;", "take", "()Lkotlinx/io/Segment;", "takeL2", "segment", "", "recycle", "(Lkotlinx/io/Segment;)V", "recycleL2", "Lkotlinx/io/SegmentCopyTracker;", "tracker", "()Lkotlinx/io/SegmentCopyTracker;", "", "l1BucketId", "()I", "l2BucketId", "", "mask", "bucketId", "(J)I", "MAX_SIZE", "I", "getMAX_SIZE", "LOCK", "Lkotlinx/io/Segment;", "HASH_BUCKET_COUNT", "getHASH_BUCKET_COUNT$kotlinx_io_core", "HASH_BUCKET_COUNT_L2", "", "DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE", "Ljava/lang/String;", "SECOND_LEVEL_POOL_TOTAL_SIZE", "getSECOND_LEVEL_POOL_TOTAL_SIZE$kotlinx_io_core", "SECOND_LEVEL_POOL_BUCKET_SIZE", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "hashBuckets", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "hashBucketsL2", "getByteCount", "byteCount", "kotlinx-io-core"})
public final class SegmentPool {
    @NotNull
    public static final SegmentPool INSTANCE = new SegmentPool();
    private static final int MAX_SIZE = 65536;
    @NotNull
    private static final Segment LOCK = Segment.Companion.new$kotlinx_io_core(new byte[0], 0, 0, null, false);
    private static final int HASH_BUCKET_COUNT = Integer.highestOneBit(Runtime.getRuntime().availableProcessors() * 2 - 1);
    private static final int HASH_BUCKET_COUNT_L2 = RangesKt.coerceAtLeast(HASH_BUCKET_COUNT / 2, 1);
    @NotNull
    private static final String DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE = Intrinsics.areEqual(System.getProperty("java.vm.name"), "Dalvik") ? "0" : "4194304";
    private static final int SECOND_LEVEL_POOL_TOTAL_SIZE;
    private static final int SECOND_LEVEL_POOL_BUCKET_SIZE;
    @NotNull
    private static final AtomicReferenceArray<Segment> hashBuckets;
    @NotNull
    private static final AtomicReferenceArray<Segment> hashBucketsL2;

    private SegmentPool() {
    }

    public final int getMAX_SIZE() {
        return MAX_SIZE;
    }

    public final int getHASH_BUCKET_COUNT$kotlinx_io_core() {
        return HASH_BUCKET_COUNT;
    }

    public final int getSECOND_LEVEL_POOL_TOTAL_SIZE$kotlinx_io_core() {
        return SECOND_LEVEL_POOL_TOTAL_SIZE;
    }

    public final int getByteCount() {
        Segment segment = hashBuckets.get(this.l1BucketId());
        if (segment == null) {
            return 0;
        }
        Segment first2 = segment;
        return first2.getLimit();
    }

    @JvmStatic
    @NotNull
    public static final Segment take() {
        Segment first2;
        AtomicReferenceArray<Segment> buckets = hashBuckets;
        int bucketId = INSTANCE.l1BucketId();
        while (Intrinsics.areEqual(first2 = buckets.getAndSet(bucketId, LOCK), LOCK)) {
        }
        if (first2 == null) {
            buckets.set(bucketId, null);
            if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                return INSTANCE.takeL2();
            }
            return Segment.Companion.new$kotlinx_io_core();
        }
        buckets.set(bucketId, first2.getNext());
        first2.setNext(null);
        first2.setLimit(0);
        return first2;
    }

    @JvmStatic
    private static final Segment takeL2() {
        Segment first2;
        int bucket;
        AtomicReferenceArray<Segment> buckets;
        block2: {
            buckets = hashBucketsL2;
            bucket = INSTANCE.l2BucketId();
            int attempts = 0;
            while (true) {
                if (Intrinsics.areEqual(first2 = buckets.getAndSet(bucket, LOCK), LOCK)) {
                    continue;
                }
                if (first2 != null) break block2;
                buckets.set(bucket, null);
                if (attempts >= HASH_BUCKET_COUNT_L2) break;
                bucket = bucket + 1 & HASH_BUCKET_COUNT_L2 - 1;
                ++attempts;
            }
            return Segment.Companion.new$kotlinx_io_core();
        }
        buckets.set(bucket, first2.getNext());
        first2.setNext(null);
        first2.setLimit(0);
        return first2;
    }

    @JvmStatic
    public static final void recycle(@NotNull Segment segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        if (!(segment.getNext() == null && segment.getPrev() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SegmentCopyTracker segmentCopyTracker = segment.getCopyTracker$kotlinx_io_core();
        boolean bl = segmentCopyTracker != null ? segmentCopyTracker.removeCopy() : false;
        if (bl) {
            return;
        }
        AtomicReferenceArray<Segment> buckets = hashBuckets;
        int bucketId = INSTANCE.l1BucketId();
        segment.setPos(0);
        segment.owner = true;
        while (true) {
            Segment first2;
            if ((first2 = buckets.get(bucketId)) == LOCK) {
                continue;
            }
            Segment segment2 = first2;
            int firstLimit = segment2 != null ? segment2.getLimit() : 0;
            if (firstLimit >= MAX_SIZE) {
                if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                    SegmentPool.recycleL2(segment);
                }
                return;
            }
            segment.setNext(first2);
            segment.setLimit(firstLimit + 8192);
            if (buckets.compareAndSet(bucketId, first2, segment)) break;
        }
    }

    @JvmStatic
    private static final void recycleL2(Segment segment) {
        segment.setPos(0);
        segment.owner = true;
        int bucket = INSTANCE.l2BucketId();
        AtomicReferenceArray<Segment> buckets = hashBucketsL2;
        int attempts = 0;
        while (true) {
            int firstLimit;
            Segment first2;
            if ((first2 = buckets.get(bucket)) == LOCK) {
                continue;
            }
            Segment segment2 = first2;
            int n = firstLimit = segment2 != null ? segment2.getLimit() : 0;
            if (firstLimit + 8192 > SECOND_LEVEL_POOL_BUCKET_SIZE) {
                if (attempts < HASH_BUCKET_COUNT_L2) {
                    ++attempts;
                    bucket = bucket + 1 & HASH_BUCKET_COUNT_L2 - 1;
                    continue;
                }
                return;
            }
            segment.setNext(first2);
            segment.setLimit(firstLimit + 8192);
            if (buckets.compareAndSet(bucket, first2, segment)) break;
        }
    }

    @JvmStatic
    @NotNull
    public static final SegmentCopyTracker tracker() {
        return new RefCountingCopyTracker();
    }

    private final int l1BucketId() {
        return this.bucketId((long)HASH_BUCKET_COUNT - 1L);
    }

    private final int l2BucketId() {
        return this.bucketId((long)HASH_BUCKET_COUNT_L2 - 1L);
    }

    private final int bucketId(long mask) {
        return (int)(Thread.currentThread().getId() & mask);
    }

    static {
        String string = System.getProperty("kotlinx.io.pool.size.bytes", DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE);
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(...)");
        Integer n = StringsKt.toIntOrNull(string);
        SECOND_LEVEL_POOL_TOTAL_SIZE = n != null ? RangesKt.coerceAtLeast(n, 0) : 0;
        SECOND_LEVEL_POOL_BUCKET_SIZE = RangesKt.coerceAtLeast(SECOND_LEVEL_POOL_TOTAL_SIZE / HASH_BUCKET_COUNT_L2, 8192);
        hashBuckets = new AtomicReferenceArray(HASH_BUCKET_COUNT);
        hashBucketsL2 = new AtomicReferenceArray(HASH_BUCKET_COUNT_L2);
    }
}

