/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u0015"}, d2={"Lkotlinx/serialization/cbor/internal/ByteArrayInput;", "", "", "array", "<init>", "([B)V", "", "read", "()I", "b", "offset", "length", "([BII)I", "", "skip", "(I)V", "[B", "position", "I", "getAvailableBytes", "availableBytes", "kotlinx-serialization-cbor"})
public final class ByteArrayInput {
    @NotNull
    private byte[] array;
    private int position;

    public ByteArrayInput(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        this.array = array;
    }

    public final int getAvailableBytes() {
        return this.array.length - this.position;
    }

    public final int read() {
        int n;
        if (this.position < this.array.length) {
            int n2 = this.position;
            this.position = n2 + 1;
            n = this.array[n2] & 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    public final int read(@NotNull byte[] b, int offset, int length) {
        Intrinsics.checkNotNullParameter(b, "b");
        if (offset < 0 || offset > b.length || length < 0 || length > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.array.length) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int copied = this.array.length - this.position < length ? this.array.length - this.position : length;
        ArraysKt.copyInto(this.array, b, offset, this.position, this.position + copied);
        this.position += copied;
        return copied;
    }

    public final void skip(int length) {
        this.position += length;
    }
}

