/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.YearMonth;
import kotlinx.datetime.YearMonthKt;
import kotlinx.datetime.YearMonthProgression;
import kotlinx.datetime.internal.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0003\u001a\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0003\u001a\u0011\u0010\u0007\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a!\u0010\r\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000e\u001a!\u0010\r\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u0010\u001a\u001c\u0010\u0012\u001a\u00020\u0000*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0086\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001b\u0010\u0015\u001a\u00020\u0001*\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lkotlinx/datetime/YearMonthProgression;", "Lkotlinx/datetime/YearMonth;", "first", "(Lkotlinx/datetime/YearMonthProgression;)Lkotlinx/datetime/YearMonth;", "last", "firstOrNull", "lastOrNull", "reversed", "(Lkotlinx/datetime/YearMonthProgression;)Lkotlinx/datetime/YearMonthProgression;", "", "value", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "unit", "step", "(Lkotlinx/datetime/YearMonthProgression;ILkotlinx/datetime/DateTimeUnit$MonthBased;)Lkotlinx/datetime/YearMonthProgression;", "", "(Lkotlinx/datetime/YearMonthProgression;JLkotlinx/datetime/DateTimeUnit$MonthBased;)Lkotlinx/datetime/YearMonthProgression;", "that", "downTo", "(Lkotlinx/datetime/YearMonth;Lkotlinx/datetime/YearMonth;)Lkotlinx/datetime/YearMonthProgression;", "Lkotlin/random/Random;", "random", "(Lkotlinx/datetime/YearMonthProgression;Lkotlin/random/Random;)Lkotlinx/datetime/YearMonth;", "randomOrNull", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nYearMonthRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YearMonthRange.kt\nkotlinx/datetime/YearMonthRangeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
public final class YearMonthRangeKt {
    @NotNull
    public static final YearMonth first(@NotNull YearMonthProgression $this$first) {
        Intrinsics.checkNotNullParameter($this$first, "<this>");
        if ($this$first.isEmpty()) {
            throw new NoSuchElementException("Progression " + $this$first + " is empty.");
        }
        return $this$first.getFirst();
    }

    @NotNull
    public static final YearMonth last(@NotNull YearMonthProgression $this$last) {
        Intrinsics.checkNotNullParameter($this$last, "<this>");
        if ($this$last.isEmpty()) {
            throw new NoSuchElementException("Progression " + $this$last + " is empty.");
        }
        return $this$last.getLast();
    }

    @Nullable
    public static final YearMonth firstOrNull(@NotNull YearMonthProgression $this$firstOrNull) {
        Intrinsics.checkNotNullParameter($this$firstOrNull, "<this>");
        return $this$firstOrNull.isEmpty() ? null : $this$firstOrNull.getFirst();
    }

    @Nullable
    public static final YearMonth lastOrNull(@NotNull YearMonthProgression $this$lastOrNull) {
        Intrinsics.checkNotNullParameter($this$lastOrNull, "<this>");
        return $this$lastOrNull.isEmpty() ? null : $this$lastOrNull.getLast();
    }

    @NotNull
    public static final YearMonthProgression reversed(@NotNull YearMonthProgression $this$reversed) {
        Intrinsics.checkNotNullParameter($this$reversed, "<this>");
        return new YearMonthProgression(RangesKt.reversed($this$reversed.getLongProgression$kotlinx_datetime()));
    }

    @NotNull
    public static final YearMonthProgression step(@NotNull YearMonthProgression $this$step, int value, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter($this$step, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return YearMonthRangeKt.step($this$step, (long)value, unit);
    }

    @NotNull
    public static final YearMonthProgression step(@NotNull YearMonthProgression $this$step, long value, @NotNull DateTimeUnit.MonthBased unit) {
        Intrinsics.checkNotNullParameter($this$step, "<this>");
        Intrinsics.checkNotNullParameter(unit, "unit");
        return new YearMonthProgression(RangesKt.step($this$step.getLongProgression$kotlinx_datetime(), MathKt.safeMultiplyOrClamp(value, unit.getMonths())));
    }

    @NotNull
    public static final YearMonthProgression downTo(@NotNull YearMonth $this$downTo, @NotNull YearMonth that) {
        Intrinsics.checkNotNullParameter($this$downTo, "<this>");
        Intrinsics.checkNotNullParameter(that, "that");
        return YearMonthProgression.Companion.fromClosedRange$kotlinx_datetime($this$downTo, that, -1L, DateTimeUnit.Companion.getMONTH());
    }

    @NotNull
    public static final YearMonth random(@NotNull YearMonthProgression $this$random, @NotNull Random random) {
        Intrinsics.checkNotNullParameter($this$random, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        if ($this$random.isEmpty()) {
            throw new NoSuchElementException("Cannot get random in empty range: " + $this$random);
        }
        long l = MathKt.randomUnsafe($this$random.getLongProgression$kotlinx_datetime(), random);
        YearMonth.Companion companion = YearMonth.Companion;
        long p0 = l;
        boolean bl = false;
        return YearMonthKt.fromProlepticMonth(companion, p0);
    }

    public static /* synthetic */ YearMonth random$default(YearMonthProgression yearMonthProgression, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return YearMonthRangeKt.random(yearMonthProgression, random);
    }

    @Nullable
    public static final YearMonth randomOrNull(@NotNull YearMonthProgression $this$randomOrNull, @NotNull Random random) {
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter($this$randomOrNull, "<this>");
        Intrinsics.checkNotNullParameter(random, "random");
        Long l = MathKt.randomUnsafeOrNull($this$randomOrNull.getLongProgression$kotlinx_datetime(), random);
        if (l != null) {
            Long l2 = l;
            YearMonth.Companion companion = YearMonth.Companion;
            long p0 = ((Number)l2).longValue();
            boolean bl = false;
            yearMonth = YearMonthKt.fromProlepticMonth(companion, p0);
        } else {
            yearMonth = null;
        }
        return yearMonth;
    }

    public static /* synthetic */ YearMonth randomOrNull$default(YearMonthProgression yearMonthProgression, Random random, int n, Object object) {
        if ((n & 1) != 0) {
            random = Random.Default;
        }
        return YearMonthRangeKt.randomOrNull(yearMonthProgression, random);
    }
}

