/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.ULongArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.CborDecoder;
import kotlinx.serialization.cbor.internal.CborDecodingException;
import kotlinx.serialization.cbor.internal.CborListReader;
import kotlinx.serialization.cbor.internal.CborMapReader;
import kotlinx.serialization.cbor.internal.CborParser;
import kotlinx.serialization.cbor.internal.DecoderKt;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0012\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001c2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010 \u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001c2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b \u0010\u001fJ#\u0010$\u001a\u00028\u0000\"\u0004\b\u0000\u0010!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010/\u001a\u00020.H\u0016\u00a2\u0006\u0004\b/\u00100J\u000f\u00101\u001a\u00020(H\u0016\u00a2\u0006\u0004\b1\u0010*J\u000f\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b3\u00104J\u000f\u00106\u001a\u000205H\u0016\u00a2\u0006\u0004\b6\u00107J\u000f\u00109\u001a\u000208H\u0016\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b;\u0010<J\u000f\u0010>\u001a\u00020=H\u0016\u00a2\u0006\u0004\b>\u0010?J\u0011\u0010A\u001a\u0004\u0018\u00010@H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\bD\u0010\u001bJ\u000f\u0010E\u001a\u00020(H\u0002\u00a2\u0006\u0004\bE\u0010*J)\u0010J\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010F\u001a\u00020\t2\b\u0010G\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\bH\u0010IR\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010K\u001a\u0004\bL\u0010MR\u001a\u0010\u0006\u001a\u00020\u00058\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010N\u001a\u0004\bO\u0010PR$\u0010\n\u001a\u00020\t2\u0006\u0010Q\u001a\u00020\t8\u0004@BX\u0084\u000e\u00a2\u0006\f\n\u0004\b\n\u0010R\u001a\u0004\bS\u0010<R$\u0010T\u001a\u00020(2\u0006\u0010Q\u001a\u00020(8\u0004@BX\u0084\u000e\u00a2\u0006\f\n\u0004\bT\u0010U\u001a\u0004\bV\u0010*R\u0016\u0010W\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010RR\"\u0010X\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bX\u0010U\u001a\u0004\bY\u0010*\"\u0004\bZ\u0010[R$\u0010G\u001a\u0004\u0018\u00010\u000e8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010\\\u001a\u0004\b]\u0010^\"\u0004\b_\u0010\u0011R\u0014\u0010c\u001a\u00020`8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010b\u00a8\u0006d"}, d2={"Lkotlinx/serialization/cbor/internal/CborReader;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/cbor/CborDecoder;", "Lkotlinx/serialization/cbor/Cbor;", "cbor", "Lkotlinx/serialization/cbor/internal/CborParser;", "parser", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborParser;)V", "", "size", "", "setSize", "(I)V", "Lkotlin/ULongArray;", "objectTags", "skipBeginToken-uLth9ew", "([J)V", "skipBeginToken", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "Lkotlin/Pair;", "", "decodeElementNameWithTags", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlin/Pair;", "decodeElementNameWithTagsLenient", "T", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeString", "()Ljava/lang/String;", "", "decodeNotNullMark", "()Z", "", "decodeDouble", "()D", "", "decodeFloat", "()F", "decodeBoolean", "", "decodeByte", "()B", "", "decodeShort", "()S", "", "decodeChar", "()C", "decodeInt", "()I", "", "decodeLong", "()J", "", "decodeNull", "()Ljava/lang/Void;", "enumDescriptor", "decodeEnum", "isDone", "index", "tags", "verifyKeyTags-rjbGhUI", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I[J)V", "verifyKeyTags", "Lkotlinx/serialization/cbor/Cbor;", "getCbor", "()Lkotlinx/serialization/cbor/Cbor;", "Lkotlinx/serialization/cbor/internal/CborParser;", "getParser", "()Lkotlinx/serialization/cbor/internal/CborParser;", "value", "I", "getSize", "finiteMode", "Z", "getFiniteMode", "readProperties", "decodeByteArrayAsByteString", "getDecodeByteArrayAsByteString", "setDecodeByteArrayAsByteString", "(Z)V", "[J", "getTags-2g2roS4", "()[J", "setTags-uLth9ew", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "kotlinx-serialization-cbor"})
@SourceDebugExtension(value={"SMAP\nDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Decoder.kt\nkotlinx/serialization/cbor/internal/CborReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,621:1\n1#2:622\n*E\n"})
public class CborReader
extends AbstractDecoder
implements CborDecoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final CborParser parser;
    private int size;
    private boolean finiteMode;
    private int readProperties;
    private boolean decodeByteArrayAsByteString;
    @Nullable
    private long[] tags;

    public CborReader(@NotNull Cbor cbor, @NotNull CborParser parser) {
        Intrinsics.checkNotNullParameter(cbor, "cbor");
        Intrinsics.checkNotNullParameter(parser, "parser");
        this.cbor = cbor;
        this.parser = parser;
        this.size = -1;
    }

    @Override
    @NotNull
    public Cbor getCbor() {
        return this.cbor;
    }

    @NotNull
    protected final CborParser getParser() {
        return this.parser;
    }

    protected final int getSize() {
        return this.size;
    }

    protected final boolean getFiniteMode() {
        return this.finiteMode;
    }

    protected final boolean getDecodeByteArrayAsByteString() {
        return this.decodeByteArrayAsByteString;
    }

    protected final void setDecodeByteArrayAsByteString(boolean bl) {
        this.decodeByteArrayAsByteString = bl;
    }

    @Nullable
    protected final long[] getTags-2g2roS4() {
        return this.tags;
    }

    protected final void setTags-uLth9ew(@Nullable long[] lArray) {
        this.tags = lArray;
    }

    protected final void setSize(int size) {
        if (size >= 0) {
            this.finiteMode = true;
            this.size = size;
        }
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getCbor().getSerializersModule();
    }

    protected void skipBeginToken-uLth9ew(@Nullable long[] objectTags) {
        this.setSize(this.parser.startMap-uLth9ew(objectTags));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        long[] lArray;
        SerialKind serialKind;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        CborReader re = EncodingKt.hasArrayTag(descriptor2) ? (CborReader)new CborListReader(this.getCbor(), this.parser) : (Intrinsics.areEqual(serialKind = descriptor2.getKind(), StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind ? (CborReader)new CborListReader(this.getCbor(), this.parser) : (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE) ? (CborReader)new CborMapReader(this.getCbor(), this.parser) : new CborReader(this.getCbor(), this.parser)));
        long[] objectTags = this.getCbor().getConfiguration().getVerifyObjectTags() ? EncodingKt.getObjectTags(descriptor2) : null;
        CborReader cborReader = re;
        if (this.tags != null) {
            long[] lArray2;
            void it;
            long[] lArray3 = this.tags;
            CborReader cborReader2 = cborReader;
            boolean bl = false;
            if (objectTags == null) {
                lArray2 = it;
            } else {
                LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(2);
                longSpreadBuilder.addSpread(it);
                longSpreadBuilder.addSpread(objectTags);
                lArray2 = longSpreadBuilder.toArray();
            }
            lArray = lArray2;
            cborReader = cborReader2;
        } else {
            lArray = objectTags;
        }
        cborReader.skipBeginToken-uLth9ew(lArray);
        return re;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!this.finiteMode) {
            this.parser.end();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int n;
        int index;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.getCbor().getConfiguration().getIgnoreUnknownKeys()) {
            void var3_2;
            long[] tags;
            int knownIndex = 0;
            while (true) {
                int n2;
                if (this.isDone()) {
                    return -1;
                }
                Pair<String, ULongArray> pair = this.decodeElementNameWithTagsLenient(descriptor2);
                String elemName = pair.component1();
                ULongArray uLongArray = pair.component2();
                tags = (long[])(uLongArray != null ? uLongArray.unbox-impl() : null);
                int n3 = this.readProperties;
                this.readProperties = n3 + 1;
                if (elemName != null) {
                    String it;
                    boolean bl = false;
                    n2 = descriptor2.getElementIndex(it);
                } else {
                    n2 = index = -3;
                }
                if (index != -3) break;
                this.parser.skipElement-uLth9ew(tags);
            }
            this.verifyKeyTags-rjbGhUI(descriptor2, index, tags);
            knownIndex = index;
            n = var3_2;
        } else {
            if (this.isDone()) {
                return -1;
            }
            Pair<String, ULongArray> pair = this.decodeElementNameWithTags(descriptor2);
            String elemName = pair.component1();
            ULongArray uLongArray = pair.component2();
            long[] tags = (long[])(uLongArray != null ? uLongArray.unbox-impl() : null);
            int n4 = this.readProperties;
            this.readProperties = n4 + 1;
            index = n4 = DecoderKt.access$getElementIndexOrThrow(descriptor2, elemName);
            boolean bl = false;
            this.verifyKeyTags-rjbGhUI(descriptor2, index, tags);
            n = n4;
        }
        int index2 = n;
        this.decodeByteArrayAsByteString = EncodingKt.isByteString(descriptor2, index2);
        this.tags = this.getCbor().getConfiguration().getVerifyValueTags() ? EncodingKt.getValueTags(descriptor2, index2) : null;
        return index2;
    }

    private final Pair<String, ULongArray> decodeElementNameWithTags(SerialDescriptor descriptor2) {
        long[] tags;
        Triple<String, Long, ULongArray> triple = this.parser.nextTaggedStringOrNumber();
        String elemName = triple.component1();
        Long cborLabel = triple.component2();
        ULongArray uLongArray = triple.component3();
        Object object = tags = (Object)(uLongArray != null ? uLongArray.unbox-impl() : null);
        if (elemName == null && cborLabel != null) {
            String string = DecoderKt.access$getElementNameForCborLabel(descriptor2, cborLabel);
            if (string == null) {
                throw new CborDecodingException("CborLabel unknown: " + cborLabel + " for " + descriptor2);
            }
            elemName = string;
        }
        if (elemName == null) {
            throw new CborDecodingException("Expected (tagged) string or number, got nothing for " + descriptor2);
        }
        return TuplesKt.to(elemName, tags != null ? ULongArray.box-impl(tags) : null);
    }

    private final Pair<String, ULongArray> decodeElementNameWithTagsLenient(SerialDescriptor descriptor2) {
        long[] tags;
        Triple<String, Long, ULongArray> triple = this.parser.nextTaggedStringOrNumber();
        String elemName = triple.component1();
        Long cborLabel = triple.component2();
        ULongArray uLongArray = triple.component3();
        Object object = tags = (Object)(uLongArray != null ? uLongArray.unbox-impl() : null);
        if (elemName == null && cborLabel != null) {
            elemName = DecoderKt.access$getElementNameForCborLabel(descriptor2, cborLabel);
        }
        return TuplesKt.to(elemName, tags != null ? ULongArray.box-impl(tags) : null);
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Object object;
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        if ((this.decodeByteArrayAsByteString || this.getCbor().getConfiguration().getAlwaysUseByteString()) && Intrinsics.areEqual(deserializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            object = this.parser.nextByteString-uLth9ew(this.tags);
        } else {
            this.decodeByteArrayAsByteString = this.decodeByteArrayAsByteString || EncodingKt.isInlineByteString(deserializer.getDescriptor());
            object = super.decodeSerializableValue(deserializer);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.parser.nextString-uLth9ew(this.tags);
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.parser.isNull();
    }

    @Override
    public double decodeDouble() {
        return this.parser.nextDouble-uLth9ew(this.tags);
    }

    @Override
    public float decodeFloat() {
        return this.parser.nextFloat-uLth9ew(this.tags);
    }

    @Override
    public boolean decodeBoolean() {
        return this.parser.nextBoolean-uLth9ew(this.tags);
    }

    @Override
    public byte decodeByte() {
        return (byte)this.parser.nextNumber-uLth9ew(this.tags);
    }

    @Override
    public short decodeShort() {
        return (short)this.parser.nextNumber-uLth9ew(this.tags);
    }

    @Override
    public char decodeChar() {
        return (char)this.parser.nextNumber-uLth9ew(this.tags);
    }

    @Override
    public int decodeInt() {
        return (int)this.parser.nextNumber-uLth9ew(this.tags);
    }

    @Override
    public long decodeLong() {
        return this.parser.nextNumber-uLth9ew(this.tags);
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return this.parser.nextNull-uLth9ew(this.tags);
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        return DecoderKt.access$getElementIndexOrThrow(enumDescriptor, this.parser.nextString-uLth9ew(this.tags));
    }

    private final boolean isDone() {
        return !this.finiteMode && this.parser.isEnd() || this.finiteMode && this.readProperties >= this.size;
    }

    private final void verifyKeyTags-rjbGhUI(SerialDescriptor descriptor2, int index, long[] tags) {
        block1: {
            if (!this.getCbor().getConfiguration().getVerifyKeyTags()) break block1;
            long[] lArray = EncodingKt.getKeyTags(descriptor2, index);
            if (lArray != null) {
                long[] keyTags = lArray;
                boolean bl = false;
                this.parser.verifyTagsAndThrow-EOCRwWE$kotlinx_serialization_cbor(keyTags, tags);
            }
        }
    }
}

