/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.CborEncoder;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import kotlinx.serialization.cbor.internal.EncoderKt;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u00012\u00020\u0002:\u0001IB\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0005H$\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u0010\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u000fH$\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020'H\u0016\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010-\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b2\u00103J\u000f\u00104\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b4\u0010\u001aJ\u001f\u00106\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b6\u00107J\u001f\u00108\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b8\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u00109\u001a\u0004\b:\u0010;R\u001a\u0010\u0006\u001a\u00020\u00058\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010<\u001a\u0004\b=\u0010\nR\"\u0010>\u001a\u00020\u00168\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b>\u0010@\"\u0004\bA\u00103R\"\u0010B\u001a\u00020\u00168\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010?\u001a\u0004\bC\u0010@\"\u0004\bD\u00103R\u0014\u0010H\u001a\u00020E8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u0082\u0001\u0002JK\u00a8\u0006L"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lkotlinx/serialization/cbor/CborEncoder;", "Lkotlinx/serialization/cbor/Cbor;", "cbor", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "output", "<init>", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "getDestination", "()Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "T", "Lkotlinx/serialization/SerializationStrategy;", "serializer", "value", "", "encodeSerializableValue", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "index", "", "shouldEncodeElementDefault", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "incrementChildren", "()V", "", "encodeString", "(Ljava/lang/String;)V", "", "encodeFloat", "(F)V", "", "encodeDouble", "(D)V", "", "encodeChar", "(C)V", "", "encodeByte", "(B)V", "", "encodeShort", "(S)V", "encodeInt", "(I)V", "", "encodeLong", "(J)V", "encodeBoolean", "(Z)V", "encodeNull", "enumDescriptor", "encodeEnum", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)V", "encodeElement", "Lkotlinx/serialization/cbor/Cbor;", "getCbor", "()Lkotlinx/serialization/cbor/Cbor;", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "getOutput", "isClass", "Z", "()Z", "setClass", "encodeByteArrayAsByteString", "getEncodeByteArrayAsByteString", "setEncodeByteArrayAsByteString", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "Data", "Lkotlinx/serialization/cbor/internal/DefiniteLengthCborWriter;", "Lkotlinx/serialization/cbor/internal/IndefiniteLengthCborWriter;", "kotlinx-serialization-cbor"})
@SourceDebugExtension(value={"SMAP\nEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Encoder.kt\nkotlinx/serialization/cbor/internal/CborWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,333:1\n1869#2,2:334\n1869#2,2:336\n*S KotlinDebug\n*F\n+ 1 Encoder.kt\nkotlinx/serialization/cbor/internal/CborWriter\n*L\n127#1:334,2\n141#1:336,2\n*E\n"})
public abstract class CborWriter
extends AbstractEncoder
implements CborEncoder {
    @NotNull
    private final Cbor cbor;
    @NotNull
    private final ByteArrayOutput output;
    private boolean isClass;
    private boolean encodeByteArrayAsByteString;

    private CborWriter(Cbor cbor, ByteArrayOutput output) {
        this.cbor = cbor;
        this.output = output;
    }

    @Override
    @NotNull
    public Cbor getCbor() {
        return this.cbor;
    }

    @NotNull
    protected final ByteArrayOutput getOutput() {
        return this.output;
    }

    protected final boolean isClass() {
        return this.isClass;
    }

    protected final void setClass(boolean bl) {
        this.isClass = bl;
    }

    protected final boolean getEncodeByteArrayAsByteString() {
        return this.encodeByteArrayAsByteString;
    }

    protected final void setEncodeByteArrayAsByteString(boolean bl) {
        this.encodeByteArrayAsByteString = bl;
    }

    @NotNull
    protected abstract ByteArrayOutput getDestination();

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getCbor().getSerializersModule();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        if ((this.encodeByteArrayAsByteString || this.getCbor().getConfiguration().getAlwaysUseByteString()) && Intrinsics.areEqual(serializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            ByteArrayOutput byteArrayOutput = this.getDestination();
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.ByteArray");
            EncoderKt.encodeByteString(byteArrayOutput, (byte[])value);
        } else {
            this.encodeByteArrayAsByteString = this.encodeByteArrayAsByteString || EncodingKt.isInlineByteString(serializer.getDescriptor());
            super.encodeSerializableValue(serializer, value);
        }
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.getCbor().getConfiguration().getEncodeDefaults();
    }

    protected abstract void incrementChildren();

    @Override
    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        EncoderKt.encodeString(this.getDestination(), value);
    }

    @Override
    public void encodeFloat(float value) {
        EncoderKt.encodeFloat(this.getDestination(), value);
    }

    @Override
    public void encodeDouble(double value) {
        EncoderKt.encodeDouble(this.getDestination(), value);
    }

    @Override
    public void encodeChar(char value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeByte(byte value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeShort(short value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeInt(int value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeLong(long value) {
        EncoderKt.encodeNumber(this.getDestination(), value);
    }

    @Override
    public void encodeBoolean(boolean value) {
        EncoderKt.encodeBoolean(this.getDestination(), value);
    }

    @Override
    public void encodeNull() {
        if (this.isClass) {
            EncoderKt.encodeEmptyMap(this.getDestination());
        } else {
            EncoderKt.encodeNull(this.getDestination());
        }
    }

    @Override
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        EncoderKt.encodeString(this.getDestination(), enumDescriptor.getElementName(index));
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index) {
        long it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        ByteArrayOutput destination = this.getDestination();
        this.isClass = Intrinsics.areEqual(descriptor2.getElementDescriptor(index).getKind(), StructureKind.CLASS.INSTANCE);
        this.encodeByteArrayAsByteString = EncodingKt.isByteString(descriptor2, index);
        String name = descriptor2.getElementName(index);
        if (!EncodingKt.hasArrayTag(descriptor2)) {
            if (this.getCbor().getConfiguration().getEncodeKeyTags()) {
                long[] lArray = EncodingKt.getKeyTags(descriptor2, index);
                if (lArray != null) {
                    $this$forEach$iv = ULongArray.box-impl(lArray);
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = ((ULong)element$iv).unbox-impl();
                        boolean bl = false;
                        EncoderKt.access$encodeTag-2TYgG_w(destination, it);
                    }
                }
            }
            if (!(descriptor2.getKind() instanceof StructureKind.LIST || descriptor2.getKind() instanceof StructureKind.MAP || descriptor2.getKind() instanceof PolymorphicKind)) {
                Long cborLabel = EncodingKt.getCborLabel(descriptor2, index);
                if (this.getCbor().getConfiguration().getPreferCborLabelsOverNames() && cborLabel != null) {
                    EncoderKt.encodeNumber(destination, cborLabel);
                } else {
                    EncoderKt.encodeString(destination, name);
                }
            }
        }
        if (this.getCbor().getConfiguration().getEncodeValueTags()) {
            long[] lArray = EncodingKt.getValueTags(descriptor2, index);
            if (lArray != null) {
                $this$forEach$iv = ULongArray.box-impl(lArray);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = ((ULong)element$iv).unbox-impl();
                    boolean bl = false;
                    EncoderKt.access$encodeTag-2TYgG_w(destination, it);
                }
            }
        }
        this.incrementChildren();
        return true;
    }

    public /* synthetic */ CborWriter(Cbor cbor, ByteArrayOutput output, DefaultConstructorMarker $constructor_marker) {
        this(cbor, output);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter$Data;", "", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "bytes", "", "elementCount", "<init>", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;I)V", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "getBytes", "()Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "I", "getElementCount", "()I", "setElementCount", "(I)V", "kotlinx-serialization-cbor"})
    public static final class Data {
        @NotNull
        private final ByteArrayOutput bytes;
        private int elementCount;

        public Data(@NotNull ByteArrayOutput bytes, int elementCount) {
            Intrinsics.checkNotNullParameter(bytes, "bytes");
            this.bytes = bytes;
            this.elementCount = elementCount;
        }

        @NotNull
        public final ByteArrayOutput getBytes() {
            return this.bytes;
        }

        public final int getElementCount() {
            return this.elementCount;
        }

        public final void setElementCount(int n) {
            this.elementCount = n;
        }
    }
}

