/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import kotlinx.serialization.cbor.internal.CborWriter;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0002\b\u0005\u001a!\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00000\u0002j\u0002`\u00032\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a%\u0010\b\u001a\u00020\u0007*\f\u0012\u0004\u0012\u00020\u00000\u0002j\u0002`\u00032\u0006\u0010\u0006\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001d\u0010\n\u001a\u00020\u0000*\f\u0012\u0004\u0012\u00020\u00000\u0002j\u0002`\u0003H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001d\u0010\f\u001a\u00020\u0000*\f\u0012\u0004\u0012\u00020\u00000\u0002j\u0002`\u0003H\u0002\u00a2\u0006\u0004\b\f\u0010\u000b\u001a\u0013\u0010\u000f\u001a\u00020\u000e*\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u001b\u0010\u000f\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0013\u0010\u0015\u001a\u00020\u000e*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0010\u001a\u001b\u0010\u0015\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a\u001b\u0010\u0019\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0014\u001a\u0013\u0010\u001a\u001a\u00020\u000e*\u00020\rH\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0010\u001a\u0013\u0010\u001b\u001a\u00020\u000e*\u00020\rH\u0000\u00a2\u0006\u0004\b\u001b\u0010\u0010\u001a\u0013\u0010\u001c\u001a\u00020\u000e*\u00020\rH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u0010\u001a\u001b\u0010\u001f\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001dH\u0000\u00a2\u0006\u0004\b\u001f\u0010 \u001a\u001b\u0010!\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b!\u0010\"\u001a\u001b\u0010$\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0006\u001a\u00020#H\u0000\u00a2\u0006\u0004\b$\u0010\u0014\u001a\u001b\u0010'\u001a\u00020\u000e*\u00020\r2\u0006\u0010&\u001a\u00020%H\u0000\u00a2\u0006\u0004\b'\u0010(\u001a\u001b\u0010*\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0006\u001a\u00020)H\u0000\u00a2\u0006\u0004\b*\u0010+\u001a#\u0010-\u001a\u00020\u000e*\u00020\r2\u0006\u0010&\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001dH\u0000\u00a2\u0006\u0004\b-\u0010.\u001a\u001b\u00100\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0006\u001a\u00020/H\u0000\u00a2\u0006\u0004\b0\u00101\u001a\u001b\u00103\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0006\u001a\u000202H\u0000\u00a2\u0006\u0004\b3\u00104\u001a\u0017\u00105\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020#H\u0002\u00a2\u0006\u0004\b5\u00106\u001a#\u0010:\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b8\u00109\u001a\u0017\u0010<\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b;\u00106\u001a+\u0010@\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b>\u0010?\u001a'\u0010D\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020AH\u0002\u00a2\u0006\u0004\bB\u0010C\u001a\u0017\u0010E\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020#H\u0002\u00a2\u0006\u0004\bE\u00106*\u0018\b\u0002\u0010\u0004\"\b\u0012\u0004\u0012\u00020\u00000\u00022\b\u0012\u0004\u0012\u00020\u00000\u0002\u00a8\u0006F"}, d2={"Lkotlinx/serialization/cbor/internal/CborWriter$Data;", "initial", "", "Lkotlinx/serialization/cbor/internal/Stack;", "Stack", "(Lkotlinx/serialization/cbor/internal/CborWriter$Data;)Ljava/util/List;", "value", "", "push", "(Ljava/util/List;Lkotlinx/serialization/cbor/internal/CborWriter$Data;)Z", "pop", "(Ljava/util/List;)Lkotlinx/serialization/cbor/internal/CborWriter$Data;", "peek", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "", "startArray", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "Lkotlin/ULong;", "size", "startArray-2TYgG_w", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;J)V", "startMap", "startMap-2TYgG_w", "tag", "encodeTag-2TYgG_w", "encodeTag", "end", "encodeNull", "encodeEmptyMap", "", "byteValue", "writeByte", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;I)V", "encodeBoolean", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;Z)V", "", "encodeNumber", "", "data", "encodeByteString", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;[B)V", "", "encodeString", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;Ljava/lang/String;)V", "type", "encodeByteArray", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;[BI)V", "", "encodeFloat", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;F)V", "", "encodeDouble", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;D)V", "composeNumber", "(J)[B", "mod", "composePositiveInline-z13BHRw", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;JI)V", "composePositiveInline", "composePositive-VKZWuLQ", "composePositive", "bytes", "encodeToInline-32etgaw", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;JII)V", "encodeToInline", "", "encodeToByteArray-E0BElUM", "(JIB)[B", "encodeToByteArray", "composeNegative", "kotlinx-serialization-cbor"})
public final class EncoderKt {
    private static final List<CborWriter.Data> Stack(CborWriter.Data initial) {
        CborWriter.Data[] dataArray = new CborWriter.Data[]{initial};
        return CollectionsKt.mutableListOf(dataArray);
    }

    private static final boolean push(List<CborWriter.Data> $this$push, CborWriter.Data value) {
        return $this$push.add(value);
    }

    private static final CborWriter.Data pop(List<CborWriter.Data> $this$pop) {
        return CollectionsKt.removeLast($this$pop);
    }

    private static final CborWriter.Data peek(List<CborWriter.Data> $this$peek) {
        return CollectionsKt.last($this$peek);
    }

    private static final void startArray(ByteArrayOutput $this$startArray) {
        $this$startArray.write(159);
    }

    private static final void startArray-2TYgG_w(ByteArrayOutput $this$startArray_u2d2TYgG_w, long size) {
        EncoderKt.composePositiveInline-z13BHRw($this$startArray_u2d2TYgG_w, size, 128);
    }

    private static final void startMap(ByteArrayOutput $this$startMap) {
        $this$startMap.write(191);
    }

    private static final void startMap-2TYgG_w(ByteArrayOutput $this$startMap_u2d2TYgG_w, long size) {
        EncoderKt.composePositiveInline-z13BHRw($this$startMap_u2d2TYgG_w, size, 160);
    }

    private static final void encodeTag-2TYgG_w(ByteArrayOutput $this$encodeTag_u2d2TYgG_w, long tag) {
        EncoderKt.composePositiveInline-z13BHRw($this$encodeTag_u2d2TYgG_w, tag, 192);
    }

    public static final void end(@NotNull ByteArrayOutput $this$end) {
        Intrinsics.checkNotNullParameter($this$end, "<this>");
        $this$end.write(255);
    }

    public static final void encodeNull(@NotNull ByteArrayOutput $this$encodeNull) {
        Intrinsics.checkNotNullParameter($this$encodeNull, "<this>");
        $this$encodeNull.write(246);
    }

    public static final void encodeEmptyMap(@NotNull ByteArrayOutput $this$encodeEmptyMap) {
        Intrinsics.checkNotNullParameter($this$encodeEmptyMap, "<this>");
        $this$encodeEmptyMap.write(160);
    }

    public static final void writeByte(@NotNull ByteArrayOutput $this$writeByte, int byteValue) {
        Intrinsics.checkNotNullParameter($this$writeByte, "<this>");
        $this$writeByte.write(byteValue);
    }

    public static final void encodeBoolean(@NotNull ByteArrayOutput $this$encodeBoolean, boolean value) {
        Intrinsics.checkNotNullParameter($this$encodeBoolean, "<this>");
        $this$encodeBoolean.write(value ? 245 : 244);
    }

    public static final void encodeNumber(@NotNull ByteArrayOutput $this$encodeNumber, long value) {
        Intrinsics.checkNotNullParameter($this$encodeNumber, "<this>");
        ByteArrayOutput.write$default($this$encodeNumber, EncoderKt.composeNumber(value), 0, 0, 6, null);
    }

    public static final void encodeByteString(@NotNull ByteArrayOutput $this$encodeByteString, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter($this$encodeByteString, "<this>");
        Intrinsics.checkNotNullParameter(data, "data");
        EncoderKt.encodeByteArray($this$encodeByteString, data, 64);
    }

    public static final void encodeString(@NotNull ByteArrayOutput $this$encodeString, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$encodeString, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        EncoderKt.encodeByteArray($this$encodeString, StringsKt.encodeToByteArray(value), 96);
    }

    public static final void encodeByteArray(@NotNull ByteArrayOutput $this$encodeByteArray, @NotNull byte[] data, int type) {
        Intrinsics.checkNotNullParameter($this$encodeByteArray, "<this>");
        Intrinsics.checkNotNullParameter(data, "data");
        EncoderKt.composePositiveInline-z13BHRw($this$encodeByteArray, ULong.constructor-impl(data.length), type);
        ByteArrayOutput.write$default($this$encodeByteArray, data, 0, 0, 6, null);
    }

    public static final void encodeFloat(@NotNull ByteArrayOutput $this$encodeFloat, float value) {
        Intrinsics.checkNotNullParameter($this$encodeFloat, "<this>");
        $this$encodeFloat.write(250);
        int bits = Float.floatToRawIntBits(value);
        for (int i = 0; i < 4; ++i) {
            $this$encodeFloat.write(bits >> 24 - 8 * i & 0xFF);
        }
    }

    public static final void encodeDouble(@NotNull ByteArrayOutput $this$encodeDouble, double value) {
        Intrinsics.checkNotNullParameter($this$encodeDouble, "<this>");
        $this$encodeDouble.write(251);
        long bits = Double.doubleToRawLongBits(value);
        for (int i = 0; i < 8; ++i) {
            $this$encodeDouble.write((int)(bits >> 56 - 8 * i & 0xFFL));
        }
    }

    private static final byte[] composeNumber(long value) {
        return value >= 0L ? EncoderKt.composePositive-VKZWuLQ(ULong.constructor-impl(value)) : EncoderKt.composeNegative(value);
    }

    private static final void composePositiveInline-z13BHRw(ByteArrayOutput $this$composePositiveInline_u2dz13BHRw, long value, int mod) {
        long l = value;
        boolean bl = 0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl(0L & 0xFFFFFFFFL)) ? UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)23 & 0xFFFFFFFFL)) <= 0 : false;
        if (bl) {
            EncoderKt.writeByte($this$composePositiveInline_u2dz13BHRw, (int)value | mod);
        } else {
            boolean bl2 = 0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)24 & 0xFFFFFFFFL)) ? UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)UInt.constructor-impl(0xFFFFFFFF & 0xFF) & 0xFFFFFFFFL)) <= 0 : false;
            if (bl2) {
                EncoderKt.writeByte($this$composePositiveInline_u2dz13BHRw, 0x18 | mod);
                EncoderKt.writeByte($this$composePositiveInline_u2dz13BHRw, (int)value);
            } else {
                int n = UInt.constructor-impl(UInt.constructor-impl(0xFFFFFFFF & 0xFF) + 1);
                boolean bl3 = UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)UInt.constructor-impl(0xFFFFFFFF & 0xFFFF) & 0xFFFFFFFFL)) <= 0 ? 0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)n & 0xFFFFFFFFL)) : false;
                if (bl3) {
                    EncoderKt.encodeToInline-32etgaw($this$composePositiveInline_u2dz13BHRw, value, 2, 0x19 | mod);
                } else {
                    boolean bl4 = 0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)UInt.constructor-impl(UInt.constructor-impl(0xFFFFFFFF & 0xFFFF) + 1) & 0xFFFFFFFFL)) ? UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)-1 & 0xFFFFFFFFL)) <= 0 : false;
                    if (bl4) {
                        EncoderKt.encodeToInline-32etgaw($this$composePositiveInline_u2dz13BHRw, value, 4, 0x1A | mod);
                    } else {
                        EncoderKt.encodeToInline-32etgaw($this$composePositiveInline_u2dz13BHRw, value, 8, 0x1B | mod);
                    }
                }
            }
        }
    }

    private static final byte[] composePositive-VKZWuLQ(long value) {
        byte[] byArray;
        long l = value;
        boolean bl = 0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl(0L & 0xFFFFFFFFL)) ? UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)23 & 0xFFFFFFFFL)) <= 0 : false;
        if (bl) {
            byte[] byArray2 = new byte[]{(byte)value};
            byArray = byArray2;
        } else {
            boolean bl2 = 0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)24 & 0xFFFFFFFFL)) ? UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)UInt.constructor-impl(0xFFFFFFFF & 0xFF) & 0xFFFFFFFFL)) <= 0 : false;
            if (bl2) {
                byte[] byArray3 = new byte[]{24, (byte)value};
                byArray = byArray3;
            } else {
                int n = UInt.constructor-impl(UInt.constructor-impl(0xFFFFFFFF & 0xFF) + 1);
                byArray = (UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)UInt.constructor-impl(0xFFFFFFFF & 0xFFFF) & 0xFFFFFFFFL)) <= 0 ? 0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)n & 0xFFFFFFFFL)) : false) ? EncoderKt.encodeToByteArray-E0BElUM(value, 2, (byte)25) : ((0 <= UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)UInt.constructor-impl(UInt.constructor-impl(0xFFFFFFFF & 0xFFFF) + 1) & 0xFFFFFFFFL)) ? UnsignedKt.ulongCompare(l, ULong.constructor-impl((long)-1 & 0xFFFFFFFFL)) <= 0 : false) ? EncoderKt.encodeToByteArray-E0BElUM(value, 4, (byte)26) : EncoderKt.encodeToByteArray-E0BElUM(value, 8, (byte)27));
            }
        }
        return byArray;
    }

    private static final void encodeToInline-32etgaw(ByteArrayOutput $this$encodeToInline_u2d32etgaw, long value, int bytes, int tag) {
        int limit = bytes * 8 - 8;
        EncoderKt.writeByte($this$encodeToInline_u2d32etgaw, tag);
        for (int i = 0; i < bytes; ++i) {
            EncoderKt.writeByte($this$encodeToInline_u2d32etgaw, (int)ULong.constructor-impl(ULong.constructor-impl(value >>> limit - 8 * i) & 0xFFL));
        }
    }

    private static final byte[] encodeToByteArray-E0BElUM(long value, int bytes, byte tag) {
        byte[] result = new byte[bytes + 1];
        int limit = bytes * 8 - 8;
        result[0] = tag;
        for (int i = 0; i < bytes; ++i) {
            result[i + 1] = (byte)ULong.constructor-impl(ULong.constructor-impl(value >>> limit - 8 * i) & 0xFFL);
        }
        return result;
    }

    private static final byte[] composeNegative(long value) {
        long aVal = value == Long.MIN_VALUE ? Long.MAX_VALUE : (long)-1 - value;
        byte[] data = EncoderKt.composePositive-VKZWuLQ(ULong.constructor-impl(aVal));
        data[0] = (byte)(data[0] | 0x20);
        return data;
    }

    public static final /* synthetic */ void access$encodeTag-2TYgG_w(ByteArrayOutput $receiver, long tag) {
        EncoderKt.encodeTag-2TYgG_w($receiver, tag);
    }

    public static final /* synthetic */ void access$startArray(ByteArrayOutput $receiver) {
        EncoderKt.startArray($receiver);
    }

    public static final /* synthetic */ void access$startMap(ByteArrayOutput $receiver) {
        EncoderKt.startMap($receiver);
    }

    public static final /* synthetic */ List access$Stack(CborWriter.Data initial) {
        return EncoderKt.Stack(initial);
    }

    public static final /* synthetic */ CborWriter.Data access$peek(List $receiver) {
        return EncoderKt.peek($receiver);
    }

    public static final /* synthetic */ boolean access$push(List $receiver, CborWriter.Data value) {
        return EncoderKt.push($receiver, value);
    }

    public static final /* synthetic */ CborWriter.Data access$pop(List $receiver) {
        return EncoderKt.pop($receiver);
    }

    public static final /* synthetic */ void access$startArray-2TYgG_w(ByteArrayOutput $receiver, long size) {
        EncoderKt.startArray-2TYgG_w($receiver, size);
    }

    public static final /* synthetic */ void access$startMap-2TYgG_w(ByteArrayOutput $receiver, long size) {
        EncoderKt.startMap-2TYgG_w($receiver, size);
    }
}

