/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\r\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u0005*\u00020\u0004H\u0084\b\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\r\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0005H&\u00a2\u0006\u0004\b\u0010\u0010\u000bJ\u000f\u0010\u0012\u001a\u00020\u0011H&\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u000bJ\u0017\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0007J\r\u0010\u0017\u001a\u00020\b\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0019J\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0012\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001aJ_\u0010'\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u00112\b\b\u0002\u0010\u001d\u001a\u00020\u000528\b\u0002\u0010#\u001a2\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001f0\u001eH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b(\u0010\u0013J\u0017\u0010*\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u0005\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\fH&\u00a2\u0006\u0004\b,\u0010-J!\u00100\u001a\u0004\u0018\u00010\u001f2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u0005H&\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u0004\u0018\u00010\u001f2\u0006\u0010/\u001a\u00020\u0005\u00a2\u0006\u0004\b2\u00103J\r\u00104\u001a\u00020\b\u00a2\u0006\u0004\b4\u0010\u0003J\u001f\u00107\u001a\u00020\f2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b7\u00108J\u001f\u0010:\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\f2\u0006\u00109\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u00020\u001fH&\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010>\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b>\u0010?J:\u0010C\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u00052!\u0010B\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020\b0@H\u0016\u00a2\u0006\u0004\bC\u0010DJJ\u0010H\u001a\u00020\b2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\u00052!\u0010B\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020\b0@H\u0002\u00a2\u0006\u0004\bH\u0010IJ\r\u0010J\u001a\u00020\u001f\u00a2\u0006\u0004\bJ\u0010=J'\u0010J\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020K2\u0006\u0010L\u001a\u00020\f2\u0006\u0010M\u001a\u00020\fH\u0005\u00a2\u0006\u0004\bJ\u0010NJ\u001f\u0010P\u001a\u00020\f2\u0006\u0010O\u001a\u00020\f2\u0006\u0010M\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bP\u0010QJ\u001f\u0010S\u001a\u00020\u001f2\u0006\u0010O\u001a\u00020\f2\u0006\u0010R\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bS\u0010;J\u000f\u0010T\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\bT\u0010=J\r\u0010U\u001a\u00020\u001f\u00a2\u0006\u0004\bU\u0010=J\u000f\u0010V\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\bV\u0010\u000bJ\r\u0010W\u001a\u00020\u001f\u00a2\u0006\u0004\bW\u0010=J\u001f\u0010X\u001a\u00020\b2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\fH\u0014\u00a2\u0006\u0004\bX\u0010YJ\u0017\u0010Z\u001a\u00020\f2\u0006\u0010L\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bZ\u0010\u000fJ\u001f\u0010[\u001a\u00020\f2\u0006\u0010\"\u001a\u00020K2\u0006\u00106\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b[\u0010\\J3\u0010a\u001a\u00020\b2\u0006\u0010]\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0^H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b_\u0010`J\u001f\u0010b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020K2\u0006\u0010R\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bb\u0010\\J\u0015\u0010d\u001a\u00020\b2\u0006\u0010c\u001a\u00020\u0005\u00a2\u0006\u0004\bd\u0010eJ\u000f\u0010f\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\bf\u0010=J\u0015\u0010h\u001a\u00020\b2\u0006\u0010g\u001a\u00020\u001f\u00a2\u0006\u0004\bh\u0010iJ)\u0010'\u001a\u00020$2\u0006\u0010#\u001a\u00020\u001f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010j\u001a\u00020\u001f\u00a2\u0006\u0004\b'\u0010kJ\r\u0010m\u001a\u00020l\u00a2\u0006\u0004\bm\u0010nJ\r\u0010o\u001a\u00020l\u00a2\u0006\u0004\bo\u0010nJ\r\u0010p\u001a\u00020\u0005\u00a2\u0006\u0004\bp\u0010\u000bJ\r\u0010q\u001a\u00020\u0005\u00a2\u0006\u0004\bq\u0010\u000bJ\u0017\u0010p\u001a\u00020\u00052\u0006\u0010r\u001a\u00020\fH\u0003\u00a2\u0006\u0004\bp\u0010sJ\u001f\u0010u\u001a\u00020\b2\u0006\u0010t\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bu\u0010vJ$\u0010y\u001a\u00028\u0000\"\u0004\b\u0000\u0010w2\f\u0010x\u001a\b\u0012\u0004\u0012\u00028\u00000^H\u0082\b\u00a2\u0006\u0004\by\u0010zR\u0014\u0010\"\u001a\u00020K8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b{\u0010|R\u0016\u0010R\u001a\u00020\f8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010}R\u0015\u0010\u007f\u001a\u00020~8\u0006X\u0087\u0004\u00a2\u0006\u0007\n\u0005\b\u007f\u0010\u0080\u0001R\u001b\u0010\u0081\u0001\u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0081\u0001\u0010\u0082\u0001R/\u0010\u0085\u0001\u001a\b0\u0083\u0001j\u0003`\u0084\u00018\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0018\n\u0006\b\u0085\u0001\u0010\u0086\u0001\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u008b\u0001"}, d2={"Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "", "<init>", "()V", "", "", "isWs", "(C)Z", "", "ensureHaveChars", "isNotEof", "()Z", "", "position", "prefetchOrEof", "(I)I", "canConsumeValue", "", "consumeNextToken", "()B", "tryConsumeComma", "c", "isValidValueStart", "expectEof", "expected", "(B)B", "(C)V", "unexpectedToken", "expectedToken", "wasConsumed", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "source", "message", "", "fail$kotlinx_serialization_json", "(BZLkotlin/jvm/functions/Function2;)Ljava/lang/Void;", "fail", "peekNextToken", "doConsume", "tryConsumeNull", "(Z)Z", "skipWhitespaces", "()I", "keyToMatch", "isLenient", "peekLeadingMatchingValue", "(Ljava/lang/String;Z)Ljava/lang/String;", "peekString", "(Z)Ljava/lang/String;", "discardPeeked", "char", "startPos", "indexOf", "(CI)I", "endPos", "substring", "(II)Ljava/lang/String;", "consumeKeyString", "()Ljava/lang/String;", "insideString", "(ZC)Z", "Lkotlin/Function1;", "stringChunk", "consumeChunk", "consumeStringChunked", "(ZLkotlin/jvm/functions/Function1;)V", "fromIndex", "toIndex", "currentChunkHasEscape", "writeRange", "(IIZLkotlin/jvm/functions/Function1;)V", "consumeString", "", "startPosition", "current", "(Ljava/lang/CharSequence;II)Ljava/lang/String;", "lastPosition", "appendEscape", "(II)I", "currentPosition", "decodedString", "takePeeked", "consumeStringLenientNotNull", "wasUnquotedString", "consumeStringLenient", "appendRange", "(II)V", "appendEsc", "appendHex", "(Ljava/lang/CharSequence;I)I", "condition", "Lkotlin/Function0;", "require$kotlinx_serialization_json", "(ZILkotlin/jvm/functions/Function0;)V", "require", "fromHexChar", "allowLenientStrings", "skipElement", "(Z)V", "toString", "key", "failOnUnknownKey", "(Ljava/lang/String;)V", "hint", "(Ljava/lang/String;ILjava/lang/String;)Ljava/lang/Void;", "", "consumeNumericLiteral", "()J", "consumeNumericLiteralFully", "consumeBoolean", "consumeBooleanLenient", "start", "(I)Z", "literalSuffix", "consumeBooleanLiteral", "(Ljava/lang/String;I)V", "T", "action", "withPositionRollback", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getSource", "()Ljava/lang/CharSequence;", "I", "Lkotlinx/serialization/json/internal/JsonPath;", "path", "Lkotlinx/serialization/json/internal/JsonPath;", "peekedString", "Ljava/lang/String;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "escapedString", "Ljava/lang/StringBuilder;", "getEscapedString", "()Ljava/lang/StringBuilder;", "setEscapedString", "(Ljava/lang/StringBuilder;)V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nAbstractJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer$fail$1\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,763:1\n226#1,10:764\n755#1,5:775\n226#1,10:780\n226#1,10:792\n229#2:774\n229#2:790\n1#3:791\n*S KotlinDebug\n*F\n+ 1 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n*L\n206#1:764,10\n216#1:775,5\n223#1:780,10\n685#1:792,10\n206#1:774\n223#1:790\n*E\n"})
public abstract class AbstractJsonLexer {
    @JvmField
    public int currentPosition;
    @JvmField
    @NotNull
    public final JsonPath path = new JsonPath();
    @Nullable
    private String peekedString;
    @NotNull
    private StringBuilder escapedString = new StringBuilder();

    @NotNull
    protected abstract CharSequence getSource();

    protected final boolean isWs(char $this$isWs) {
        boolean $i$f$isWs = false;
        return $this$isWs == ' ' || $this$isWs == '\n' || $this$isWs == '\r' || $this$isWs == '\t';
    }

    public void ensureHaveChars() {
    }

    public final boolean isNotEof() {
        return this.peekNextToken() != 10;
    }

    public abstract int prefetchOrEof(int var1);

    public abstract boolean canConsumeValue();

    public abstract byte consumeNextToken();

    public final boolean tryConsumeComma() {
        CharSequence source;
        int current = this.skipWhitespaces();
        if (current >= (source = this.getSource()).length() || current == -1) {
            return false;
        }
        if (source.charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    protected final boolean isValidValueStart(char c) {
        boolean bl;
        switch (c) {
            case ',': 
            case ':': 
            case ']': 
            case '}': {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public final void expectEof() {
        byte nextToken = this.consumeNextToken();
        if (nextToken != 10) {
            AbstractJsonLexer.fail$default(this, "Expected EOF after parsing, but had " + this.getSource().charAt(this.currentPosition - 1) + " instead", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    protected final StringBuilder getEscapedString() {
        return this.escapedString;
    }

    protected final void setEscapedString(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter(stringBuilder, "<set-?>");
        this.escapedString = stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public final byte consumeNextToken(byte expected) {
        byte token = this.consumeNextToken();
        if (token != expected) {
            void source;
            String s$iv;
            void $this$iv;
            AbstractJsonLexer abstractJsonLexer = this;
            byte expectedToken$iv = expected;
            boolean wasConsumed$iv = true;
            boolean $i$f$fail$kotlinx_serialization_json = false;
            String expected$iv = AbstractJsonLexerKt.tokenDescription(expectedToken$iv);
            int position$iv = $this$iv.currentPosition - 1;
            String string = s$iv = $this$iv.currentPosition == ((AbstractJsonLexer)$this$iv).getSource().length() || position$iv < 0 ? "EOF" : String.valueOf(((AbstractJsonLexer)$this$iv).getSource().charAt(position$iv));
            String string2 = expected$iv;
            void var13_12 = $this$iv;
            boolean bl = false;
            String expected2 = string2;
            AbstractJsonLexer.fail$default((AbstractJsonLexer)var13_12, "Expected " + expected2 + ", but had '" + (String)source + "' instead", position$iv, null, 4, null);
            throw new KotlinNothingValueException();
        }
        return token;
    }

    public abstract void consumeNextToken(char var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void unexpectedToken(char expected) {
        void source;
        String s$iv;
        void $this$iv;
        Object inputLiteral;
        if (this.currentPosition > 0 && expected == '\"') {
            String $i$a$-withPositionRollback-AbstractJsonLexer$unexpectedToken$inputLiteral$22;
            AbstractJsonLexer this_$iv = this;
            boolean $i$f$withPositionRollback = false;
            int snapshot$iv = this_$iv.currentPosition;
            try {
                boolean $i$a$-withPositionRollback-AbstractJsonLexer$unexpectedToken$inputLiteral$22 = false;
                int n = this.currentPosition;
                this.currentPosition = n + -1;
                $i$a$-withPositionRollback-AbstractJsonLexer$unexpectedToken$inputLiteral$22 = this.consumeStringLenient();
            }
            finally {
                this_$iv.currentPosition = snapshot$iv;
            }
            inputLiteral = $i$a$-withPositionRollback-AbstractJsonLexer$unexpectedToken$inputLiteral$22;
            if (Intrinsics.areEqual(inputLiteral, "null")) {
                this.fail("Expected string literal but 'null' literal was found", this.currentPosition - 1, "Use 'coerceInputValues = true' in 'Json {}' builder to coerce nulls if property has a default value.");
                throw new KotlinNothingValueException();
            }
        }
        inputLiteral = this;
        byte expectedToken$iv = AbstractJsonLexerKt.charToTokenClass(expected);
        boolean wasConsumed$iv = true;
        boolean $i$f$fail$kotlinx_serialization_json = false;
        String expected$iv = AbstractJsonLexerKt.tokenDescription(expectedToken$iv);
        int position$iv = $this$iv.currentPosition - 1;
        String string = s$iv = $this$iv.currentPosition == ((AbstractJsonLexer)$this$iv).getSource().length() || position$iv < 0 ? "EOF" : String.valueOf(((AbstractJsonLexer)$this$iv).getSource().charAt(position$iv));
        String string2 = expected$iv;
        void var13_17 = $this$iv;
        boolean bl = false;
        String expected2 = string2;
        AbstractJsonLexer.fail$default((AbstractJsonLexer)var13_17, "Expected " + expected2 + ", but had '" + (String)source + "' instead", position$iv, null, 4, null);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public final Void fail$kotlinx_serialization_json(byte expectedToken, boolean wasConsumed, @NotNull Function2<? super String, ? super String, String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$fail$kotlinx_serialization_json = false;
        String expected = AbstractJsonLexerKt.tokenDescription(expectedToken);
        int position = wasConsumed ? this.currentPosition - 1 : this.currentPosition;
        String s = this.currentPosition == this.getSource().length() || position < 0 ? "EOF" : String.valueOf(this.getSource().charAt(position));
        AbstractJsonLexer.fail$default(this, message.invoke(expected, s), position, null, 4, null);
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void fail$kotlinx_serialization_json$default(AbstractJsonLexer $this, byte expectedToken, boolean wasConsumed, Function2 message, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fail");
        }
        if ((n & 2) != 0) {
            wasConsumed = true;
        }
        if ((n & 4) != 0) {
            message = fail.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$fail$kotlinx_serialization_json = false;
        String expected = AbstractJsonLexerKt.tokenDescription(expectedToken);
        int position = wasConsumed ? $this.currentPosition - 1 : $this.currentPosition;
        String s = $this.currentPosition == $this.getSource().length() || position < 0 ? "EOF" : String.valueOf($this.getSource().charAt(position));
        AbstractJsonLexer.fail$default($this, (String)message.invoke(expected, s), position, null, 4, null);
        throw new KotlinNothingValueException();
    }

    public byte peekNextToken() {
        CharSequence source = this.getSource();
        int cpos = this.currentPosition;
        block3: while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch = source.charAt(cpos);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++cpos;
                    continue block3;
                }
            }
            this.currentPosition = cpos;
            return AbstractJsonLexerKt.charToTokenClass(ch);
        }
        this.currentPosition = cpos;
        return 10;
    }

    public final boolean tryConsumeNull(boolean doConsume) {
        int current = this.skipWhitespaces();
        current = this.prefetchOrEof(current);
        int len = this.getSource().length() - current;
        if (len < 4 || current == -1) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if ("null".charAt(i) == this.getSource().charAt(current + i)) continue;
            return false;
        }
        if (len > 4 && AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current + 4)) == 0) {
            return false;
        }
        if (doConsume) {
            this.currentPosition = current + 4;
        }
        return true;
    }

    public static /* synthetic */ boolean tryConsumeNull$default(AbstractJsonLexer abstractJsonLexer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryConsumeNull");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return abstractJsonLexer.tryConsumeNull(bl);
    }

    public abstract int skipWhitespaces();

    @Nullable
    public abstract String peekLeadingMatchingValue(@NotNull String var1, boolean var2);

    @Nullable
    public final String peekString(boolean isLenient) {
        String string;
        String string2;
        byte token = this.peekNextToken();
        if (isLenient) {
            if (token != 1 && token != 0) {
                return null;
            }
            string2 = this.consumeStringLenient();
        } else {
            if (token != 1) {
                return null;
            }
            string2 = this.consumeString();
        }
        this.peekedString = string = string2;
        return string;
    }

    public final void discardPeeked() {
        this.peekedString = null;
    }

    public int indexOf(char c, int startPos) {
        return StringsKt.indexOf$default(this.getSource(), c, startPos, false, 4, null);
    }

    @NotNull
    public String substring(int startPos, int endPos) {
        return ((Object)this.getSource().subSequence(startPos, endPos)).toString();
    }

    @NotNull
    public abstract String consumeKeyString();

    private final boolean insideString(boolean isLenient, char c) {
        return isLenient ? AbstractJsonLexerKt.charToTokenClass(c) == 0 : c != '\"';
    }

    public void consumeStringChunked(boolean isLenient, @NotNull Function1<? super String, Unit> consumeChunk) {
        int currentPosition;
        Intrinsics.checkNotNullParameter(consumeChunk, "consumeChunk");
        byte nextToken = this.peekNextToken();
        if (isLenient && nextToken != 0) {
            return;
        }
        if (!isLenient) {
            this.consumeNextToken('\"');
        }
        int lastPosition = currentPosition = this.currentPosition;
        char c = this.getSource().charAt(currentPosition);
        boolean usedAppend = false;
        while (this.insideString(isLenient, c)) {
            if (!isLenient && c == '\\') {
                usedAppend = true;
                lastPosition = currentPosition = this.prefetchOrEof(this.appendEscape(lastPosition, currentPosition));
            } else {
                ++currentPosition;
            }
            if (currentPosition >= this.getSource().length()) {
                this.writeRange(lastPosition, currentPosition, usedAppend, consumeChunk);
                usedAppend = false;
                currentPosition = this.prefetchOrEof(currentPosition);
                if (currentPosition == -1) {
                    AbstractJsonLexer.fail$default(this, "EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            }
            c = this.getSource().charAt(currentPosition);
        }
        this.writeRange(lastPosition, currentPosition, usedAppend, consumeChunk);
        this.currentPosition = currentPosition;
        if (!isLenient) {
            this.consumeNextToken('\"');
        }
    }

    private final void writeRange(int fromIndex, int toIndex, boolean currentChunkHasEscape, Function1<? super String, Unit> consumeChunk) {
        if (currentChunkHasEscape) {
            consumeChunk.invoke(this.decodedString(fromIndex, toIndex));
        } else {
            consumeChunk.invoke(this.substring(fromIndex, toIndex));
        }
    }

    @NotNull
    public final String consumeString() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        return this.consumeKeyString();
    }

    @NotNull
    protected final String consumeString(@NotNull CharSequence source, int startPosition, int current) {
        Intrinsics.checkNotNullParameter(source, "source");
        int currentPosition = current;
        int lastPosition = startPosition;
        char c = source.charAt(currentPosition);
        boolean usedAppend = false;
        while (c != '\"') {
            if (c == '\\') {
                usedAppend = true;
                if ((currentPosition = this.prefetchOrEof(this.appendEscape(lastPosition, currentPosition))) == -1) {
                    AbstractJsonLexer.fail$default(this, "Unexpected EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            } else if (++currentPosition >= source.length()) {
                usedAppend = true;
                this.appendRange(lastPosition, currentPosition);
                currentPosition = this.prefetchOrEof(currentPosition);
                if (currentPosition == -1) {
                    AbstractJsonLexer.fail$default(this, "Unexpected EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            }
            c = source.charAt(currentPosition);
        }
        String string = !usedAppend ? this.substring(lastPosition, currentPosition) : this.decodedString(lastPosition, currentPosition);
        this.currentPosition = currentPosition + 1;
        return string;
    }

    private final int appendEscape(int lastPosition, int current) {
        this.appendRange(lastPosition, current);
        return this.appendEsc(current + 1);
    }

    private final String decodedString(int lastPosition, int currentPosition) {
        this.appendRange(lastPosition, currentPosition);
        String string = this.escapedString.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String result = string;
        this.escapedString.setLength(0);
        return result;
    }

    private final String takePeeked() {
        String string;
        String string2 = this.peekedString;
        Intrinsics.checkNotNull(string2);
        String it = string = string2;
        boolean bl = false;
        this.peekedString = null;
        return string;
    }

    @NotNull
    public final String consumeStringLenientNotNull() {
        String result = this.consumeStringLenient();
        if (Intrinsics.areEqual(result, "null") && this.wasUnquotedString()) {
            AbstractJsonLexer.fail$default(this, "Unexpected 'null' value instead of string literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return result;
    }

    private final boolean wasUnquotedString() {
        return this.getSource().charAt(this.currentPosition - 1) != '\"';
    }

    @NotNull
    public final String consumeStringLenient() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", current, null, 4, null);
            throw new KotlinNothingValueException();
        }
        byte token = AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current));
        if (token == 1) {
            return this.consumeString();
        }
        if (token != 0) {
            AbstractJsonLexer.fail$default(this, "Expected beginning of the string, but got " + this.getSource().charAt(current), 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        boolean usedAppend = false;
        while (AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current)) == 0) {
            if (++current < this.getSource().length()) continue;
            usedAppend = true;
            this.appendRange(this.currentPosition, current);
            int eof = this.prefetchOrEof(current);
            if (eof == -1) {
                this.currentPosition = current;
                return this.decodedString(0, 0);
            }
            current = eof;
        }
        String result = !usedAppend ? this.substring(this.currentPosition, current) : this.decodedString(this.currentPosition, current);
        this.currentPosition = current;
        return result;
    }

    protected void appendRange(int fromIndex, int toIndex) {
        this.escapedString.append(this.getSource(), fromIndex, toIndex);
    }

    private final int appendEsc(int startPosition) {
        int currentPosition = startPosition;
        if ((currentPosition = this.prefetchOrEof(currentPosition)) == -1) {
            AbstractJsonLexer.fail$default(this, "Expected escape sequence to continue, got EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        char currentChar = this.getSource().charAt(currentPosition++);
        if (currentChar == 'u') {
            return this.appendHex(this.getSource(), currentPosition);
        }
        char c = AbstractJsonLexerKt.escapeToChar(currentChar);
        if (c == '\u0000') {
            AbstractJsonLexer.fail$default(this, "Invalid escaped char '" + currentChar + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append(c);
        return currentPosition;
    }

    private final int appendHex(CharSequence source, int startPos) {
        if (startPos + 4 >= source.length()) {
            this.currentPosition = startPos;
            this.ensureHaveChars();
            if (this.currentPosition + 4 >= source.length()) {
                AbstractJsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            return this.appendHex(source, this.currentPosition);
        }
        this.escapedString.append((char)((this.fromHexChar(source, startPos) << 12) + (this.fromHexChar(source, startPos + 1) << 8) + (this.fromHexChar(source, startPos + 2) << 4) + this.fromHexChar(source, startPos + 3)));
        return startPos + 4;
    }

    public final void require$kotlinx_serialization_json(boolean condition, int position, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            AbstractJsonLexer.fail$default(this, message.invoke(), position, null, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void require$kotlinx_serialization_json$default(AbstractJsonLexer $this, boolean condition, int position, Function0 message, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: require");
        }
        if ((n & 2) != 0) {
            position = $this.currentPosition;
        }
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition) {
            AbstractJsonLexer.fail$default($this, (String)message.invoke(), position, null, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    private final int fromHexChar(CharSequence source, int currentPosition) {
        int n;
        char character = source.charAt(currentPosition);
        boolean bl = '0' <= character ? character < ':' : false;
        if (bl) {
            n = character - 48;
        } else {
            boolean bl2 = 'a' <= character ? character < 'g' : false;
            if (bl2) {
                n = character - 97 + 10;
            } else {
                boolean bl3 = 'A' <= character ? character < 'G' : false;
                if (bl3) {
                    n = character - 65 + 10;
                } else {
                    AbstractJsonLexer.fail$default(this, "Invalid toHexChar char '" + character + "' in unicode escape", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return n;
    }

    public final void skipElement(boolean allowLenientStrings) {
        List tokenStack = new ArrayList();
        byte lastToken = this.peekNextToken();
        if (lastToken != 8 && lastToken != 6) {
            this.consumeStringLenient();
            return;
        }
        while (true) {
            if ((lastToken = this.peekNextToken()) == 1) {
                String string = allowLenientStrings ? this.consumeStringLenient() : this.consumeKeyString();
                continue;
            }
            byte by = lastToken;
            if (by == 8 || by == 6) {
                tokenStack.add(lastToken);
            } else if (by == 9) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 8) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of } at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 7) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 6) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ] at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 10) {
                AbstractJsonLexer.fail$default(this, "Unexpected end of input due to malformed JSON during ignoring unknown keys", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            this.consumeNextToken();
            if (tokenStack.size() == 0) break;
        }
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.getSource() + "', currentPosition=" + this.currentPosition + ')';
    }

    public final void failOnUnknownKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String processed = this.substring(0, this.currentPosition);
        int lastIndexOf2 = StringsKt.lastIndexOf$default((CharSequence)processed, key, 0, false, 6, null);
        throw new JsonDecodingException("Encountered an unknown key '" + key + "' at offset " + lastIndexOf2 + " at path: " + this.path.getPath() + "\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder or '@JsonIgnoreUnknownKeys' annotation to ignore unknown keys.\nJSON input: " + JsonExceptionsKt.minify(this.getSource(), lastIndexOf2));
    }

    @NotNull
    public final Void fail(@NotNull String message, int position, @NotNull String hint) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(hint, "hint");
        String hintMessage = ((CharSequence)hint).length() == 0 ? "" : '\n' + hint;
        throw JsonExceptionsKt.JsonDecodingException(position, message + " at path: " + this.path.getPath() + hintMessage, this.getSource());
    }

    public static /* synthetic */ Void fail$default(AbstractJsonLexer abstractJsonLexer, String string, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fail");
        }
        if ((n2 & 2) != 0) {
            n = abstractJsonLexer.currentPosition;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return abstractJsonLexer.fail(string, n, string2);
    }

    public final long consumeNumericLiteral() {
        long l;
        boolean hasChars;
        boolean bl;
        int current = this.skipWhitespaces();
        if ((current = this.prefetchOrEof(current)) >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            if (++current == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        long accumulator = 0L;
        long exponentAccumulator = 0L;
        boolean isNegative2 = false;
        boolean isExponentPositive = false;
        boolean hasExponent = false;
        int start = current;
        while (current != this.getSource().length()) {
            char ch = this.getSource().charAt(current);
            if (!(ch != 'e' && ch != 'E' || hasExponent)) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol " + ch + " in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = true;
                hasExponent = true;
                ++current;
                continue;
            }
            if (ch == '-' && hasExponent) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = false;
                ++current;
                continue;
            }
            if (ch == '+' && hasExponent) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '+' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = true;
                ++current;
                continue;
            }
            if (ch == '-') {
                if (current != start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isNegative2 = true;
                ++current;
                continue;
            }
            byte token = AbstractJsonLexerKt.charToTokenClass(ch);
            if (token != 0) break;
            ++current;
            int digit = ch - 48;
            if (!(0 <= digit ? digit < 10 : false)) {
                AbstractJsonLexer.fail$default(this, "Unexpected symbol '" + ch + "' in numeric literal", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (hasExponent) {
                exponentAccumulator = exponentAccumulator * (long)10 + (long)digit;
                continue;
            }
            if ((accumulator = accumulator * (long)10 - (long)digit) <= 0L) continue;
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        boolean bl2 = hasChars = current != start;
        if (start == current || isNegative2 && start == current - 1) {
            AbstractJsonLexer.fail$default(this, "Expected numeric literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (hasQuotation) {
            if (!hasChars) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(current) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++current;
        }
        this.currentPosition = current;
        if (hasExponent) {
            double doubleAccumulator = (double)accumulator * AbstractJsonLexer.consumeNumericLiteral$calculateExponent(exponentAccumulator, isExponentPositive);
            if (doubleAccumulator > 9.223372036854776E18 || doubleAccumulator < -9.223372036854776E18) {
                AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (!(Math.floor(doubleAccumulator) == doubleAccumulator)) {
                AbstractJsonLexer.fail$default(this, "Can't convert " + doubleAccumulator + " to Long", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            accumulator = (long)doubleAccumulator;
        }
        if (isNegative2) {
            l = accumulator;
        } else if (accumulator != Long.MIN_VALUE) {
            l = -accumulator;
        } else {
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public final long consumeNumericLiteralFully() {
        long result = this.consumeNumericLiteral();
        byte next = this.consumeNextToken();
        if (next != 10) {
            void source;
            String s$iv;
            void $this$iv;
            AbstractJsonLexer abstractJsonLexer = this;
            byte expectedToken$iv = 10;
            boolean wasConsumed$iv = true;
            boolean $i$f$fail$kotlinx_serialization_json = false;
            String expected$iv = AbstractJsonLexerKt.tokenDescription(expectedToken$iv);
            int position$iv = $this$iv.currentPosition - 1;
            String string = s$iv = $this$iv.currentPosition == ((AbstractJsonLexer)$this$iv).getSource().length() || position$iv < 0 ? "EOF" : String.valueOf(((AbstractJsonLexer)$this$iv).getSource().charAt(position$iv));
            void var13_11 = $this$iv;
            boolean bl = false;
            AbstractJsonLexer.fail$default((AbstractJsonLexer)var13_11, "Expected input to contain a single valid number, but got '" + (String)source + "' after it", position$iv, null, 4, null);
            throw new KotlinNothingValueException();
        }
        return result;
    }

    public final boolean consumeBoolean() {
        return this.consumeBoolean(this.skipWhitespaces());
    }

    public final boolean consumeBooleanLenient() {
        boolean bl;
        int current = this.skipWhitespaces();
        if (current == this.getSource().length()) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            ++current;
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        boolean result = this.consumeBoolean(current);
        if (hasQuotation) {
            if (this.currentPosition == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(this.currentPosition) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++this.currentPosition;
        }
        return result;
    }

    private final boolean consumeBoolean(int start) {
        boolean bl;
        int current = this.prefetchOrEof(start);
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        switch (this.getSource().charAt(current++) | 0x20) {
            case 116: {
                this.consumeBooleanLiteral("rue", current);
                bl = true;
                break;
            }
            case 102: {
                this.consumeBooleanLiteral("alse", current);
                bl = false;
                break;
            }
            default: {
                AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
        }
        return bl;
    }

    private final void consumeBooleanLiteral(String literalSuffix, int current) {
        if (this.getSource().length() - current < literalSuffix.length()) {
            AbstractJsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        int n = ((CharSequence)literalSuffix).length();
        for (int i = 0; i < n; ++i) {
            char actual;
            char expected = literalSuffix.charAt(i);
            if (expected == ((actual = this.getSource().charAt(current + i)) | 0x20)) continue;
            AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        this.currentPosition = current + literalSuffix.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withPositionRollback(Function0<? extends T> action) {
        boolean $i$f$withPositionRollback = false;
        int snapshot = this.currentPosition;
        try {
            T t = action.invoke();
            return t;
        }
        finally {
            InlineMarker.finallyStart(1);
            this.currentPosition = snapshot;
            InlineMarker.finallyEnd(1);
        }
    }

    private static final double consumeNumericLiteral$calculateExponent(long exponentAccumulator, boolean isExponentPositive) {
        double d;
        boolean bl = isExponentPositive;
        if (!bl) {
            d = Math.pow(10.0, -((double)exponentAccumulator));
        } else if (bl) {
            d = Math.pow(10.0, exponentAccumulator);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return d;
    }
}

