/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.CharArrayPoolBatchSize;
import kotlinx.serialization.json.internal.InternalJsonReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010\"\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010%\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010)\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b)\u0010*J!\u0010-\u001a\u0004\u0018\u00010\u001d2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\r\u00a2\u0006\u0004\b/\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00100\u001a\u0004\b1\u00102R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00103\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001a\u00109\u001a\u0002088\u0014X\u0094\u0004\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "reader", "", "buffer", "<init>", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "", "canConsumeValue", "()Z", "", "unprocessedCount", "", "preload", "(I)V", "position", "prefetchOrEof", "(I)I", "", "consumeNextToken", "()B", "", "expected", "(C)V", "skipWhitespaces", "()I", "ensureHaveChars", "()V", "", "consumeKeyString", "()Ljava/lang/String;", "char", "startPos", "indexOf", "(CI)I", "endPos", "substring", "(II)Ljava/lang/String;", "fromIndex", "toIndex", "appendRange", "(II)V", "keyToMatch", "isLenient", "peekLeadingMatchingValue", "(Ljava/lang/String;Z)Ljava/lang/String;", "release", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "getReader", "()Lkotlinx/serialization/json/internal/InternalJsonReader;", "[C", "getBuffer", "()[C", "threshold", "I", "Lkotlinx/serialization/json/internal/ArrayAsSequence;", "source", "Lkotlinx/serialization/json/internal/ArrayAsSequence;", "getSource", "()Lkotlinx/serialization/json/internal/ArrayAsSequence;", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nReaderJsonLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReaderJsonLexer.kt\nkotlinx/serialization/json/internal/ReaderJsonLexer\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 3 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer$fail$1\n*L\n1#1,221:1\n158#2:222\n158#2:223\n158#2:224\n226#2,10:225\n229#3:235\n*S KotlinDebug\n*F\n+ 1 ReaderJsonLexer.kt\nkotlinx/serialization/json/internal/ReaderJsonLexer\n*L\n66#1:222\n133#1:223\n150#1:224\n181#1:225,10\n181#1:235\n*E\n"})
public class ReaderJsonLexer
extends AbstractJsonLexer {
    @NotNull
    private final InternalJsonReader reader;
    @NotNull
    private final char[] buffer;
    @JvmField
    protected int threshold;
    @NotNull
    private final ArrayAsSequence source;

    public ReaderJsonLexer(@NotNull InternalJsonReader reader, @NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.reader = reader;
        this.buffer = buffer;
        this.threshold = 128;
        this.source = new ArrayAsSequence(this.buffer);
        this.preload(0);
    }

    public /* synthetic */ ReaderJsonLexer(InternalJsonReader internalJsonReader, char[] cArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cArray = CharArrayPoolBatchSize.INSTANCE.take();
        }
        this(internalJsonReader, cArray);
    }

    @NotNull
    public final InternalJsonReader getReader() {
        return this.reader;
    }

    @NotNull
    public final char[] getBuffer() {
        return this.buffer;
    }

    @Override
    @NotNull
    protected ArrayAsSequence getSource() {
        return this.source;
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    private final void preload(int unprocessedCount) {
        int actual;
        char[] buffer = this.getSource().getBuffer$kotlinx_serialization_json();
        if (unprocessedCount != 0) {
            ArraysKt.copyInto(buffer, buffer, 0, this.currentPosition, this.currentPosition + unprocessedCount);
        }
        int sizeTotal = this.getSource().length();
        for (int filledCount = unprocessedCount; filledCount != sizeTotal; filledCount += actual) {
            actual = this.reader.read(buffer, filledCount, sizeTotal - filledCount);
            if (actual != -1) continue;
            this.getSource().trim(filledCount);
            this.threshold = -1;
            break;
        }
        this.currentPosition = 0;
    }

    @Override
    public int prefetchOrEof(int position) {
        if (position < this.getSource().length()) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch;
            byte tc;
            if ((tc = AbstractJsonLexerKt.charToTokenClass(ch = source.charAt(cpos++))) == 3) continue;
            this.currentPosition = cpos;
            return tc;
        }
        this.currentPosition = cpos;
        return 10;
    }

    @Override
    public void consumeNextToken(char expected) {
        this.ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.currentPosition;
        while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char c = source.charAt(cpos++);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = cpos;
        this.unexpectedToken(expected);
    }

    @Override
    public int skipWhitespaces() {
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if (!($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t')) break;
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Override
    public void ensureHaveChars() {
        int cur = this.currentPosition;
        int oldSize = this.getSource().length();
        int spaceLeft = oldSize - cur;
        if (spaceLeft > this.threshold) {
            return;
        }
        this.preload(spaceLeft);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = this.indexOf('\"', current);
        if (closingQuote == -1) {
            if ((current = this.prefetchOrEof(current)) == -1) {
                void source;
                String s$iv;
                void $this$iv;
                AbstractJsonLexer abstractJsonLexer = this;
                byte expectedToken$iv = 1;
                boolean wasConsumed$iv = true;
                boolean $i$f$fail$kotlinx_serialization_json = false;
                String expected$iv = AbstractJsonLexerKt.tokenDescription(expectedToken$iv);
                int position$iv = $this$iv.currentPosition - 1;
                String string = s$iv = $this$iv.currentPosition == AbstractJsonLexer.access$getSource((AbstractJsonLexer)$this$iv).length() || position$iv < 0 ? "EOF" : String.valueOf(AbstractJsonLexer.access$getSource((AbstractJsonLexer)$this$iv).charAt(position$iv));
                String string2 = expected$iv;
                void var13_13 = $this$iv;
                boolean bl = false;
                String expected = string2;
                AbstractJsonLexer.fail$default((AbstractJsonLexer)var13_13, "Expected " + expected + ", but had '" + (String)source + "' instead", position$iv, null, 4, null);
                throw new KotlinNothingValueException();
            }
            return this.consumeString(this.getSource(), this.currentPosition, current);
        }
        for (int i = current; i < closingQuote; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        return this.substring(current, closingQuote);
    }

    @Override
    public int indexOf(char c, int startPos) {
        ArrayAsSequence src = this.getSource();
        int n = src.length();
        for (int i = startPos; i < n; ++i) {
            if (src.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public String substring(int startPos, int endPos) {
        return this.getSource().substring(startPos, endPos);
    }

    @Override
    protected void appendRange(int fromIndex, int toIndex) {
        StringBuilder stringBuilder = this.getEscapedString();
        Intrinsics.checkNotNullExpressionValue(stringBuilder.append(this.getSource().getBuffer$kotlinx_serialization_json(), fromIndex, toIndex - fromIndex), "append(...)");
    }

    @Override
    @Nullable
    public String peekLeadingMatchingValue(@NotNull String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter(keyToMatch, "keyToMatch");
        return null;
    }

    public final void release() {
        CharArrayPoolBatchSize.INSTANCE.release(this.buffer);
    }
}

