/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.ChunkedDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonElementMarker;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001qB1\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\u0012*\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u001b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b#\u0010\"J\u000f\u0010$\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0011\u0010'\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020 H\u0002\u00a2\u0006\u0004\b)\u0010*J=\u0010.\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010,\u001a\u00020+2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\b\u0010-\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0017\u00100\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020+H\u0002\u00a2\u0006\u0004\b2\u00103J\u001f\u00104\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020+2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b6\u00101J\u001f\u00108\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00107\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b8\u00109J\u000f\u0010:\u001a\u00020+H\u0002\u00a2\u0006\u0004\b:\u00103J\u000f\u0010;\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b;\u0010%J\u000f\u0010=\u001a\u00020<H\u0016\u00a2\u0006\u0004\b=\u0010>J\u000f\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\b@\u0010AJ\u000f\u0010B\u001a\u00020+H\u0016\u00a2\u0006\u0004\bB\u00103J\u000f\u0010D\u001a\u00020CH\u0016\u00a2\u0006\u0004\bD\u0010EJ\u000f\u0010G\u001a\u00020FH\u0016\u00a2\u0006\u0004\bG\u0010HJ\u000f\u0010J\u001a\u00020IH\u0016\u00a2\u0006\u0004\bJ\u0010KJ\u000f\u0010M\u001a\u00020LH\u0016\u00a2\u0006\u0004\bM\u0010NJ\u000f\u0010O\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\bO\u0010PJ\u000f\u0010Q\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\bQ\u0010PJ2\u0010W\u001a\u00020 2!\u0010V\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\bS\u0012\b\bT\u0012\u0004\b\b(U\u0012\u0004\u0012\u00020 0RH\u0016\u00a2\u0006\u0004\bW\u0010XJ\u0017\u0010Z\u001a\u00020Y2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\bZ\u0010[J\u0017\u0010]\u001a\u00020+2\u0006\u0010\\\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b]\u00101R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010^\u001a\u0004\b_\u0010`R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010aR\u0014\u0010\t\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010bR\u001a\u0010d\u001a\u00020c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bd\u0010e\u001a\u0004\bf\u0010gR\u0016\u0010h\u001a\u00020+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u0018\u0010\r\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010jR\u0014\u0010l\u001a\u00020k8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u0016\u0010o\u001a\u0004\u0018\u00010n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010p\u00a8\u0006r"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/ChunkedDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/internal/WriteMode;", "mode", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "lexer", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "discriminatorHolder", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/AbstractJsonLexer;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;)V", "", "unknownKey", "", "trySkip", "(Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;Ljava/lang/String;)Z", "Lkotlinx/serialization/json/JsonElement;", "decodeJsonElement", "()Lkotlinx/serialization/json/JsonElement;", "T", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "skipLeftoverElements", "decodeNotNullMark", "()Z", "", "decodeNull", "()Ljava/lang/Void;", "checkLeadingComma", "()V", "", "index", "previousValue", "decodeSerializableElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeMapIndex", "()I", "coerceInputValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "decodeObjectIndex", "key", "handleUnknown", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Ljava/lang/String;)Z", "decodeListIndex", "decodeBoolean", "", "decodeByte", "()B", "", "decodeShort", "()S", "decodeInt", "", "decodeLong", "()J", "", "decodeFloat", "()F", "", "decodeDouble", "()D", "", "decodeChar", "()C", "decodeStringKey", "()Ljava/lang/String;", "decodeString", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "chunk", "consumeChunk", "decodeStringChunked", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlinx/serialization/encoding/Decoder;", "decodeInline", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/Decoder;", "enumDescriptor", "decodeEnum", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "Lkotlinx/serialization/json/internal/WriteMode;", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "currentIndex", "I", "Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "Lkotlinx/serialization/json/JsonConfiguration;", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "elementMarker", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "DiscriminatorHolder", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nStreamingJsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoder\n+ 2 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n+ 3 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n+ 4 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 5 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 6 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoderKt\n*L\n1#1,392:1\n78#2,6:393\n84#2,9:407\n270#3,8:399\n517#4,3:416\n517#4,3:419\n133#5,18:422\n385#6,5:440\n385#6,5:445\n*S KotlinDebug\n*F\n+ 1 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoder\n*L\n75#1:393,6\n75#1:407,9\n75#1:399,8\n202#1:416,3\n203#1:419,3\n215#1:422,18\n309#1:440,5\n316#1:445,5\n*E\n"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements JsonDecoder,
ChunkedDecoder {
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @JvmField
    @NotNull
    public final AbstractJsonLexer lexer;
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    @Nullable
    private DiscriminatorHolder discriminatorHolder;
    @NotNull
    private final JsonConfiguration configuration;
    @Nullable
    private final JsonElementMarker elementMarker;

    public StreamingJsonDecoder(@NotNull Json json, @NotNull WriteMode mode, @NotNull AbstractJsonLexer lexer, @NotNull SerialDescriptor descriptor2, @Nullable DiscriminatorHolder discriminatorHolder) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.json = json;
        this.mode = mode;
        this.lexer = lexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.discriminatorHolder = discriminatorHolder;
        this.configuration = this.json.getConfiguration();
        this.elementMarker = this.configuration.getExplicitNulls() ? null : new JsonElementMarker(descriptor2);
    }

    @Override
    @NotNull
    public final Json getJson() {
        return this.json;
    }

    private final boolean trySkip(DiscriminatorHolder $this$trySkip, String unknownKey) {
        if ($this$trySkip == null) {
            return false;
        }
        if (Intrinsics.areEqual($this$trySkip.discriminatorToSkip, unknownKey)) {
            $this$trySkip.discriminatorToSkip = null;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    @NotNull
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        try {
            DeserializationStrategy deserializationStrategy;
            if (!(deserializer instanceof AbstractPolymorphicSerializer) || this.json.getConfiguration().getUseArrayPolymorphism()) {
                return deserializer.deserialize(this);
            }
            String discriminator = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializer).getDescriptor(), this.json);
            String string = this.lexer.peekLeadingMatchingValue(discriminator, this.configuration.isLenient());
            if (string == null) {
                T t;
                void $this$decodeSerializableValuePolymorphic$iv;
                JsonDecoder jsonDecoder = this;
                DeserializationStrategy<T> deserializer$iv = deserializer;
                boolean $i$f$decodeSerializableValuePolymorphic = false;
                if (!(deserializer$iv instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
                    t = deserializer$iv.deserialize((Decoder)$this$decodeSerializableValuePolymorphic$iv);
                } else {
                    DeserializationStrategy deserializationStrategy2;
                    void value$iv$iv;
                    String discriminator$iv = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializer$iv).getDescriptor(), $this$decodeSerializableValuePolymorphic$iv.getJson());
                    JsonElement jsonElement = $this$decodeSerializableValuePolymorphic$iv.decodeJsonElement();
                    String serialName$iv$iv = ((AbstractPolymorphicSerializer)deserializer$iv).getDescriptor().getSerialName();
                    boolean $i$f$cast = false;
                    if (!(value$iv$iv instanceof JsonObject)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                        int n = -1;
                        boolean bl = false;
                        String string2 = this.lexer.path.getPath();
                        throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string2).toString(), value$iv$iv.toString());
                    }
                    JsonObject jsonTree$iv = (JsonObject)value$iv$iv;
                    JsonElement jsonElement2 = (JsonElement)jsonTree$iv.get((Object)discriminator$iv);
                    String type$iv = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
                    try {
                        deserializationStrategy2 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer$iv, (CompositeDecoder)$this$decodeSerializableValuePolymorphic$iv, type$iv);
                    }
                    catch (SerializationException it$iv) {
                        String string3 = it$iv.getMessage();
                        Intrinsics.checkNotNull(string3);
                        throw JsonExceptionsKt.JsonDecodingException(-1, string3, jsonTree$iv.toString());
                    }
                    DeserializationStrategy deserializationStrategy3 = deserializationStrategy2;
                    Intrinsics.checkNotNull(deserializationStrategy3, "null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.decodeSerializableValuePolymorphic>");
                    DeserializationStrategy actualSerializer$iv = deserializationStrategy3;
                    t = TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic$iv.getJson(), discriminator$iv, jsonTree$iv, actualSerializer$iv);
                }
                return t;
            }
            String type = string;
            try {
                deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer, this, type);
            }
            catch (SerializationException it) {
                String string4 = it.getMessage();
                Intrinsics.checkNotNull(string4);
                String message = StringsKt.removeSuffix(StringsKt.substringBefore$default(string4, '\n', null, 2, null), (CharSequence)".");
                String string5 = it.getMessage();
                Intrinsics.checkNotNull(string5);
                String hint = StringsKt.substringAfter(string5, '\n', "");
                AbstractJsonLexer.fail$default(this.lexer, message, 0, hint, 2, null);
                throw new KotlinNothingValueException();
            }
            DeserializationStrategy deserializationStrategy4 = deserializationStrategy;
            Intrinsics.checkNotNull(deserializationStrategy4, "null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.StreamingJsonDecoder.decodeSerializableValue>");
            DeserializationStrategy actualSerializer = deserializationStrategy4;
            this.discriminatorHolder = new DiscriminatorHolder(discriminator);
            return actualSerializer.deserialize(this);
        }
        catch (MissingFieldException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull(string);
            if (StringsKt.contains$default((CharSequence)string, "at path", false, 2, null)) {
                throw e;
            }
            throw new MissingFieldException(e.getMissingFields(), e.getMessage() + " at path: " + this.lexer.path.getPath(), e);
        }
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.json, descriptor2);
        this.lexer.path.pushDescriptor(descriptor2);
        this.lexer.consumeNextToken(newMode.begin);
        this.checkLeadingComma();
        switch (WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2, this.discriminatorHolder);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode && this.json.getConfiguration().getExplicitNulls() ? this : new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2, this.discriminatorHolder);
            }
        }
        return compositeDecoder;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2.getElementsCount() == 0 && JsonNamesMapKt.ignoreUnknownKeys(descriptor2, this.json)) {
            this.skipLeftoverElements(descriptor2);
        }
        if (this.lexer.tryConsumeComma() && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma(this.lexer, "");
            throw new KotlinNothingValueException();
        }
        this.lexer.consumeNextToken(this.mode.end);
        this.lexer.path.popDescriptor();
    }

    private final void skipLeftoverElements(SerialDescriptor descriptor2) {
        while (this.decodeElementIndex(descriptor2) != -1) {
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        JsonElementMarker jsonElementMarker = this.elementMarker;
        return !(jsonElementMarker != null ? jsonElementMarker.isUnmarkedNull$kotlinx_serialization_json() : false) && !AbstractJsonLexer.tryConsumeNull$default(this.lexer, false, 1, null);
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public <T> T decodeSerializableElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        boolean isMapKey;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        boolean bl = isMapKey = this.mode == WriteMode.MAP && (index & 1) == 0;
        if (isMapKey) {
            this.lexer.path.resetCurrentMapKey();
        }
        T value = super.decodeSerializableElement(descriptor2, index, deserializer, previousValue);
        if (isMapKey) {
            this.lexer.path.updateCurrentMapKey(value);
        }
        return value;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int index;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 4: {
                int n = this.decodeObjectIndex(descriptor2);
                break;
            }
            case 2: {
                int n = this.decodeMapIndex();
                break;
            }
            default: {
                int n = index = this.decodeListIndex();
            }
        }
        if (this.mode != WriteMode.MAP) {
            this.lexer.path.updateDescriptorIndex(index);
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeMapIndex() {
        int n;
        boolean decodingKey;
        boolean hasComma = false;
        boolean bl = decodingKey = this.currentIndex % 2 != 0;
        if (decodingKey) {
            if (this.currentIndex != -1) {
                hasComma = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            if (decodingKey) {
                if (this.currentIndex == -1) {
                    void $this$iv;
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean condition$iv = !hasComma;
                    int position$iv = $this$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!condition$iv) {
                        void var8_11 = $this$iv;
                        boolean bl2 = false;
                        AbstractJsonLexer.fail$default((AbstractJsonLexer)var8_11, "Unexpected leading comma", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    AbstractJsonLexer $this$iv = this.lexer;
                    boolean condition$iv = hasComma;
                    int position$iv = $this$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!condition$iv) {
                        AbstractJsonLexer abstractJsonLexer = $this$iv;
                        boolean bl3 = false;
                        AbstractJsonLexer.fail$default(abstractJsonLexer, "Expected comma after the key-value pair", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index) {
        void $this$tryCoerceValue$iv;
        boolean bl;
        boolean it;
        void index$iv;
        void descriptor$iv;
        Json json = this.json;
        SerialDescriptor serialDescriptor = descriptor2;
        int n = index;
        boolean $i$f$tryCoerceValue = false;
        boolean isOptional$iv = descriptor$iv.isElementOptional((int)index$iv);
        SerialDescriptor elementDescriptor$iv = descriptor$iv.getElementDescriptor((int)index$iv);
        if (isOptional$iv && !elementDescriptor$iv.isNullable()) {
            it = true;
            bl = false;
            if (this.lexer.tryConsumeNull(it)) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        if (elementDescriptor$iv.isNullable()) {
            it = false;
            bl = false;
            if (this.lexer.tryConsumeNull(it)) {
                return false;
            }
        }
        boolean bl2 = false;
        String string = this.lexer.peekString(this.configuration.isLenient());
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex(elementDescriptor$iv, (Json)$this$tryCoerceValue$iv, enumValue$iv);
        boolean coerceToNull$iv = !$this$tryCoerceValue$iv.getConfiguration().getExplicitNulls() && elementDescriptor$iv.isNullable();
        if (enumIndex$iv != -3) return false;
        if (!isOptional$iv) {
            if (!coerceToNull$iv) return false;
        }
        boolean bl3 = false;
        this.lexer.consumeString();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int decodeObjectIndex(SerialDescriptor descriptor2) {
        boolean hasComma = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            boolean isUnknown;
            boolean bl;
            String key;
            block5: {
                hasComma = false;
                key = this.decodeStringKey();
                this.lexer.consumeNextToken(':');
                int index = JsonNamesMapKt.getJsonNameIndex(descriptor2, this.json, key);
                if (index != -3) {
                    if (this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, index)) {
                        hasComma = this.lexer.tryConsumeComma();
                        bl = false;
                        break block5;
                    } else {
                        JsonElementMarker jsonElementMarker = this.elementMarker;
                        if (jsonElementMarker == null) return index;
                        jsonElementMarker.mark$kotlinx_serialization_json(index);
                        return index;
                    }
                }
                bl = true;
            }
            if (!(isUnknown = bl)) continue;
            hasComma = this.handleUnknown(descriptor2, key);
        }
        if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
            throw new KotlinNothingValueException();
        }
        JsonElementMarker jsonElementMarker = this.elementMarker;
        if (jsonElementMarker == null) return -1;
        int n = jsonElementMarker.nextUnmarkedIndex$kotlinx_serialization_json();
        return n;
    }

    private final boolean handleUnknown(SerialDescriptor descriptor2, String key) {
        if (JsonNamesMapKt.ignoreUnknownKeys(descriptor2, this.json) || this.trySkip(this.discriminatorHolder, key)) {
            this.lexer.skipElement(this.configuration.isLenient());
        } else {
            this.lexer.path.popDescriptor();
            this.lexer.failOnUnknownKey(key);
        }
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        int n;
        boolean hasComma = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma(this.lexer, "array");
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    @Override
    public boolean decodeBoolean() {
        return this.lexer.consumeBooleanLenient();
    }

    @Override
    public byte decodeByte() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((byte)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (byte)value;
    }

    @Override
    public short decodeShort() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((short)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (short)value;
    }

    @Override
    public int decodeInt() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((int)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (int)value;
    }

    @Override
    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float decodeFloat() {
        float f;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "float";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeFloat_u24lambda_u246 = input$iv;
            boolean bl = false;
            f = Float.parseFloat($this$decodeFloat_u24lambda_u246);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        float result = f;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || Math.abs(result) <= Float.MAX_VALUE) {
            return result;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(result));
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double decodeDouble() {
        double d;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "double";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeDouble_u24lambda_u247 = input$iv;
            boolean bl = false;
            d = Double.parseDouble($this$decodeDouble_u24lambda_u247);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        double result = d;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || Math.abs(result) <= Double.MAX_VALUE) {
            return result;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, result);
        throw new KotlinNothingValueException();
    }

    @Override
    public char decodeChar() {
        String string = this.lexer.consumeStringLenient();
        if (string.length() != 1) {
            AbstractJsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return string.charAt(0);
    }

    private final String decodeStringKey() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeKeyString();
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeString();
    }

    @Override
    public void decodeStringChunked(@NotNull Function1<? super String, Unit> consumeChunk) {
        Intrinsics.checkNotNullParameter(consumeChunk, "consumeChunk");
        this.lexer.consumeStringChunked(this.configuration.isLenient(), consumeChunk);
    }

    @Override
    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(descriptor2) ? (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json) : super.decodeInline(descriptor2);
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        return JsonNamesMapKt.getJsonNameIndexOrThrow(enumDescriptor, this.json, this.decodeString(), " at path " + this.lexer.path.getPath());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "", "", "discriminatorToSkip", "<init>", "(Ljava/lang/String;)V", "Ljava/lang/String;", "kotlinx-serialization-json"})
    public static final class DiscriminatorHolder {
        @JvmField
        @Nullable
        public String discriminatorToSkip;

        public DiscriminatorHolder(@Nullable String discriminatorToSkip) {
            this.discriminatorToSkip = discriminatorToSkip;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.OBJ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

