/*
 * Decompiled with CFR 0.152.
 */
package io.github.meatwo310.appliedsorting.ae2;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.LocalizationEnum;
import appeng.util.EnumCycler;
import io.github.meatwo310.appliedsorting.ae2.CustomButtonTooltips;
import io.github.meatwo310.appliedsorting.ae2.CustomIcon;
import io.github.meatwo310.appliedsorting.ae2.CustomIconButton;
import io.github.meatwo310.appliedsorting.config.ClientConfig;
import io.github.meatwo310.appliedsorting.config.SortBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class ConfigToggleButton<T extends Enum<T>>
extends CustomIconButton {
    private static Map<EnumPair<?>, ButtonAppearance> appearances;
    private final ModConfigSpec.EnumValue<T> configSpec;
    private final IHandler<ConfigToggleButton<T>> onPress;
    private final EnumSet<T> validValues;
    private T currentValue;

    public ConfigToggleButton(ModConfigSpec.EnumValue<T> configSpec, IHandler<ConfigToggleButton<T>> onPress) {
        this(configSpec, (Enum)configSpec.get(), onPress);
    }

    public ConfigToggleButton(ModConfigSpec.EnumValue<T> configSpec, T val, IHandler<ConfigToggleButton<T>> onPress) {
        this((ModConfigSpec.EnumValue<Enum>)configSpec, (Enum)val, t -> true, (IHandler<ConfigToggleButton<Enum>>)onPress);
    }

    public ConfigToggleButton(ModConfigSpec.EnumValue<T> configSpec, T val, Predicate<T> isValidValue, IHandler<ConfigToggleButton<T>> onPress) {
        super(ConfigToggleButton::onPress);
        this.onPress = onPress;
        EnumSet<T> validValues = EnumSet.allOf(((Enum)val).getDeclaringClass());
        validValues.removeIf(isValidValue.negate());
        this.validValues = validValues;
        this.configSpec = configSpec;
        this.currentValue = val;
        if (appearances == null) {
            appearances = new HashMap();
            ConfigToggleButton.registerApp(CustomIcon.SORT_BY_ID.getBlitter(), ClientConfig.ALTERNATIVE_SORT, SortBy.INTERNAL_ID, (LocalizationEnum)ButtonToolTips.SortBy, CustomButtonTooltips.InternalId);
            ConfigToggleButton.registerApp(CustomIcon.SORT_BY_RESOURCE_LOCATION.getBlitter(), ClientConfig.ALTERNATIVE_SORT, SortBy.RESOURCE_LOCATION, (LocalizationEnum)ButtonToolTips.SortBy, CustomButtonTooltips.ResourceLocation);
            ConfigToggleButton.registerApp(Icon.SORT_BY_NAME.getBlitter(), ClientConfig.ALTERNATIVE_SORT, SortBy.NAME, (LocalizationEnum)ButtonToolTips.SortBy, (LocalizationEnum)ButtonToolTips.ItemName);
            ConfigToggleButton.registerApp(Icon.SORT_BY_AMOUNT.getBlitter(), ClientConfig.ALTERNATIVE_SORT, SortBy.AMOUNT, (LocalizationEnum)ButtonToolTips.SortBy, (LocalizationEnum)ButtonToolTips.NumberOfItems);
            ConfigToggleButton.registerApp(Icon.SORT_BY_MOD.getBlitter(), ClientConfig.ALTERNATIVE_SORT, SortBy.MOD, (LocalizationEnum)ButtonToolTips.SortBy, (LocalizationEnum)ButtonToolTips.Mod);
        }
    }

    private static void onPress(Button button) {
        if (button instanceof ConfigToggleButton) {
            ((ConfigToggleButton)button).triggerPress();
        }
    }

    private static <T extends Enum<T>> void registerApp(Blitter blitter, ModConfigSpec.EnumValue<T> setting, T val, LocalizationEnum title, Component ... tooltipLines) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)title.text());
        Collections.addAll(lines, tooltipLines);
        appearances.put(new EnumPair<T>(setting, val), new ButtonAppearance(blitter, null, lines));
    }

    private static <T extends Enum<T>> void registerApp(ItemLike item, ModConfigSpec.EnumValue<T> setting, T val, LocalizationEnum title, Component ... tooltipLines) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)title.text());
        Collections.addAll(lines, tooltipLines);
        appearances.put(new EnumPair<T>(setting, val), new ButtonAppearance(null, item.asItem(), lines));
    }

    private static <T extends Enum<T>> void registerApp(Blitter blitter, ModConfigSpec.EnumValue<T> setting, T val, LocalizationEnum title, LocalizationEnum hint) {
        ConfigToggleButton.registerApp(blitter, setting, val, title, new Component[]{hint.text()});
    }

    private void triggerPress() {
        boolean backwards = false;
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen instanceof AEBaseScreen) {
            backwards = ((AEBaseScreen)currentScreen).isHandlingRightClick();
        }
        this.onPress.handle(this, backwards);
    }

    private ButtonAppearance getAppearance() {
        if (this.configSpec != null && this.currentValue != null) {
            return appearances.get(new EnumPair<T>(this.configSpec, this.currentValue));
        }
        return null;
    }

    @Override
    protected Blitter getBlitter() {
        ButtonAppearance appearance = this.getAppearance();
        if (appearance != null && appearance.blitter != null) {
            return appearance.blitter();
        }
        return Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter();
    }

    @Override
    @Nullable
    protected Item getItemOverlay() {
        ButtonAppearance appearance = this.getAppearance();
        if (appearance != null && appearance.item != null) {
            return appearance.item();
        }
        return null;
    }

    public ModConfigSpec.EnumValue<T> getSetting() {
        return this.configSpec;
    }

    public T getCurrentValue() {
        return this.currentValue;
    }

    public void set(T e) {
        if (this.currentValue != e) {
            this.currentValue = e;
        }
    }

    public T getNextValue(boolean backwards) {
        return (T)EnumCycler.rotateEnum(this.currentValue, (boolean)backwards, this.validValues);
    }

    public void toggleConfig(boolean backwards) {
        T next = this.getNextValue(backwards);
        this.configSpec.set(next);
        this.set(next);
    }

    @Override
    public List<Component> getTooltipMessage() {
        if (this.configSpec == null || this.currentValue == null) {
            return Collections.emptyList();
        }
        ButtonAppearance buttonAppearance = appearances.get(new EnumPair<T>(this.configSpec, this.currentValue));
        if (buttonAppearance == null) {
            return Collections.singletonList(ButtonToolTips.NoSuchMessage.text());
        }
        return buttonAppearance.tooltipLines;
    }

    public static interface IHandler<T extends ConfigToggleButton<?>> {
        public void handle(T var1, boolean var2);
    }

    private static final class EnumPair<T extends Enum<T>> {
        final ModConfigSpec.EnumValue<T> setting;
        final T value;

        public EnumPair(ModConfigSpec.EnumValue<T> setting, T value) {
            this.setting = setting;
            this.value = value;
        }

        public int hashCode() {
            return this.setting.hashCode() ^ ((Enum)this.value).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPair other = (EnumPair)obj;
            return other.setting == this.setting && other.value == this.value;
        }
    }

    private record ButtonAppearance(@javax.annotation.Nullable Blitter blitter, @javax.annotation.Nullable Item item, List<Component> tooltipLines) {
    }
}

