/*
 * Decompiled with CFR 0.152.
 */
package io.github.meatwo310.appliedsorting.ae2;

import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomIconButton
extends Button
implements ITooltip {
    private boolean halfSize = false;
    private boolean disableClickSound = false;
    private boolean disableBackground = false;

    protected CustomIconButton(Button.OnPress onPress) {
        super(0, 0, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
    }

    public void setVisibility(boolean visibility) {
        this.visible = visibility;
        this.active = visibility;
    }

    public void playDownSound(@NotNull SoundManager handler) {
        if (!this.disableClickSound) {
            super.playDownSound(handler);
        }
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            Blitter blitter = this.getBlitter();
            if (!this.active) {
                blitter.opacity(0.5f);
            }
            if (this.halfSize) {
                this.width = 8;
                this.height = 8;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            if (this.halfSize) {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.translate((float)this.getX(), (float)this.getY(), 0.0f);
                pose.scale(0.5f, 0.5f, 1.0f);
                if (!this.disableBackground) {
                    this.renderBackground(guiGraphics);
                }
                this.renderIcon(guiGraphics);
                pose.popPose();
            } else {
                if (!this.disableBackground) {
                    this.renderBackground(guiGraphics);
                }
                this.renderIcon(guiGraphics);
            }
            RenderSystem.enableDepthTest();
            Item item = this.getItemOverlay();
            if (item != null) {
                guiGraphics.renderItem(new ItemStack((ItemLike)item), this.getX(), this.getY());
            }
        }
    }

    private void renderBackground(GuiGraphics guiGraphics) {
        if (this.isHovered()) {
            Icon.TOOLBAR_BUTTON_BACKGROUND_HOVER.getBlitter().dest(this.getX() - 1, this.getY() + 1).blit(guiGraphics);
        } else if (this.isFocused()) {
            Icon.TOOLBAR_BUTTON_BACKGROUND_FOCUS.getBlitter().dest(this.getX() - 1, this.getY()).blit(guiGraphics);
        } else {
            Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(this.getX() - 1, this.getY()).blit(guiGraphics);
        }
    }

    private void renderIcon(GuiGraphics guiGraphics) {
        if (this.isHovered) {
            this.getBlitter().dest(this.getX(), this.getY() + 2).blit(guiGraphics);
        } else {
            this.getBlitter().dest(this.getX(), this.getY() + 1).blit(guiGraphics);
        }
    }

    @Deprecated
    protected Icon getIcon() {
        throw new UnsupportedOperationException("Use getBlitter() instead");
    }

    protected abstract Blitter getBlitter();

    @Nullable
    protected Item getItemOverlay() {
        return null;
    }

    public List<Component> getTooltipMessage() {
        return Collections.singletonList(this.getMessage());
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), this.halfSize ? 8 : 16, this.halfSize ? 8 : 16);
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public boolean isDisableClickSound() {
        return this.disableClickSound;
    }

    public void setDisableClickSound(boolean disableClickSound) {
        this.disableClickSound = disableClickSound;
    }

    public boolean isDisableBackground() {
        return this.disableBackground;
    }

    public void setDisableBackground(boolean disableBackground) {
        this.disableBackground = disableBackground;
    }
}

