/*
 * Decompiled with CFR 0.152.
 */
package io.github.meatwo310.appliedsorting.sort;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import java.util.Comparator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class Comparators {
    public static final Comparator<AEKey> RESOURCELOC_ASC = Comparator.comparing(AEKey::getId, ResourceLocation::compareNamespaced);
    public static final Comparator<AEKey> RESOURCELOC_DESC = RESOURCELOC_ASC.reversed();
    public static final Comparator<AEKey> RESOURCELOC_ASC_MC_FIRST = Comparator.comparing(key -> !key.getId().getNamespace().equals("minecraft")).thenComparing(AEKey::getId, ResourceLocation::compareNamespaced);
    public static final Comparator<AEKey> RESOURCELOC_DESC_MC_LAST = RESOURCELOC_ASC_MC_FIRST.reversed();
    public static final Comparator<AEKey> ID_ASC = Comparator.comparing(Comparators::isNotItem).thenComparing(Comparators::isNotFluid).thenComparing(Comparators::getTypeId, ResourceLocation::compareNamespaced).thenComparing(Comparators::getRegistryId).thenComparing(AEKey::getId, ResourceLocation::compareNamespaced);
    public static final Comparator<AEKey> ID_DESC = ID_ASC.reversed();

    private static boolean isNotItem(AEKey key) {
        return !(key instanceof AEItemKey);
    }

    private static boolean isNotFluid(AEKey key) {
        return !(key instanceof AEFluidKey);
    }

    private static ResourceLocation getTypeId(AEKey key) {
        return key.getType().getId();
    }

    private static int getRegistryId(AEKey key) {
        if (key instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)key;
            return BuiltInRegistries.ITEM.getId((Object)itemKey.getItem());
        }
        if (key instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)key;
            return BuiltInRegistries.FLUID.getId((Object)fluidKey.getFluid());
        }
        return 0;
    }
}

