/*
 * Decompiled with CFR 0.152.
 */
package io.github.meatwo310.appliedsorting.sort;

import appeng.api.config.SortDir;
import appeng.api.stacks.AEKey;
import io.github.meatwo310.appliedsorting.config.ClientConfig;
import io.github.meatwo310.appliedsorting.config.SortBy;
import io.github.meatwo310.appliedsorting.sort.Comparators;
import java.util.Comparator;
import java.util.Optional;

public class Sorter {
    public static Optional<Comparator<AEKey>> sort(SortDir dir, SortBy sortBy) {
        return switch (sortBy) {
            default -> throw new MatchException(null, null);
            case SortBy.NAME, SortBy.AMOUNT, SortBy.MOD -> Optional.empty();
            case SortBy.RESOURCE_LOCATION -> Sorter.byResourceLocation(dir);
            case SortBy.INTERNAL_ID -> Sorter.ascOrDesc(dir, Comparators.ID_ASC, Comparators.ID_DESC);
        };
    }

    private static Optional<Comparator<AEKey>> ascOrDesc(SortDir dir, Comparator<AEKey> left, Comparator<AEKey> right) {
        return Optional.of(dir == SortDir.ASCENDING ? left : right);
    }

    private static Optional<Comparator<AEKey>> byResourceLocation(SortDir dir) {
        if (((Boolean)ClientConfig.RESOURCE_LOCATION_MINECRAFT_FIRST.get()).booleanValue()) {
            return Sorter.ascOrDesc(dir, Comparators.RESOURCELOC_ASC_MC_FIRST, Comparators.RESOURCELOC_DESC_MC_LAST);
        }
        return Sorter.ascOrDesc(dir, Comparators.RESOURCELOC_ASC, Comparators.RESOURCELOC_DESC);
    }
}

