/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom;

import com.belgie.moobloom.MoobloomRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class MoobloomLayer
extends RenderLayer<MoobloomRenderState, CowModel> {
    private final BlockRenderDispatcher blockRenderer;

    public MoobloomLayer(RenderLayerParent<MoobloomRenderState, CowModel> p_234850_, BlockRenderDispatcher p_234851_) {
        super(p_234850_);
        this.blockRenderer = p_234851_;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, MoobloomRenderState renderState, float yRot, float xRot) {
        if (!renderState.isBaby) {
            boolean flag;
            boolean bl = flag = renderState.appearsGlowing() && renderState.isInvisible;
            if (!renderState.isInvisible || flag) {
                BlockState blockstate = renderState.variant.block();
                int i = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)renderState, (float)0.0f);
                BlockStateModel blockstatemodel = this.blockRenderer.getBlockModel(blockstate);
                poseStack.pushPose();
                poseStack.translate(0.2f, -0.35f, 0.5f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-48.0f));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.submitMushroomBlock(poseStack, nodeCollector, packedLight, flag, renderState.outlineColor, blockstate, i, blockstatemodel);
                poseStack.popPose();
                poseStack.pushPose();
                poseStack.translate(0.2f, -0.35f, 0.5f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(42.0f));
                poseStack.translate(0.1f, 0.0f, -0.6f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-48.0f));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.submitMushroomBlock(poseStack, nodeCollector, packedLight, flag, renderState.outlineColor, blockstate, i, blockstatemodel);
                poseStack.popPose();
                poseStack.pushPose();
                ((CowModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
                poseStack.translate(0.0f, -0.7f, -0.2f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-78.0f));
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                poseStack.translate(-0.5f, -0.5f, -0.5f);
                this.submitMushroomBlock(poseStack, nodeCollector, packedLight, flag, renderState.outlineColor, blockstate, i, blockstatemodel);
                poseStack.popPose();
            }
        }
    }

    private void submitMushroomBlock(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, boolean renderOutline, int outlineColor, BlockState blockState, int packedOverlay, BlockStateModel model) {
        if (renderOutline) {
            nodeCollector.submitBlockModel(poseStack, RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), model, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay, outlineColor);
        } else {
            nodeCollector.submitBlock(poseStack, blockState, packedLight, packedOverlay, outlineColor);
        }
    }
}

