/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.moobloom;

import com.belgie.moobloom.MoobloomEntity;
import com.belgie.moobloom.variant.MoobloomVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PlaceFlowerGoal
extends Goal {
    private final MoobloomEntity moobloom;

    public PlaceFlowerGoal(MoobloomEntity entity) {
        this.moobloom = entity;
    }

    public boolean canUse() {
        return ((MoobloomVariant)this.moobloom.getVariant().value()).placeflowers() && this.moobloom.getRandom().nextInt(PlaceFlowerGoal.reducedTickDelay((int)2000)) == 0;
    }

    private boolean canPlaceOn(Level world, BlockPos posAbove, BlockState carriedState, BlockState stateAbove, BlockState state, BlockPos pos) {
        return stateAbove.isAir() && !state.isAir() && !state.is(Blocks.BEDROCK) && state.isCollisionShapeFullBlock((BlockGetter)world, pos) && carriedState.canSurvive((LevelReader)world, posAbove) && world.getEntities((Entity)this.moobloom, AABB.unitCubeFromLowerCorner((Vec3)Vec3.atLowerCornerOf((Vec3i)posAbove))).isEmpty();
    }

    public void tick() {
        RandomSource random = this.moobloom.getRandom();
        Level world = this.moobloom.level();
        int i = Mth.floor((double)this.moobloom.getX());
        int j = Mth.floor((double)(this.moobloom.getY() + random.nextDouble() * 2.0));
        int k = Mth.floor((double)this.moobloom.getZ());
        BlockPos blockPos = new BlockPos(i, j, k);
        BlockState blockState = world.getBlockState(blockPos);
        BlockPos blockPos2 = blockPos.below();
        BlockState blockState2 = world.getBlockState(blockPos2);
        BlockState blockState3 = ((MoobloomVariant)this.moobloom.getVariant().value()).block().getBlock().defaultBlockState();
        if (blockState3 != null && this.canPlaceOn(world, blockPos, blockState3 = Block.updateFromNeighbourShapes((BlockState)blockState3, (LevelAccessor)this.moobloom.level(), (BlockPos)blockPos), blockState, blockState2, blockPos2)) {
            world.setBlock(blockPos, blockState3, 3);
        }
    }
}

