/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers;

import com.belgie.movillagers.Config;
import com.belgie.movillagers.ProfessionRegistry;
import com.belgie.movillagers.Screen.TradesBookItem;
import com.belgie.movillagers.Screen.TradesMenu;
import com.belgie.movillagers.Screen.TradesScreen;
import com.belgie.movillagers.TradeReg;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="movillagers")
public class MoVillagersMod {
    public static final String MOD_ID = "movillagers";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<MenuType<?>> MENU = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"movillagers");
    public static final DeferredRegister<Item> ITEM = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"movillagers");
    public static final DeferredRegister<DataComponentType<?>> DATA = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"movillagers");
    public static final Supplier<DataComponentType<ResourceKey<VillagerProfession>>> VILLAGER_PROFESSION = MoVillagersMod.register("villager_profession", p_370373_ -> p_370373_.persistent(ResourceKey.codec((ResourceKey)Registries.VILLAGER_PROFESSION)).networkSynchronized(ResourceKey.streamCodec((ResourceKey)Registries.VILLAGER_PROFESSION)).cacheEncoding());
    public static final Supplier<MenuType<TradesMenu>> INFORMATION_MENU = MoVillagersMod.registerMenuType(TradesMenu::new, "trades");
    public static final Supplier<Item> TRADES_BOOK = ITEM.register("trades_book", () -> new TradesBookItem(new Item.Properties().stacksTo(1).component(VILLAGER_PROFESSION.get(), (Object)VillagerProfession.FARMER).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"trades_book")))));

    private static <T> Supplier<DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return DATA.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    private static <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenuType(IContainerFactory<T> factory, String name) {
        return MENU.register(name, () -> new MenuType((MenuType.MenuSupplier)factory, FeatureFlagSet.of()));
    }

    public MoVillagersMod(FMLJavaModLoadingContext context) {
        BusGroup modEventBus = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modEventBus).addListener(this::commonSetup);
        ITEM.register(modEventBus);
        DATA.register(modEventBus);
        MENU.register(modEventBus);
        ProfessionRegistry.PROFESSIONS.register(modEventBus);
        ProfessionRegistry.POI.register(modEventBus);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)modEventBus).addListener(MoVillagersMod::creativeTabs);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TradeReg.setupTrades();
        event.enqueueWork(() -> {
            GiveGiftToHero.GIFTS = ImmutableMap.builder().putAll(GiveGiftToHero.GIFTS).put(ProfessionRegistry.ANCIENT_EXPLORER_KEY, ProfessionRegistry.VILLAGER_ANCIENT).put(ProfessionRegistry.FLORIST_KEY, ProfessionRegistry.VILLAGER_FLORIST).put(ProfessionRegistry.LUMBER_JACK_KEY, ProfessionRegistry.VILLAGER_LUMBER).put(ProfessionRegistry.MINER_KEY, ProfessionRegistry.VILLAGER_MINER).put(ProfessionRegistry.OCEAN_EXPLORER_KEY, ProfessionRegistry.VILLAGER_OCEAN).put(ProfessionRegistry.UNDERWORLD_EXPLORER_KEY, ProfessionRegistry.VILLAGER_NETHER).build();
        });
    }

    private static void creativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.BOOK), (Object)new ItemStack((ItemLike)TRADES_BOOK.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @Mod.EventBusSubscriber(modid="movillagers", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.register(INFORMATION_MENU.get(), TradesScreen::new);
        }
    }
}

