/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers.Screen;

import com.belgie.movillagers.Screen.TradesButton;
import com.belgie.movillagers.Screen.TradesMenu;
import com.belgie.movillagers.TradeReg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TradesScreen
extends AbstractContainerScreen<TradesMenu> {
    private static final ResourceLocation BEACON_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"movillagers", (String)"textures/gui/trades.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller");
    private static final ResourceLocation SCROLLER_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/villager/scroller_disabled");
    private static final int OFFER_UPDATE_TICKS = 60;
    private static final Component[] LEVEL_NAMES = new Component[]{Component.literal((String)"Invalid"), Component.translatable((String)"merchant.level.1"), Component.translatable((String)"merchant.level.2"), Component.translatable((String)"merchant.level.3"), Component.translatable((String)"merchant.level.4"), Component.translatable((String)"merchant.level.5")};
    private static final WidgetSprites PAGE_FORWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward"), ResourceLocation.fromNamespaceAndPath((String)"movillagers", (String)"recipe_book/page_forward_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward_highlighted"));
    private static final WidgetSprites PAGE_BACKWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward"), ResourceLocation.fromNamespaceAndPath((String)"movillagers", (String)"recipe_book/page_backward_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward_highlighted"));
    private final Map<Integer, VillagerTrades.ItemListing[]> tradesByLevel;
    private final Map<VillagerTrades.ItemListing, CachedOffer> cachedOffers = new HashMap<VillagerTrades.ItemListing, CachedOffer>();
    private final List<TradesButton> tradeButtons = new ArrayList<TradesButton>();
    private int currentTradeLevel = 1;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private Button nextButton;
    private Button backButton;
    private List<RenderedOfferRow> cachedOfferRows = Collections.emptyList();
    private int globalTickCounter = 0;

    public TradesScreen(TradesMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 111;
        this.imageHeight = 199;
        this.tradesByLevel = (Map)VillagerTrades.TRADES.get(menu.getProfession());
    }

    protected void containerTick() {
        this.nextButton.visible = this.currentTradeLevel != 5;
        this.backButton.visible = this.currentTradeLevel != 1;
        super.containerTick();
    }

    protected void init() {
        super.init();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.backButton = new ImageButton(i + 21, j + 173, 12, 17, PAGE_BACKWARD_SPRITES, b -> {
            if (this.currentTradeLevel > 1) {
                --this.currentTradeLevel;
                this.scrollOffset = 0;
                this.refreshTradeButtons(true);
            }
        }, (Component)Component.translatable((String)"trades.screen.back"));
        this.addRenderableWidget((GuiEventListener)this.backButton);
        this.nextButton = new ImageButton(i + 79, j + 173, 12, 17, PAGE_FORWARD_SPRITES, b -> {
            if (this.currentTradeLevel < 5) {
                ++this.currentTradeLevel;
                this.scrollOffset = 0;
                this.refreshTradeButtons(true);
            }
        }, (Component)Component.translatable((String)"trades.screen.next"));
        this.addRenderableWidget((GuiEventListener)this.nextButton);
        this.backButton.visible = false;
        this.refreshTradeButtons(true);
    }

    private void refreshTradeButtons(boolean updates) {
        VillagerTrades.ItemListing[] listings;
        this.tradeButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.tradeButtons.clear();
        if (updates) {
            TradesButton.renderedItems.clear();
        }
        if ((listings = this.tradesByLevel.get(this.currentTradeLevel)) == null) {
            return;
        }
        if (this.tradesByLevel == null) {
            return;
        }
        List<RenderedOfferRow> rows = this.createRowsFromListings(listings);
        this.maxScroll = Math.max(0, rows.size() - 7);
        int visibleStart = this.scrollOffset = Math.min(this.scrollOffset, this.maxScroll);
        int visibleEnd = Math.min(rows.size(), this.scrollOffset + 7);
        int left = (this.width - this.imageWidth) / 2;
        int top = (this.height - this.imageHeight) / 2;
        int y = top + 29;
        for (int i = visibleStart; i < visibleEnd; ++i) {
            RenderedOfferRow row = rows.get(i);
            TradesButton button = new TradesButton((Screen)this, left + 8, y, this.currentTradeLevel, row);
            this.tradeButtons.add(button);
            this.addRenderableWidget((GuiEventListener)button);
            y += 20;
        }
    }

    private List<RenderedOfferRow> createRowsFromListings(VillagerTrades.ItemListing[] listings) {
        Villager villager = new Villager(EntityType.VILLAGER, (Level)this.minecraft.level);
        villager.setVillagerData(villager.getVillagerData().withLevel(5).withType((HolderGetter.Provider)this.minecraft.level.registryAccess(), VillagerType.PLAINS));
        ArrayList<RenderedOfferRow> offerRows = new ArrayList<RenderedOfferRow>();
        for (VillagerTrades.ItemListing listing : listings) {
            MerchantOffer offer;
            CachedOffer cached;
            block8: {
                block10: {
                    MerchantOffer dynamicOffer;
                    block9: {
                        if (listing instanceof TradeReg.ItemTagForItem) {
                            TradeReg.ItemTagForItem tagListing = (TradeReg.ItemTagForItem)listing;
                            for (ItemStack variant : tagListing.getAllTagVariants()) {
                                offerRows.add(new RenderedOfferRow(new ItemStack((ItemLike)Items.EMERALD, tagListing.GetEmeraldInput()), tagListing.hasDiamonds() ? new ItemStack((ItemLike)Items.DIAMOND, 7) : ItemStack.EMPTY, new ItemStack((ItemLike)variant.getItem(), tagListing.getItemCost())));
                            }
                            continue;
                        }
                        if (!this.isRandomizedTrade(listing)) break block8;
                        cached = this.cachedOffers.get(listing);
                        if (cached == null) break block9;
                        if (this.globalTickCounter - CachedOffer.tickCounter < 60) break block10;
                    }
                    if ((dynamicOffer = listing.getOffer((Entity)villager, this.minecraft.level.getRandom())) != null) {
                        cached = new CachedOffer(dynamicOffer);
                        this.cachedOffers.put(listing, cached);
                    }
                }
                if (cached == null || cached.offer == null) continue;
                offer = cached.offer;
                offerRows.add(new RenderedOfferRow(offer.getBaseCostA(), offer.getCostB(), offer.getResult()));
                continue;
            }
            cached = this.cachedOffers.computeIfAbsent(listing, l -> {
                MerchantOffer offer = l.getOffer((Entity)villager, this.minecraft.level.getRandom());
                return new CachedOffer(offer);
            });
            if (cached.offer == null) continue;
            offer = cached.offer;
            offerRows.add(new RenderedOfferRow(offer.getBaseCostA(), offer.getCostB(), offer.getResult()));
        }
        this.cachedOfferRows = offerRows;
        return offerRows;
    }

    private boolean isRandomizedTrade(VillagerTrades.ItemListing listing) {
        return listing instanceof VillagerTrades.EnchantBookForEmeralds || listing instanceof VillagerTrades.TippedArrowForItemsAndEmeralds || listing instanceof VillagerTrades.TreasureMapForEmeralds || listing instanceof VillagerTrades.EnchantedItemForEmeralds;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double y) {
        this.scrollOffset = Mth.clamp((int)(this.scrollOffset + (y < 0.0 ? 1 : -1)), (int)0, (int)this.maxScroll);
        this.refreshTradeButtons(true);
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int i = this.tradesByLevel.get(this.currentTradeLevel).length;
        if (i > 7) {
            int top = this.topPos + 18;
            float scrollFactor = ((float)mouseY - (float)top - 13.5f) / 112.0f;
            this.scrollOffset = Mth.clamp((int)((int)(scrollFactor * (float)(i - 7) + 0.5f)), (int)0, (int)this.maxScroll);
            this.refreshTradeButtons(true);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BEACON_LOCATION, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        this.renderScroller(guiGraphics, i, j);
    }

    private void renderScroller(GuiGraphics guiGraphics, int posX, int posY) {
        int visible;
        int total = this.cachedOfferRows.size();
        int maxScroll = Math.max(0, total - (visible = 7));
        if (maxScroll > 0) {
            int scrollTrackHeight = 139;
            int barHeight = 27;
            this.scrollOffset = Mth.clamp((int)this.scrollOffset, (int)0, (int)maxScroll);
            int scrollY = this.scrollOffset * (scrollTrackHeight - barHeight) / maxScroll;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, posX + 97, posY + 29 + scrollY, 6, barHeight);
        } else {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_DISABLED_SPRITE, posX + 97, posY + 29, 6, 27);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        MutableComponent component = Component.literal((String)TradesScreen.capitalizeWords(((TradesMenu)this.getMenu()).getProfession().location().getPath()));
        this.drawCenteredString(guiGraphics, this.font, (Component)component, this.leftPos + 55, this.topPos + 8, -12566464);
        this.drawCenteredString(guiGraphics, this.font, LEVEL_NAMES[this.currentTradeLevel], this.leftPos + 55, this.topPos + 18, -12566464);
        this.drawCenteredString(guiGraphics, this.font, this.currentTradeLevel + "/5", this.leftPos + 55, this.topPos + 178, -12566464);
        ++this.globalTickCounter;
        if (this.globalTickCounter % 60 == 0) {
            VillagerTrades.ItemListing[] listings;
            for (VillagerTrades.ItemListing listing : listings = this.tradesByLevel.get(this.currentTradeLevel)) {
                this.refreshTradeButtons(this.isRandomizedTrade(listing));
            }
        }
        for (TradesButton.RenderedItem item : TradesButton.renderedItems) {
            if (!item.isHovered(mouseX, mouseY)) continue;
            guiGraphics.setTooltipForNextFrame(this.font, this.getTooltipFromContainerItem(item.stack), item.stack.getTooltipImage(), item.stack, mouseX, mouseY);
            break;
        }
    }

    public void drawCenteredString(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color) {
        guiGraphics.drawString(font, text, x - font.width((FormattedText)text) / 2, y, color, false);
    }

    public void drawCenteredString(GuiGraphics guiGraphics, Font font, String text, int x, int y, int color) {
        guiGraphics.drawString(font, text, x - font.width(text) / 2, y, color, false);
    }

    private static String capitalizeWords(String text) {
        String[] words = text.replace('_', ' ').split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    public boolean isPauseScreen() {
        return false;
    }

    record RenderedOfferRow(ItemStack inputA, ItemStack inputB, ItemStack result) {
    }

    private static class CachedOffer {
        MerchantOffer offer;
        public static int tickCounter;

        CachedOffer(MerchantOffer offer) {
            this.offer = offer;
            tickCounter = 0;
        }
    }
}

