/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers;

import com.mojang.text2speech.Narrator;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="movillagers")
public class WorkStationConfigs {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    static final ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.ConfigValue<String> FLORIST_WORKSTATION;
    public static ForgeConfigSpec.ConfigValue<String> MINER_WORKSTATION;
    public static ForgeConfigSpec.ConfigValue<String> LUMBER_JACK_WORKSTATION;
    public static ForgeConfigSpec.ConfigValue<String> ENGINEER_WORKSTATION;
    public static ForgeConfigSpec.ConfigValue<String> EMBERIST_WORKSTATION;
    public static ForgeConfigSpec.ConfigValue<String> ARCHEOLOGIST_WORKSTATION;
    public static ForgeConfigSpec.ConfigValue<String> TIDE_MASTER_WORKSTATION;

    public static Block getBlockFromString(String configString) {
        ResourceLocation id = ResourceLocation.parse((String)configString);
        Block block = (Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(id).get()).value();
        if (block == Blocks.AIR && !configString.equals("minecraft:air")) {
            Narrator.LOGGER.warn("Invalid block ID in config: {}", (Object)configString);
        }
        return block;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }

    static {
        BUILDER.push("WARNING - Changing These values can result in errors with villagers pathfinding / keeping professions when workstations are not near - Its recommended to change them before you start your world");
        FLORIST_WORKSTATION = BUILDER.comment("Work Station for Florist Villager").define("FloristWorkStation", (Object)"minecraft:flower_pot");
        MINER_WORKSTATION = BUILDER.comment("Work Station for Miner Villager").define("MinerWorkStation", (Object)"minecraft:furnace");
        LUMBER_JACK_WORKSTATION = BUILDER.comment("Work Station for Lumber Jack Villager").define("LumberJackWorkStation", (Object)"minecraft:crafting_table");
        ENGINEER_WORKSTATION = BUILDER.comment("Work Station for Engineer Villager").define("EngineerWorkStation", (Object)"minecraft:target");
        EMBERIST_WORKSTATION = BUILDER.comment("Work Station for Emberist Villager").define("EmberistWorkStation", (Object)"minecraft:respawn_anchor");
        ARCHEOLOGIST_WORKSTATION = BUILDER.comment("Work Station for Archeologist Villager").define("ArcheologistWorkStation", (Object)"minecraft:suspicious_sand");
        TIDE_MASTER_WORKSTATION = BUILDER.comment("Work Station for Tide Master Villager").define("TideMasterWorkStation", (Object)"minecraft:conduit");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

