/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers;

import com.belgie.movillagers.Config;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

public class AddStructures {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder emptyProcessorList = (Holder)processorListRegistry.get(EMPTY_PROCESSOR_LIST_KEY).orElseThrow();
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.getValue(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.legacy((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    public static void registerJigsaws(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().registryAccess().lookup(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().lookup(Registries.PROCESSOR_LIST).orElseThrow();
        ResourceLocation plainsPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/plains/houses");
        ResourceLocation desertPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/desert/houses");
        ResourceLocation savannaPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/savanna/houses");
        ResourceLocation snowyPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/snowy/houses");
        ResourceLocation taigaPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/taiga/houses");
        if (((Boolean)Config.CAN_FLORIST_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "movillagers:village/plains/plains_florist", (Integer)Config.FLORIST_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_MINER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "movillagers:village/plains/plains_miner", (Integer)Config.MINER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_ENGINEER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "movillagers:village/plains/plains_engineer", (Integer)Config.ENGINEER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_LUMBER_JACK_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, plainsPoolLocation, "movillagers:village/plains/plains_lumberjack", (Integer)Config.LUMBER_JACK_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_FLORIST_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, desertPoolLocation, "movillagers:village/desert/desert_florist", (Integer)Config.FLORIST_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_MINER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, desertPoolLocation, "movillagers:village/desert/desert_miner", (Integer)Config.MINER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_ENGINEER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, desertPoolLocation, "movillagers:village/desert/desert_engineer", (Integer)Config.ENGINEER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_LUMBER_JACK_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, desertPoolLocation, "movillagers:village/desert/desert_lumberjack", (Integer)Config.LUMBER_JACK_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_FLORIST_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "movillagers:village/savanna/savanna_florist", (Integer)Config.FLORIST_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_MINER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "movillagers:village/savanna/savanna_miner", (Integer)Config.MINER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_ENGINEER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "movillagers:village/savanna/savanna_engineer", (Integer)Config.ENGINEER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_LUMBER_JACK_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, savannaPoolLocation, "movillagers:village/savanna/savanna_lumberjack", (Integer)Config.LUMBER_JACK_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_FLORIST_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "movillagers:village/snowy/snowy_florist", (Integer)Config.FLORIST_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_MINER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "movillagers:village/snowy/snowy_miner", (Integer)Config.MINER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_ENGINEER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "movillagers:village/snowy/snowy_engineer", (Integer)Config.ENGINEER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_LUMBER_JACK_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, snowyPoolLocation, "movillagers:village/snowy/snowy_lumberjack", (Integer)Config.LUMBER_JACK_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_FLORIST_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "movillagers:village/taiga/taiga_florist", (Integer)Config.FLORIST_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_MINER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "movillagers:village/taiga/taiga_miner", (Integer)Config.MINER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_ENGINEER_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "movillagers:village/taiga/taiga_engineer", (Integer)Config.ENGINEER_HOUSE_SPAWN_WEIGHT.get());
        }
        if (((Boolean)Config.CAN_LUMBER_JACK_HOUSE_SPAWN.get()).booleanValue()) {
            AddStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, taigaPoolLocation, "movillagers:village/taiga/taiga_lumberjack", (Integer)Config.LUMBER_JACK_HOUSE_SPAWN_WEIGHT.get());
        }
    }
}

