/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers;

import com.belgie.movillagers.AddStructures;
import com.belgie.movillagers.Config;
import com.belgie.movillagers.ProfessionRegistry;
import com.belgie.movillagers.Screen.TradesBookItem;
import com.belgie.movillagers.Screen.TradesMenu;
import com.belgie.movillagers.Screen.TradesScreen;
import com.belgie.movillagers.TradeReg;
import com.belgie.movillagers.WorkStationConfigs;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="movillagers")
public class MoVillagers {
    public static final String MOD_ID = "movillagers";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<MenuType<?>> MENU = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"movillagers");
    public static final DeferredRegister<Item> ITEM = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"movillagers");
    public static final DeferredRegister<DataComponentType<?>> DATA = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"movillagers");
    public static final Supplier<DataComponentType<ResourceKey<VillagerProfession>>> VILLAGER_PROFESSION = MoVillagers.register("villager_profession", p_370373_ -> p_370373_.persistent(ResourceKey.codec((ResourceKey)Registries.VILLAGER_PROFESSION)).networkSynchronized(ResourceKey.streamCodec((ResourceKey)Registries.VILLAGER_PROFESSION)).cacheEncoding());
    public static final Supplier<MenuType<TradesMenu>> INFORMATION_MENU = MoVillagers.registerMenuType(TradesMenu::new, "trades");
    public static final Supplier<Item> TRADES_BOOK = ITEM.register("trades_book", () -> new TradesBookItem(new Item.Properties().stacksTo(1).component(VILLAGER_PROFESSION.get(), (Object)VillagerProfession.FARMER).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"trades_book")))));

    private static <T> Supplier<DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builder) {
        return DATA.register(name, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
    }

    private static <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerMenuType(IContainerFactory<T> factory, String name) {
        return MENU.register(name, () -> new MenuType((MenuType.MenuSupplier)factory, FeatureFlagSet.of()));
    }

    public MoVillagers(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ITEM.register(modEventBus);
        DATA.register(modEventBus);
        ProfessionRegistry.PROFESSIONS.register(modEventBus);
        ProfessionRegistry.POI.register(modEventBus);
        MENU.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(MoVillagers::creativeTabs);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)WorkStationConfigs.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TradeReg.setupTrades();
        NeoForge.EVENT_BUS.addListener(AddStructures::registerJigsaws);
    }

    private static void creativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.insertAfter(new ItemStack((ItemLike)Items.BOOK), new ItemStack((ItemLike)TRADES_BOOK.get()), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="movillagers", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        public ClientModEvents(ModContainer container) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }

        @SubscribeEvent
        public static void onClientSetup(RegisterMenuScreensEvent event) {
            event.register(INFORMATION_MENU.get(), TradesScreen::new);
        }
    }
}

