/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers.Screen;

import com.belgie.movillagers.MoVillagers;
import com.belgie.movillagers.Screen.TradesMenu;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class TradesBookItem
extends Item {
    public TradesBookItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        player.openMenu(TradesBookItem.getMenuProvider());
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        return super.use(level, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (interactionTarget instanceof Villager) {
            Villager villager = (Villager)interactionTarget;
            if (player.isCrouching()) {
                player.getMainHandItem().set(MoVillagers.VILLAGER_PROFESSION.get(), (Object)villager.getVillagerData().profession().getKey());
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.empty());
        tooltipAdder.accept((Component)Component.literal((String)"Profession:").withStyle(ChatFormatting.GRAY));
        tooltipAdder.accept((Component)Component.literal((String)TradesBookItem.capitalizeWords(((ResourceKey)stack.get(MoVillagers.VILLAGER_PROFESSION)).location().getPath())).withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
    }

    private static String capitalizeWords(String text) {
        String[] words = text.replace('_', ' ').split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    protected static MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((p_54783_, p_54784_, p_54785_) -> new TradesMenu(p_54783_, p_54784_), (Component)Component.literal((String)""));
    }
}

