/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers;

import com.belgie.movillagers.Config;
import com.belgie.movillagers.ModTags;
import com.belgie.movillagers.ProfessionRegistry;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class TradeReg {
    private static final int XP_LEVEL_1_SELL = 1;
    private static final int XP_LEVEL_1_BUY = 2;
    private static final int XP_LEVEL_2_SELL = 5;
    private static final int XP_LEVEL_2_BUY = 10;
    private static final int XP_LEVEL_3_SELL = 10;
    private static final int XP_LEVEL_3_BUY = 20;
    private static final int XP_LEVEL_4_SELL = 15;
    private static final int XP_LEVEL_4_BUY = 30;
    private static final int XP_LEVEL_5_TRADE = 30;

    static void setupTrades() {
        VillagerTrades.ItemListing[] redstonelevel1 = new VillagerTrades.ItemListing[]{new EmeraldForItemsTrade((ItemLike)Items.REDSTONE, (int)((Integer)Config.ENGINEER_REDSTONE_COUNT.get()), (int)((Integer)Config.ENGINEER_REDSTONE_PRICE.get()), 2), new ItemsForEmeraldsTrade(Items.REDSTONE, (Integer)Config.ENGINEER_REDSTONE_PRICE.get(), (Integer)Config.ENGINEER_REDSTONE_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.REDSTONE_TORCH, (Integer)Config.ENGINEER_REDSTONE_TORCH_PRICE.get(), (Integer)Config.ENGINEER_REDSTONE_TORCH_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.TRIPWIRE_HOOK, (Integer)Config.ENGINEER_TRIPWIRE_HOOK_PRICE.get(), (Integer)Config.ENGINEER_TRIPWIRE_HOOK_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.LEVER, (Integer)Config.ENGINEER_LEVER_PRICE.get(), (Integer)Config.ENGINEER_LEVER_COUNT.get(), 2), new ItemsForEmeraldsTrade(Items.HEAVY_WEIGHTED_PRESSURE_PLATE, (Integer)Config.ENGINEER_HEAVY_PRESSURE_PLATE_PRICE.get(), (Integer)Config.ENGINEER_HEAVY_PRESSURE_PLATE_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.LIGHT_WEIGHTED_PRESSURE_PLATE, (Integer)Config.ENGINEER_LIGHT_PRESSURE_PLATE_PRICE.get(), (Integer)Config.ENGINEER_LIGHT_PRESSURE_PLATE_COUNT.get(), 1)};
        VillagerTrades.ItemListing[] redstonelevel2 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.NOTE_BLOCK, (Integer)Config.ENGINEER_NOTE_BLOCK_PRICE.get(), (Integer)Config.ENGINEER_NOTE_BLOCK_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.TARGET, (Integer)Config.ENGINEER_TARGET_PRICE.get(), (Integer)Config.ENGINEER_TARGET_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.LECTERN, (Integer)Config.ENGINEER_LECTERN_PRICE.get(), (Integer)Config.ENGINEER_LECTERN_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.LIGHTNING_ROD, (Integer)Config.ENGINEER_LIGHTNING_ROD_PRICE.get(), (Integer)Config.ENGINEER_LIGHTNING_ROD_COUNT.get(), 5)};
        VillagerTrades.ItemListing[] redstonelevel3 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.DROPPER, (Integer)Config.ENGINEER_DROPPER_PRICE.get(), (Integer)Config.ENGINEER_DROPPER_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.SLIME_BLOCK, (Integer)Config.ENGINEER_SLIME_BLOCK_PRICE.get(), (Integer)Config.ENGINEER_SLIME_BLOCK_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.HONEY_BLOCK, (Integer)Config.ENGINEER_HONEY_BLOCK_PRICE.get(), (Integer)Config.ENGINEER_HONEY_BLOCK_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.DAYLIGHT_DETECTOR, (Integer)Config.ENGINEER_DAYLIGHT_DETECTOR_PRICE.get(), (Integer)Config.ENGINEER_DAYLIGHT_DETECTOR_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.REDSTONE_LAMP, (Integer)Config.ENGINEER_REDSTONE_LAMP_PRICE.get(), (Integer)Config.ENGINEER_REDSTONE_LAMP_COUNT.get(), 8), new ItemsForEmeraldsTrade(Items.TRAPPED_CHEST, (Integer)Config.ENGINEER_TRAPPED_CHEST_PRICE.get(), (Integer)Config.ENGINEER_TRAPPED_CHEST_COUNT.get(), 10)};
        VillagerTrades.ItemListing[] redstonelevel4 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.REPEATER, (Integer)Config.ENGINEER_REPEATER_PRICE.get(), (Integer)Config.ENGINEER_REPEATER_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.COMPARATOR, (Integer)Config.ENGINEER_COMPARATOR_PRICE.get(), (Integer)Config.ENGINEER_COMPARATOR_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.HOPPER, (Integer)Config.ENGINEER_HOPPER_PRICE.get(), (Integer)Config.ENGINEER_HOPPER_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.PISTON, (Integer)Config.ENGINEER_PISTON_PRICE.get(), (Integer)Config.ENGINEER_PISTON_COUNT.get(), 15)};
        VillagerTrades.ItemListing[] redstonelevel5 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.SCULK_SENSOR, (Integer)Config.ENGINEER_SCULK_SENSOR_PRICE.get(), (Integer)Config.ENGINEER_SCULK_SENSOR_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.CALIBRATED_SCULK_SENSOR, (Integer)Config.ENGINEER_CALIBRATED_SCULK_SENSOR_PRICE.get(), (Integer)Config.ENGINEER_CALIBRATED_SCULK_SENSOR_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.CRAFTER, (Integer)Config.ENGINEER_CRAFTER_PRICE.get(), (Integer)Config.ENGINEER_CRAFTER_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.WAXED_COPPER_BULB, (Integer)Config.ENGINEER_COPPER_BULB_PRICE.get(), (Integer)Config.ENGINEER_COPPER_BULB_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.DISPENSER, (Integer)Config.ENGINEER_DISPENSER_PRICE.get(), (Integer)Config.ENGINEER_DISPENSER_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.OBSERVER, (Integer)Config.ENGINEER_OBSERVER_PRICE.get(), (Integer)Config.ENGINEER_OBSERVER_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.STICKY_PISTON, (Integer)Config.ENGINEER_STICKY_PISTON_PRICE.get(), (Integer)Config.ENGINEER_STICKY_PISTON_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.TNT, (Integer)Config.ENGINEER_TNT_PRICE.get(), (Integer)Config.ENGINEER_TNT_COUNT.get(), 30)};
        VillagerTrades.TRADES.put(ProfessionRegistry.ENGINEER_KEY, TradeReg.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)redstonelevel1, (Object)2, (Object)redstonelevel2, (Object)3, (Object)redstonelevel3, (Object)4, (Object)redstonelevel4, (Object)5, (Object)redstonelevel5)));
        VillagerTrades.ItemListing[] netherlevel1 = new VillagerTrades.ItemListing[]{new EmeraldForItemsTrade((ItemLike)Items.NETHERRACK, (int)((Integer)Config.EMBERIST_NETHERRACK_COUNT.get()), (int)((Integer)Config.EMBERIST_NETHERRACK_PRICE.get()), 2), new ItemsForEmeraldsTrade(Items.CRIMSON_FUNGUS, (Integer)Config.EMBERIST_CRIMSON_FUNGUS_PRICE.get(), (Integer)Config.EMBERIST_CRIMSON_FUNGUS_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.WARPED_FUNGUS, (Integer)Config.EMBERIST_WARPED_FUNGUS_PRICE.get(), (Integer)Config.EMBERIST_WARPED_FUNGUS_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.WEEPING_VINES, (Integer)Config.EMBERIST_WEEPING_VINES_PRICE.get(), (Integer)Config.EMBERIST_WEEPING_VINES_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.TWISTING_VINES, (Integer)Config.EMBERIST_TWISTING_VINES_PRICE.get(), (Integer)Config.EMBERIST_TWISTING_VINES_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.NETHER_SPROUTS, (Integer)Config.EMBERIST_NETHER_SPROUTS_PRICE.get(), (Integer)Config.EMBERIST_NETHER_SPROUTS_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.WARPED_ROOTS, (Integer)Config.EMBERIST_WARPED_ROOTS_PRICE.get(), (Integer)Config.EMBERIST_WARPED_ROOTS_COUNT.get(), 1), new ItemsForEmeraldsTrade(Items.CRIMSON_ROOTS, (Integer)Config.EMBERIST_CRIMSON_ROOTS_PRICE.get(), (Integer)Config.EMBERIST_CRIMSON_ROOTS_COUNT.get(), 1)};
        VillagerTrades.ItemListing[] netherlevel2 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.NETHERRACK, (Integer)Config.EMBERIST_NETHERRACK_PRICE.get(), (Integer)Config.EMBERIST_NETHERRACK_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.SOUL_SAND, (Integer)Config.EMBERIST_SOUL_SAND_PRICE.get(), (Integer)Config.EMBERIST_SOUL_SAND_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.SOUL_SOIL, (Integer)Config.EMBERIST_SOUL_SOIL_PRICE.get(), (Integer)Config.EMBERIST_SOUL_SOIL_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.WARPED_STEM, (Integer)Config.EMBERIST_WARPED_STEM_PRICE.get(), (Integer)Config.EMBERIST_WARPED_STEM_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.CRIMSON_STEM, (Integer)Config.EMBERIST_CRIMSON_STEM_PRICE.get(), (Integer)Config.EMBERIST_CRIMSON_STEM_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.NETHER_WART, (Integer)Config.EMBERIST_NETHER_WART_PRICE.get(), (Integer)Config.EMBERIST_NETHER_WART_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.BASALT, (Integer)Config.EMBERIST_BASALT_PRICE.get(), (Integer)Config.EMBERIST_BASALT_COUNT.get(), 5)};
        VillagerTrades.ItemListing[] netherlevel3 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.BLACKSTONE, (Integer)Config.EMBERIST_BLACKSTONE_PRICE.get(), (Integer)Config.EMBERIST_BLACKSTONE_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.WARPED_WART_BLOCK, (Integer)Config.EMBERIST_WARPED_WART_BLOCK_PRICE.get(), (Integer)Config.EMBERIST_WARPED_WART_BLOCK_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.NETHER_WART_BLOCK, (Integer)Config.EMBERIST_NETHER_WART_PRICE.get(), (Integer)Config.EMBERIST_NETHER_WART_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.CRIMSON_NYLIUM, (Integer)Config.EMBERIST_CRIMSON_NYLIUM_PRICE.get(), (Integer)Config.EMBERIST_CRIMSON_NYLIUM_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.WARPED_NYLIUM, (Integer)Config.EMBERIST_WARPED_NYLIUM_PRICE.get(), (Integer)Config.EMBERIST_WARPED_NYLIUM_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.GILDED_BLACKSTONE, (Integer)Config.EMBERIST_GILDED_BLACKSTONE_PRICE.get(), (Integer)Config.EMBERIST_GILDED_BLACKSTONE_COUNT.get(), 10)};
        VillagerTrades.ItemListing[] netherlevel4 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.MAGMA_BLOCK, (Integer)Config.EMBERIST_MAGMA_BLOCK_PRICE.get(), (Integer)Config.EMBERIST_MAGMA_BLOCK_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.CRYING_OBSIDIAN, (Integer)Config.EMBERIST_CRYING_OBSIDIAN_PRICE.get(), (Integer)Config.EMBERIST_CRYING_OBSIDIAN_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.NETHER_BRICKS, (Integer)Config.EMBERIST_NETHER_BRICKS_PRICE.get(), (Integer)Config.EMBERIST_NETHER_BRICKS_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.RED_NETHER_BRICKS, (Integer)Config.EMBERIST_RED_NETHER_BRICKS_PRICE.get(), (Integer)Config.EMBERIST_RED_NETHER_BRICKS_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.QUARTZ, (Integer)Config.EMBERIST_QUARTZ_PRICE.get(), (Integer)Config.EMBERIST_QUARTZ_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.BLAZE_ROD, (Integer)Config.EMBERIST_BLAZE_ROD_PRICE.get(), (Integer)Config.EMBERIST_BLAZE_ROD_COUNT.get(), 15)};
        VillagerTrades.ItemListing[] netherlevel5 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.RESPAWN_ANCHOR, (Integer)Config.EMBERIST_RESPAWN_ANCHOR_PRICE.get(), (Integer)Config.EMBERIST_RESPAWN_ANCHOR_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.PIGLIN_HEAD, (Integer)Config.EMBERIST_PIGLIN_HEAD_PRICE.get(), (Integer)Config.EMBERIST_PIGLIN_HEAD_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.MUSIC_DISC_PIGSTEP, (Integer)Config.EMBERIST_PIGSTEP_PRICE.get(), (Integer)Config.EMBERIST_PIGSTEP_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.LODESTONE, (Integer)Config.EMBERIST_LODESTONE_PRICE.get(), (Integer)Config.EMBERIST_LODESTONE_COUNT.get(), 30)};
        VillagerTrades.TRADES.put(ProfessionRegistry.UNDERWORLD_EXPLORER_KEY, TradeReg.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)netherlevel1, (Object)2, (Object)netherlevel2, (Object)3, (Object)netherlevel3, (Object)4, (Object)netherlevel4, (Object)5, (Object)netherlevel5)));
        VillagerTrades.ItemListing[] lumberlevel1 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.LOGS_THAT_BURN, (Integer)Config.LUMBER_JACK_LOG_COUNT.get(), (Integer)Config.LUMBER_JACK_LOG_PRICE.get(), 12, 1, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.LOGS_THAT_BURN, (Integer)Config.LUMBER_JACK_LOG_COUNT.get(), (Integer)Config.LUMBER_JACK_LOG_PRICE.get(), 12, 1, 0.05f, false)};
        VillagerTrades.ItemListing[] lumberlevel2 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.WOODEN_SLABS, (Integer)Config.LUMBER_JACK_SLAB_COUNT.get(), (Integer)Config.LUMBER_JACK_SLAB_PRICE.get(), 12, 5, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.WOODEN_STAIRS, (Integer)Config.LUMBER_JACK_STAIRS_COUNT.get(), (Integer)Config.LUMBER_JACK_STAIRS_PRICE.get(), 12, 5, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.HANGING_SIGNS, (Integer)Config.LUMBER_JACK_HANGING_SIGNS_COUNT.get(), (Integer)Config.LUMBER_JACK_HANGING_SIGNS_PRICE.get(), 12, 5, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.SIGNS, (Integer)Config.LUMBER_JACK_SIGNS_COUNT.get(), (Integer)Config.LUMBER_JACK_SIGNS_PRICE.get(), 12, 5, 0.05f, false)};
        VillagerTrades.ItemListing[] lumberlevel3 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.FENCE_GATES, (Integer)Config.LUMBER_JACK_FENCE_GATES_COUNT.get(), (Integer)Config.LUMBER_JACK_FENCE_GATES_PRICE.get(), 12, 10, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.WOODEN_FENCES, (Integer)Config.LUMBER_JACK_FENCES_COUNT.get(), (Integer)Config.LUMBER_JACK_FENCES_PRICE.get(), 12, 10, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.BOATS, (Integer)Config.LUMBER_JACK_BOATS_COUNT.get(), (Integer)Config.LUMBER_JACK_BOATS_PRICE.get(), 12, 10, 0.05f, false)};
        VillagerTrades.ItemListing[] lumberlevel4 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.WOODEN_BUTTONS, (Integer)Config.LUMBER_JACK_BUTTONS_COUNT.get(), (Integer)Config.LUMBER_JACK_BUTTONS_PRICE.get(), 12, 15, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.WOODEN_PRESSURE_PLATES, (Integer)Config.LUMBER_JACK_PRESSURE_PLATES_COUNT.get(), (Integer)Config.LUMBER_JACK_PRESSURE_PLATES_PRICE.get(), 4, 15, 0.05f, false)};
        VillagerTrades.ItemListing[] lumberlevel5 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.WOODEN_DOORS, (Integer)Config.LUMBER_JACK_DOORS_COUNT.get(), (Integer)Config.LUMBER_JACK_DOORS_PRICE.get(), 12, 30, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.WOODEN_TRAPDOORS, (Integer)Config.LUMBER_JACK_TRAPDOORS_COUNT.get(), (Integer)Config.LUMBER_JACK_TRAPDOORS_PRICE.get(), 12, 30, 0.05f, false)};
        VillagerTrades.TRADES.put(ProfessionRegistry.LUMBER_JACK_KEY, TradeReg.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)lumberlevel1, (Object)2, (Object)lumberlevel2, (Object)3, (Object)lumberlevel3, (Object)4, (Object)lumberlevel4, (Object)5, (Object)lumberlevel5)));
        VillagerTrades.ItemListing[] minerlevel1 = new VillagerTrades.ItemListing[]{new ItemTagForItem(ModTags.Items.BASE_STONE_OVERWORLD, (Integer)Config.MINER_STONE_COUNT.get(), (Integer)Config.MINER_STONE_PRICE.get(), 12, 1, 0.05f, false), new ItemTagForItem(ModTags.Items.BASE_STONE_OVERWORLD, (Integer)Config.MINER_STONE_COUNT.get(), (Integer)Config.MINER_STONE_PRICE.get(), 12, 1, 0.05f, false)};
        VillagerTrades.ItemListing[] minerlevel2 = new VillagerTrades.ItemListing[]{new ItemTagForItem(ModTags.Items.ORES, (Integer)Config.MINER_ORES_COUNT.get(), (Integer)Config.MINER_ORES_PRICE.get(), 12, 5, 0.05f, false), new ItemTagForItem(ModTags.Items.ORES, (Integer)Config.MINER_ORES_COUNT.get(), (Integer)Config.MINER_ORES_PRICE.get(), 12, 5, 0.05f, false)};
        VillagerTrades.ItemListing[] minerlevel3 = new VillagerTrades.ItemListing[]{new ItemTagForItem(ModTags.Items.ORES, (Integer)Config.MINER_ORES_COUNT.get(), (Integer)Config.MINER_ORES_PRICE.get(), 12, 10, 0.05f, false), new ItemTagForItem(ModTags.Items.ORES, (Integer)Config.MINER_ORES_COUNT.get(), (Integer)Config.MINER_ORES_PRICE.get(), 12, 10, 0.05f, false)};
        VillagerTrades.ItemListing[] minerlevel4 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.MOSS_BLOCK, (Integer)Config.MINER_MOSS_BLOCK_PRICE.get(), (Integer)Config.MINER_MOSS_BLOCK_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.MOSS_CARPET, (Integer)Config.MINER_MOSS_CARPET_PRICE.get(), (Integer)Config.MINER_MOSS_CARPET_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.AMETHYST_BLOCK, (Integer)Config.MINER_AMETHYST_BLOCK_PRICE.get(), (Integer)Config.MINER_AMETHYST_BLOCK_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.COBWEB, (Integer)Config.MINER_COBWEB_PRICE.get(), (Integer)Config.MINER_COBWEB_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.GLOW_BERRIES, (Integer)Config.MINER_GLOW_BERRIES_PRICE.get(), (Integer)Config.MINER_GLOW_BERRIES_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.POINTED_DRIPSTONE, (Integer)Config.MINER_POINTED_DRIPSTONE_PRICE.get(), (Integer)Config.MINER_POINTED_DRIPSTONE_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.DRIPSTONE_BLOCK, (Integer)Config.MINER_DRIPSTONE_BLOCK_PRICE.get(), (Integer)Config.MINER_DRIPSTONE_BLOCK_COUNT.get(), 15)};
        VillagerTrades.ItemListing[] minerlevel5 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.SCULK, (Integer)Config.MINER_SCULK_PRICE.get(), (Integer)Config.MINER_SCULK_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.SCULK_SENSOR, (Integer)Config.MINER_SCULK_SENSOR_PRICE.get(), (Integer)Config.MINER_SCULK_SENSOR_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.SCULK_CATALYST, (Integer)Config.MINER_SCULK_CATALYST_PRICE.get(), (Integer)Config.MINER_SCULK_CATALYST_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.SCULK_SHRIEKER, (Integer)Config.MINER_SCULK_SHRIEKER_PRICE.get(), (Integer)Config.MINER_SCULK_SHRIEKER_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.SCULK_VEIN, (Integer)Config.MINER_SCULK_VEIN_PRICE.get(), (Integer)Config.MINER_SCULK_VEIN_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BUDDING_AMETHYST, (Integer)Config.MINER_BUDDING_AMETHYST_PRICE.get(), (Integer)Config.MINER_BUDDING_AMETHYST_COUNT.get(), 30)};
        VillagerTrades.TRADES.put(ProfessionRegistry.MINER_KEY, TradeReg.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)minerlevel1, (Object)2, (Object)minerlevel2, (Object)3, (Object)minerlevel3, (Object)4, (Object)minerlevel4, (Object)5, (Object)minerlevel5)));
        VillagerTrades.ItemListing[] floristlevel1 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.LEAVES, (Integer)Config.FLORIST_LEAVES_COUNT.get(), (Integer)Config.FLORIST_LEAVES_PRICE.get(), 12, 1, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.LEAVES, (Integer)Config.FLORIST_LEAVES_COUNT.get(), (Integer)Config.FLORIST_LEAVES_PRICE.get(), 12, 1, 0.05f, false)};
        VillagerTrades.ItemListing[] floristlevel2 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.SAPLINGS, (Integer)Config.FLORIST_SAPLINGS_COUNT.get(), (Integer)Config.FLORIST_SAPLINGS_PRICE.get(), 12, 5, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.SAPLINGS, (Integer)Config.FLORIST_SAPLINGS_COUNT.get(), (Integer)Config.FLORIST_SAPLINGS_PRICE.get(), 12, 5, 0.05f, false)};
        VillagerTrades.ItemListing[] floristlevel3 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.FLOWERS, (Integer)Config.FLORIST_FLOWERS_COUNT.get(), (Integer)Config.FLORIST_FLOWERS_PRICE.get(), 12, 10, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.FLOWERS, (Integer)Config.FLORIST_FLOWERS_COUNT.get(), (Integer)Config.FLORIST_FLOWERS_PRICE.get(), 12, 10, 0.05f, false)};
        VillagerTrades.ItemListing[] floristlevel4 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.VINE, (Integer)Config.FLORIST_VINE_PRICE.get(), (Integer)Config.FLORIST_VINE_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.SMALL_DRIPLEAF, (Integer)Config.FLORIST_SMALL_DRIPLEAF_PRICE.get(), (Integer)Config.FLORIST_SMALL_DRIPLEAF_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.HANGING_ROOTS, (Integer)Config.FLORIST_HANGING_ROOTS_PRICE.get(), (Integer)Config.FLORIST_HANGING_ROOTS_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.LARGE_FERN, (Integer)Config.FLORIST_LARGE_FERN_PRICE.get(), (Integer)Config.FLORIST_LARGE_FERN_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.TALL_GRASS, (Integer)Config.FLORIST_TALL_GRASS_PRICE.get(), (Integer)Config.FLORIST_TALL_GRASS_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.FIREFLY_BUSH, (Integer)Config.FLORIST_FIREFLY_BUSH_PRICE.get(), (Integer)Config.FLORIST_FIREFLY_BUSH_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.BUSH, (Integer)Config.FLORIST_BUSH_PRICE.get(), (Integer)Config.FLORIST_BUSH_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.SHORT_GRASS, (Integer)Config.FLORIST_SHORT_GRASS_PRICE.get(), (Integer)Config.FLORIST_SHORT_GRASS_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.FERN, (Integer)Config.FLORIST_FERN_PRICE.get(), (Integer)Config.FLORIST_FERN_COUNT.get(), 15)};
        VillagerTrades.ItemListing[] floristlevel5 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.SWEET_BERRIES, (Integer)Config.FLORIST_SWEET_BERRIES_PRICE.get(), (Integer)Config.FLORIST_SWEET_BERRIES_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.PUMPKIN_SEEDS, (Integer)Config.FLORIST_PUMPKIN_SEEDS_PRICE.get(), (Integer)Config.FLORIST_PUMPKIN_SEEDS_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.MELON_SEEDS, (Integer)Config.FLORIST_MELON_SEEDS_PRICE.get(), (Integer)Config.FLORIST_MELON_SEEDS_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.CACTUS, (Integer)Config.FLORIST_CACTUS_PRICE.get(), (Integer)Config.FLORIST_CACTUS_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.SUGAR_CANE, (Integer)Config.FLORIST_SUGAR_CANE_PRICE.get(), (Integer)Config.FLORIST_SUGAR_CANE_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BAMBOO, (Integer)Config.FLORIST_BAMBOO_PRICE.get(), (Integer)Config.FLORIST_BAMBOO_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BEETROOT_SEEDS, (Integer)Config.FLORIST_BEETROOT_SEEDS_PRICE.get(), (Integer)Config.FLORIST_BEETROOT_SEEDS_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.WHEAT_SEEDS, (Integer)Config.FLORIST_WHEAT_SEEDS_PRICE.get(), (Integer)Config.FLORIST_WHEAT_SEEDS_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.CARROT, (Integer)Config.FLORIST_CARROT_PRICE.get(), (Integer)Config.FLORIST_CARROT_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.POTATO, (Integer)Config.FLORIST_POTATO_PRICE.get(), (Integer)Config.FLORIST_POTATO_COUNT.get(), 30)};
        VillagerTrades.TRADES.put(ProfessionRegistry.FLORIST_KEY, TradeReg.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)floristlevel1, (Object)2, (Object)floristlevel2, (Object)3, (Object)floristlevel3, (Object)4, (Object)floristlevel4, (Object)5, (Object)floristlevel5)));
        VillagerTrades.ItemListing[] ancientlevel1 = new VillagerTrades.ItemListing[]{new EmeraldForItemsTrade((ItemLike)Items.WHEAT, (int)((Integer)Config.ARCHEOLOGIST_WHEAT_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_WHEAT_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.BRICK, (int)((Integer)Config.ARCHEOLOGIST_BRICK_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_BRICK_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.YELLOW_DYE, (int)((Integer)Config.ARCHEOLOGIST_YELLOW_DYE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_YELLOWW_DYE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.BLUE_DYE, (int)((Integer)Config.ARCHEOLOGIST_BLUE_DYE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_BLUE_DYE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.LIGHT_BLUE_DYE, (int)((Integer)Config.ARCHEOLOGIST_LIGHT_BLUE_DYE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_LIGHT_BLUE_DYE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.WHITE_DYE, (int)((Integer)Config.ARCHEOLOGIST_WHITE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_WHITE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.ORANGE_DYE, (int)((Integer)Config.ARCHEOLOGIST_ORANGE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_ORANGE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.MAGENTA_STAINED_GLASS_PANE, (int)((Integer)Config.ARCHEOLOGIST_MAGENTA_GLASS_PANE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_MAGENTA_GLASS_PANE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.PINK_STAINED_GLASS_PANE, (int)((Integer)Config.ARCHEOLOGIST_PINK_GLASS_PANE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_PINK_GLASS_PANE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.BLUE_STAINED_GLASS_PANE, (int)((Integer)Config.ARCHEOLOGIST_BLUE_GLASS_PANE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_BLUE_GLASS_PANE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.LIGHT_BLUE_STAINED_GLASS_PANE, (int)((Integer)Config.ARCHEOLOGIST_LIGHT_BLUE_GLASS_PANE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_LIGHT_BLUE_GLASS_PANE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.RED_STAINED_GLASS_PANE, (int)((Integer)Config.ARCHEOLOGIST_RED_GLASS_PANE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_RED_GLASS_PANE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.YELLOW_STAINED_GLASS_PANE, (int)((Integer)Config.ARCHEOLOGIST_YELLOW_GLASS_PANE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_YELLOW_GLASS_PANE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.PURPLE_STAINED_GLASS_PANE, (int)((Integer)Config.ARCHEOLOGIST_PURPLE_GLASS_PANE_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_PURPLE_GLASS_PANE_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.SPRUCE_HANGING_SIGN, (int)((Integer)Config.ARCHEOLOGIST_SPRUCE_HANGING_SIGN_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_SPRUCE_HANGING_SIGN_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.OAK_HANGING_SIGN, (int)((Integer)Config.ARCHEOLOGIST_OAK_HANGING_SIGN_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_OAK_HANGING_SIGN_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.COAL, (int)((Integer)Config.ARCHEOLOGIST_COAL_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_COAL_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.FLOWER_POT, (int)((Integer)Config.ARCHEOLOGIST_FLOWER_POT_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_FLOWER_POT_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.STRING, (int)((Integer)Config.ARCHEOLOGIST_STRING_COUNT.get()), (int)((Integer)Config.ARCHEOLOGIST_STRING_PRICE.get()), 1)};
        VillagerTrades.ItemListing[] ancientlevel2 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.CLAY, (Integer)Config.ARCHEOLOGIST_CLAY_PRICE.get(), (Integer)Config.ARCHEOLOGIST_CLAY_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.GUNPOWDER, (Integer)Config.ARCHEOLOGIST_GUNPOWDER_PRICE.get(), (Integer)Config.ARCHEOLOGIST_GUNPOWDER_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.TNT, (Integer)Config.ARCHEOLOGIST_TNT_PRICE.get(), (Integer)Config.ARCHEOLOGIST_TNT_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.SUSPICIOUS_STEW, (Integer)Config.ARCHEOLOGIST_SUS_STEW_PRICE.get(), (Integer)Config.ARCHEOLOGIST_SUS_STEW_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.IRON_AXE, (Integer)Config.ARCHEOLOGIST_IRON_AXE_PRICE.get(), (Integer)Config.ARCHEOLOGIST_IRON_AXE_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.COAL, (Integer)Config.ARCHEOLOGIST_COAL_PRICE.get(), (Integer)Config.ARCHEOLOGIST_COAL_COUNT.get(), 5)};
        VillagerTrades.ItemListing[] ancientlevel3 = new VillagerTrades.ItemListing[]{new TreasureMapForEmeralds((Integer)Config.ARCHEOLOGIST_OCEAN_RUIN_MAP_PRICE.get(), (TagKey<Structure>)StructureTags.OCEAN_RUIN, "filled_map.ruin", (Holder<MapDecorationType>)MapDecorationTypes.TARGET_POINT, 12, 10), new TreasureMapForEmeralds((Integer)Config.ARCHEOLOGIST_DESERT_TEMPLE_MAP_PRICE.get(), ModTags.Structures.DESERT_TEMPLE, "filled_map.temple", (Holder<MapDecorationType>)MapDecorationTypes.TARGET_POINT, 12, 10), new TreasureMapForEmeralds((Integer)Config.ARCHEOLOGIST_TRAIL_RUINS_MAP_PRICE.get(), ModTags.Structures.TRAIL_RUINS, "filled_map.trail", (Holder<MapDecorationType>)MapDecorationTypes.TARGET_POINT, 12, 10), new ItemsForEmeraldsTrade(Items.SNIFFER_EGG, (Integer)Config.ARCHEOLOGIST_SNIFFER_EGG_PRICE.get(), (Integer)Config.ARCHEOLOGIST_SNIFFER_EGG_COUNT.get(), 10)};
        VillagerTrades.ItemListing[] ancientlevel4 = new VillagerTrades.ItemListing[]{new ItemTagForItem((TagKey<Item>)ItemTags.DECORATED_POT_SHERDS, (Integer)Config.ARCHEOLOGIST_SHERDS_COUNT.get(), (Integer)Config.ARCHEOLOGIST_SHERDS_PRICE.get(), 4, 15, 0.05f, false), new ItemTagForItem((TagKey<Item>)ItemTags.DECORATED_POT_SHERDS, (Integer)Config.ARCHEOLOGIST_SHERDS_COUNT.get(), (Integer)Config.ARCHEOLOGIST_SHERDS_PRICE.get(), 4, 15, 0.05f, false)};
        VillagerTrades.ItemListing[] ancientlevel5 = new VillagerTrades.ItemListing[]{new ItemTagForItem(ModTags.Items.TRIM_TEMPLATES, (Integer)Config.ARCHEOLOGIST_ARMOR_TEMPLATE_COUNT.get(), (Integer)Config.ARCHEOLOGIST_ARMOR_TEMPLATE_PRICE.get(), 4, 30, 0.05f, true)};
        VillagerTrades.TRADES.put(ProfessionRegistry.ANCIENT_EXPLORER_KEY, TradeReg.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)ancientlevel1, (Object)2, (Object)ancientlevel2, (Object)3, (Object)ancientlevel3, (Object)4, (Object)ancientlevel4, (Object)5, (Object)ancientlevel5)));
        VillagerTrades.ItemListing[] oceanlevel1 = new VillagerTrades.ItemListing[]{new EmeraldForItemsTrade((ItemLike)Items.SEAGRASS, (int)((Integer)Config.TIDE_MASTER_SEAGRASS_COUNT.get()), (int)((Integer)Config.TIDE_MASTER_SEAGRASS_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.KELP, (int)((Integer)Config.TIDE_MASTER_KELP_COUNT.get()), (int)((Integer)Config.TIDE_MASTER_KELP_PRICE.get()), 1), new EmeraldForItemsTrade((ItemLike)Items.LILY_PAD, (int)((Integer)Config.TIDE_MASTER_LILY_PAD_COUNT.get()), (int)((Integer)Config.TIDE_MASTER_LILY_PAD_PRICE.get()), 1), new ItemsForEmeraldsTrade(Items.SEA_PICKLE, (Integer)Config.TIDE_MASTER_SEA_PICKLE_COUNT.get(), (Integer)Config.TIDE_MASTER_SEA_PICKLE_PRICE.get(), 1), new ItemsForEmeraldsTrade(Items.DRIED_KELP_BLOCK, (Integer)Config.TIDE_MASTER_DRIED_KELP_BLOCK_COUNT.get(), (Integer)Config.TIDE_MASTER_DRIED_KELP_BLOCK_PRICE.get(), 1)};
        VillagerTrades.ItemListing[] oceanlevel2 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.GLOW_INK_SAC, (Integer)Config.TIDE_MASTER_GLOW_INK_SAC_PRICE.get(), (Integer)Config.TIDE_MASTER_GLOW_INK_SAC_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.INK_SAC, (Integer)Config.TIDE_MASTER_INK_SAC_PRICE.get(), (Integer)Config.TIDE_MASTER_INK_SAC_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.PACKED_ICE, (Integer)Config.TIDE_MASTER_PACKED_ICE_PRICE.get(), (Integer)Config.TIDE_MASTER_PACKED_ICE_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.ICE, (Integer)Config.TIDE_MASTER_ICE_PRICE.get(), (Integer)Config.TIDE_MASTER_ICE_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.HEART_OF_THE_SEA, (Integer)Config.TIDE_MASTER_HEART_OF_THE_SEA_PRICE.get(), (Integer)Config.TIDE_MASTER_HEART_OF_THE_SEA_COUNT.get(), 5), new ItemsForEmeraldsTrade(Items.NAUTILUS_SHELL, (Integer)Config.TIDE_MASTER_NAUTILUS_SHELL_PRICE.get(), (Integer)Config.TIDE_MASTER_NAUTILUS_SHELL_COUNT.get(), 5)};
        VillagerTrades.ItemListing[] oceanlevel3 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.TADPOLE_BUCKET, (Integer)Config.TIDE_MASTER_TADPOLE_BUCKET_PRICE.get(), (Integer)Config.TIDE_MASTER_TADPOLE_BUCKET_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.AXOLOTL_BUCKET, (Integer)Config.TIDE_MASTER_AXOLOTL_BUCKET_PRICE.get(), (Integer)Config.TIDE_MASTER_AXOLOTL_BUCKET_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.COD_BUCKET, (Integer)Config.TIDE_MASTER_COD_BUCKET_PRICE.get(), (Integer)Config.TIDE_MASTER_COD_BUCKET_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.PUFFERFISH_BUCKET, (Integer)Config.TIDE_MASTER_PUFFERFISH_BUCKET_PRICE.get(), (Integer)Config.TIDE_MASTER_PUFFERFISH_BUCKET_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.SALMON_BUCKET, (Integer)Config.TIDE_MASTER_SALMON_BUCKET_PRICE.get(), (Integer)Config.TIDE_MASTER_SALMON_BUCKET_COUNT.get(), 10), new ItemsForEmeraldsTrade(Items.TROPICAL_FISH_BUCKET, (Integer)Config.TIDE_MASTER_TROPICAL_FISH_BUCKET_PRICE.get(), (Integer)Config.TIDE_MASTER_TROPICAL_FISH_BUCKET_COUNT.get(), 10)};
        VillagerTrades.ItemListing[] oceanlevel4 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.SPONGE, (Integer)Config.TIDE_MASTER_SPONGE_PRICE.get(), (Integer)Config.TIDE_MASTER_SPONGE_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.PRISMARINE_BRICKS, (Integer)Config.TIDE_MASTER_PRISMARINE_BRICKS_PRICE.get(), (Integer)Config.TIDE_MASTER_PRISMARINE_BRICKS_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.DARK_PRISMARINE, (Integer)Config.TIDE_MASTER_DARK_PRISMARINE_PRICE.get(), (Integer)Config.TIDE_MASTER_DARK_PRISMARINE_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.PRISMARINE, (Integer)Config.TIDE_MASTER_PRISMARINE_PRICE.get(), (Integer)Config.TIDE_MASTER_PRISMARINE_COUNT.get(), 15), new ItemsForEmeraldsTrade(Items.SEA_LANTERN, (Integer)Config.TIDE_MASTER_SEA_LANTERN_PRICE.get(), (Integer)Config.TIDE_MASTER_SEA_LANTERN_COUNT.get(), 15)};
        VillagerTrades.ItemListing[] oceanlevel5 = new VillagerTrades.ItemListing[]{new ItemsForEmeraldsTrade(Items.BRAIN_CORAL, (Integer)Config.TIDE_MASTER_BRAIN_CORAL_PRICE.get(), (Integer)Config.TIDE_MASTER_BRAIN_CORAL_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BUBBLE_CORAL, (Integer)Config.TIDE_MASTER_BUBBLE_CORAL_PRICE.get(), (Integer)Config.TIDE_MASTER_BUBBLE_CORAL_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.FIRE_CORAL, (Integer)Config.TIDE_MASTER_FIRE_CORAL_PRICE.get(), (Integer)Config.TIDE_MASTER_FIRE_CORAL_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.HORN_CORAL, (Integer)Config.TIDE_MASTER_HORN_CORAL_PRICE.get(), (Integer)Config.TIDE_MASTER_HORN_CORAL_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.TUBE_CORAL, (Integer)Config.TIDE_MASTER_TUBE_CORAL_PRICE.get(), (Integer)Config.TIDE_MASTER_TUBE_CORAL_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BRAIN_CORAL_BLOCK, (Integer)Config.TIDE_MASTER_BRAIN_CORAL_BLOCK_PRICE.get(), (Integer)Config.TIDE_MASTER_BRAIN_CORAL_BLOCK_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BUBBLE_CORAL_BLOCK, (Integer)Config.TIDE_MASTER_BUBBLE_CORAL_BLOCK_PRICE.get(), (Integer)Config.TIDE_MASTER_BUBBLE_CORAL_BLOCK_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.FIRE_CORAL_BLOCK, (Integer)Config.TIDE_MASTER_FIRE_CORAL_BLOCK_PRICE.get(), (Integer)Config.TIDE_MASTER_FIRE_CORAL_BLOCK_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.HORN_CORAL_BLOCK, (Integer)Config.TIDE_MASTER_HORN_CORAL_BLOCK_PRICE.get(), (Integer)Config.TIDE_MASTER_HORN_CORAL_BLOCK_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.TUBE_CORAL_BLOCK, (Integer)Config.TIDE_MASTER_TUBE_CORAL_BLOCK_PRICE.get(), (Integer)Config.TIDE_MASTER_TUBE_CORAL_BLOCK_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BRAIN_CORAL_FAN, (Integer)Config.TIDE_MASTER_BRAIN_CORAL_FAN_PRICE.get(), (Integer)Config.TIDE_MASTER_BRAIN_CORAL_FAN_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.BUBBLE_CORAL_FAN, (Integer)Config.TIDE_MASTER_BUBBLE_CORAL_FAN_PRICE.get(), (Integer)Config.TIDE_MASTER_BUBBLE_CORAL_FAN_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.FIRE_CORAL_FAN, (Integer)Config.TIDE_MASTER_FIRE_CORAL_FAN_PRICE.get(), (Integer)Config.TIDE_MASTER_FIRE_CORAL_FAN_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.HORN_CORAL_FAN, (Integer)Config.TIDE_MASTER_HORN_CORAL_FAN_PRICE.get(), (Integer)Config.TIDE_MASTER_HORN_CORAL_FAN_COUNT.get(), 30), new ItemsForEmeraldsTrade(Items.TUBE_CORAL_FAN, (Integer)Config.TIDE_MASTER_TUBE_CORAL_FAN_PRICE.get(), (Integer)Config.TIDE_MASTER_TUBE_CORAL_FAN_COUNT.get(), 30)};
        VillagerTrades.TRADES.put(ProfessionRegistry.OCEAN_EXPLORER_KEY, TradeReg.toIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)oceanlevel1, (Object)2, (Object)oceanlevel2, (Object)3, (Object)oceanlevel3, (Object)4, (Object)oceanlevel4, (Object)5, (Object)oceanlevel5)));
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> toIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    public static ItemStack getRandomItemFromTag(TagKey<Item> tag, Level level, RandomSource random) {
        Optional tagSetOptional = ((Registry)level.registryAccess().lookup(Registries.ITEM).get()).get(tag);
        if (tagSetOptional.isEmpty() || ((HolderSet.Named)tagSetOptional.get()).unwrapKey().isEmpty()) {
            return ItemStack.EMPTY;
        }
        HolderSet.Named tagSet = (HolderSet.Named)tagSetOptional.get();
        ArrayList holders = new ArrayList();
        tagSet.forEach(holders::add);
        Holder chosenHolder = (Holder)holders.get(random.nextInt(holders.size()));
        return new ItemStack((ItemLike)chosenHolder.value());
    }

    public static class EmeraldForItemsTrade
    implements VillagerTrades.ItemListing {
        private final ItemCost itemStack;
        private final int maxUses;
        private final int villagerXp;
        private final int emeraldAmount;
        private final float priceMultiplier;

        public EmeraldForItemsTrade(ItemLike item, int count, int emeraldAmount, int xp) {
            this(new ItemCost((ItemLike)item.asItem(), count), 12, emeraldAmount, xp);
        }

        public EmeraldForItemsTrade(ItemCost item, int max_uses, int emeraldAmount, int xp) {
            this.itemStack = item;
            this.maxUses = max_uses;
            this.villagerXp = xp;
            this.emeraldAmount = emeraldAmount;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer getOffer(Entity p_219682_, RandomSource p_219683_) {
            return new MerchantOffer(this.itemStack, new ItemStack((ItemLike)Items.EMERALD, this.emeraldAmount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class ItemsForEmeraldsTrade
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForEmeraldsTrade(Item item, int emeraldCost, int itemAmount, int villagerXp) {
            this(new ItemStack((ItemLike)item), emeraldCost, itemAmount, 12, villagerXp);
        }

        public ItemsForEmeraldsTrade(ItemStack item, int emeraldCost, int itemAmount, int maxUses, int villagerXp) {
            this(item, emeraldCost, itemAmount, maxUses, villagerXp, 0.05f);
        }

        public ItemsForEmeraldsTrade(ItemStack item, int emeraldCost, int itemAmount, int maxUses, int villagerXp, float priceMultiplier) {
            this.itemStack = item;
            this.emeraldCost = emeraldCost;
            this.itemStack.setCount(itemAmount);
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer getOffer(Entity p_219699_, RandomSource p_219700_) {
            ItemStack itemstack = this.itemStack.copy();
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), itemstack, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class ItemTagForItem
    implements VillagerTrades.ItemListing {
        private final TagKey<Item> item;
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;
        private final int itemAmount;
        private final boolean hasDiamonds;

        public ItemTagForItem(TagKey<Item> item, int itemAmount, int emeraldCost, int maxUses, int villagerXp, float priceMultiplier, boolean hasDiamonds) {
            this.item = item;
            this.emeraldCost = emeraldCost;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = priceMultiplier;
            this.itemAmount = itemAmount;
            this.hasDiamonds = hasDiamonds;
        }

        @Nullable
        public MerchantOffer getOffer(Entity trader, RandomSource random) {
            ItemStack itemstack = TradeReg.getRandomItemFromTag(this.item, trader.level(), random);
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), this.hasDiamonds ? Optional.of(new ItemCost((ItemLike)Items.DIAMOND, 7)) : Optional.empty(), new ItemStack((ItemLike)itemstack.getItem(), this.itemAmount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }

        public List<ItemStack> getAllTagVariants() {
            return StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(this.item).spliterator(), false).map(holder -> new ItemStack((ItemLike)holder.value())).toList();
        }

        public int GetEmeraldInput() {
            return this.emeraldCost;
        }

        public boolean hasDiamonds() {
            return this.hasDiamonds;
        }

        public int getItemCost() {
            return this.itemAmount;
        }
    }

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final Holder<MapDecorationType> destinationType;
        private final int maxUses;
        private final int villagerXp;

        public TreasureMapForEmeralds(int p_207767_, TagKey<Structure> structure, String name, Holder<MapDecorationType> decor_type, int max_uses, int xp) {
            this.emeraldCost = p_207767_;
            this.destination = structure;
            this.displayName = name;
            this.destinationType = decor_type;
            this.maxUses = max_uses;
            this.villagerXp = xp;
        }

        @Nullable
        public MerchantOffer getOffer(Entity p_219708_, RandomSource p_219709_) {
            if (!(p_219708_.level() instanceof ServerLevel)) {
                return null;
            }
            ServerLevel $$2 = (ServerLevel)p_219708_.level();
            BlockPos $$3 = $$2.findNearestMapStructure(this.destination, p_219708_.blockPosition(), 100, true);
            if ($$3 != null) {
                ItemStack $$4 = MapItem.create((ServerLevel)$$2, (int)$$3.getX(), (int)$$3.getZ(), (byte)2, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)$$2, (ItemStack)$$4);
                MapItemSavedData.addTargetDecoration((ItemStack)$$4, (BlockPos)$$3, (String)"+", this.destinationType);
                $$4.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.displayName));
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), $$4, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }
}

