/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.movillagers;

import com.belgie.movillagers.MoVillagers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="movillagers")
public class WorkStationConfigs {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    static final ModConfigSpec SPEC;
    public static ModConfigSpec.ConfigValue<String> FLORIST_WORKSTATION;
    public static ModConfigSpec.ConfigValue<String> MINER_WORKSTATION;
    public static ModConfigSpec.ConfigValue<String> LUMBER_JACK_WORKSTATION;
    public static ModConfigSpec.ConfigValue<String> ENGINEER_WORKSTATION;
    public static ModConfigSpec.ConfigValue<String> EMBERIST_WORKSTATION;
    public static ModConfigSpec.ConfigValue<String> ARCHEOLOGIST_WORKSTATION;
    public static ModConfigSpec.ConfigValue<String> TIDE_MASTER_WORKSTATION;

    public static Block getBlockFromString(String configString) {
        ResourceLocation id = ResourceLocation.parse((String)configString);
        Block block = (Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(id).get()).value();
        if (block == Blocks.AIR && !configString.equals("minecraft:air")) {
            MoVillagers.LOGGER.warn("Invalid block ID in config: {}", (Object)configString);
        }
        return block;
    }

    static {
        BUILDER.push("WARNING - Changing These values can result in errors with villagers pathfinding / keeping professions when workstations are not near - Its recommended to change them before you start your world");
        FLORIST_WORKSTATION = BUILDER.comment("Work Station for Florist Villager").define("FloristWorkStation", (Object)"minecraft:flower_pot");
        MINER_WORKSTATION = BUILDER.comment("Work Station for Miner Villager").define("MinerWorkStation", (Object)"minecraft:furnace");
        LUMBER_JACK_WORKSTATION = BUILDER.comment("Work Station for Lumber Jack Villager").define("LumberJackWorkStation", (Object)"minecraft:crafting_table");
        ENGINEER_WORKSTATION = BUILDER.comment("Work Station for Engineer Villager").define("EngineerWorkStation", (Object)"minecraft:target");
        EMBERIST_WORKSTATION = BUILDER.comment("Work Station for Emberist Villager").define("EmberistWorkStation", (Object)"minecraft:respawn_anchor");
        ARCHEOLOGIST_WORKSTATION = BUILDER.comment("Work Station for Archeologist Villager").define("ArcheologistWorkStation", (Object)"minecraft:suspicious_sand");
        TIDE_MASTER_WORKSTATION = BUILDER.comment("Work Station for Tide Master Villager").define("TideMasterWorkStation", (Object)"minecraft:conduit");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

