/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.client.renderer.tile;

import com.kentington.thaumichorizons.common.tiles.TileCloud;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import org.lwjgl.opengl.GL11;

public class TileCloudRender
extends TileEntitySpecialRenderer {
    private final Minecraft mc = Minecraft.getMinecraft();
    Random random = new Random();
    private int rendererUpdateCount;
    private static final ResourceLocation locationRainPng = new ResourceLocation("thaumichorizons", "textures/environment/rain.png");
    private static final ResourceLocation locationEmberPng = new ResourceLocation("thaumichorizons", "textures/environment/firerain.png");
    private static final ResourceLocation locationSnowPng = new ResourceLocation("textures/environment/snow.png");

    public void renderTileEntityAt(TileEntity tile, double x, double y, double z, float partial) {
        if (TileCloud.raining) {
            this.renderRainSnowToo((TileCloud)tile, x, y, z, partial);
            ++this.rendererUpdateCount;
        }
    }

    public void renderRainSnowToo(TileCloud tco, double p_147500_2_, double p_147500_4_, double p_147500_6_, float p_147500_8_) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)p_147500_2_ + 0.5f), (float)((float)p_147500_4_ + 1.5f), (float)((float)p_147500_6_ + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPopMatrix();
        if (tco.getWorldObj() == null) {
            return;
        }
        float f1 = 1.0f;
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Tessellator tessellator = Tessellator.instance;
        BiomeGenBase biomegenbase = tco.getWorldObj().getBiomeGenForCoords(tco.xCoord, tco.zCoord);
        if (tco.md == 1) {
            this.bindTexture(locationEmberPng);
        } else if ((double)biomegenbase.getFloatTemperature(tco.xCoord, tco.yCoord, tco.zCoord) >= 0.15) {
            this.bindTexture(locationRainPng);
        } else {
            this.bindTexture(locationSnowPng);
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.glBlendFunc((int)770, (int)1, (int)1, (int)0);
        float f2 = (float)tco.getWorldObj().getTotalWorldTime() + p_147500_8_ + (float)tco.xCoord + (float)(16 * tco.zCoord);
        float f3 = -f2 * 0.2f - (float)MathHelper.floor_float((float)(-f2 * 0.1f));
        boolean b0 = true;
        double d3 = (double)f2 * 0.025 * -1.5;
        tessellator.startDrawingQuads();
        switch (tco.md) {
            case 1: 
            case 7: {
                tessellator.setColorRGBA(255, 255, 255, 255);
                break;
            }
            case 3: {
                tessellator.setColorRGBA(32, 255, 64, 255);
                break;
            }
            case 4: {
                tessellator.setColorRGBA(64, 64, 64, 255);
                break;
            }
            case 5: {
                tessellator.setColorRGBA(255, 64, 32, 255);
                break;
            }
            case 6: {
                tessellator.setColorRGBA(170, 64, 200, 255);
                break;
            }
            case 8: {
                tessellator.setColorRGBA(160, 255, 160, 255);
                break;
            }
            case 9: {
                tessellator.setColorRGBA(255, 230, 64, 255);
                break;
            }
            default: {
                tessellator.setColorRGBA(32, 64, 255, 255);
            }
        }
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 1.0;
        double d10 = 1.0;
        double d11 = 1.0;
        double d12 = tco.howManyDown != -1 ? (double)(tco.howManyDown - 1) : 256.0;
        double d13 = 0.0;
        double d14 = 1.0;
        double d15 = -1.0f + f3;
        double d16 = (double)tco.howManyDown / 4.0 + d15;
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_ - d12, p_147500_6_ + 0.0, 1.0, d16);
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_, p_147500_6_ + 0.0, 1.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_, p_147500_6_ + 0.0, 0.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_ - d12, p_147500_6_ + 0.0, 0.0, d16);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_ - d12, p_147500_6_ + 1.0, 1.0, d16);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_, p_147500_6_ + 1.0, 1.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_, p_147500_6_ + 1.0, 0.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_ - d12, p_147500_6_ + 1.0, 0.0, d16);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_ - d12, p_147500_6_ + 0.0, 1.0, d16);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_, p_147500_6_ + 0.0, 1.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_, p_147500_6_ + 1.0, 0.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 1.0, p_147500_4_ - d12, p_147500_6_ + 1.0, 0.0, d16);
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_ - d12, p_147500_6_ + 1.0, 1.0, d16);
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_, p_147500_6_ + 1.0, 1.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_, p_147500_6_ + 0.0, 0.0, d15);
        tessellator.addVertexWithUV(p_147500_2_ + 0.0, p_147500_4_ - d12, p_147500_6_ + 0.0, 0.0, d16);
        tessellator.draw();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }
}

