/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.client.renderer.tile;

import com.kentington.thaumichorizons.client.renderer.model.ModelQuarterBlock;
import com.kentington.thaumichorizons.common.tiles.TileVisDynamo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.UtilsFX;

public class TileVisDynamoRender
extends TileEntitySpecialRenderer {
    private final IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)SCANNER);
    private static final ResourceLocation SCANNER = new ResourceLocation("thaumcraft", "textures/models/scanner.obj");
    static String tx1 = "textures/models/goldring.png";
    static String tx2 = "textures/models/dynamobase.png";
    static String tx3 = "textures/items/lightningringv.png";
    private final ModelQuarterBlock base = new ModelQuarterBlock();

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        TileVisDynamo tco = (TileVisDynamo)te;
        if (tco.rise >= 0.3f && tco.ticksProvided > 0) {
            GL11.glPushMatrix();
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            long nt = System.nanoTime();
            UtilsFX.bindTexture((String)tx3);
            int frames = UtilsFX.getTextureAnimationSize((String)tx3);
            int i = (int)(((double)(nt / 40000000L) + x) % (double)frames);
            UtilsFX.renderFacingQuad((double)((double)tco.xCoord + 0.5), (double)((float)tco.yCoord + 0.5f), (double)((double)tco.zCoord + 0.5), (float)0.0f, (float)0.2f, (float)0.9f, (int)frames, (int)i, (float)f, (int)tco.color.getRGB());
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glPopMatrix();
        }
        if (tco.drainEntity != null && tco.drainCollision != null) {
            Entity drainEntity = tco.drainEntity;
            if (drainEntity instanceof EntityPlayer && !((EntityPlayer)drainEntity).isUsingItem()) {
                tco.drainEntity = null;
                tco.drainCollision = null;
            } else {
                MovingObjectPosition drainCollision = tco.drainCollision;
                GL11.glPushMatrix();
                float f2 = 0.0f;
                int iiud = ((EntityPlayer)drainEntity).getItemInUseDuration();
                if (drainEntity instanceof EntityPlayer) {
                    f2 = MathHelper.sin((float)((float)iiud / 10.0f)) * 10.0f;
                }
                Vec3 vec3 = Vec3.createVectorHelper((double)-0.1, (double)-0.1, (double)0.5);
                vec3.rotateAroundX(-(drainEntity.prevRotationPitch + (drainEntity.rotationPitch - drainEntity.prevRotationPitch) * f) * (float)Math.PI / 180.0f);
                vec3.rotateAroundY(-(drainEntity.prevRotationYaw + (drainEntity.rotationYaw - drainEntity.prevRotationYaw) * f) * (float)Math.PI / 180.0f);
                vec3.rotateAroundY(-f2 * 0.01f);
                vec3.rotateAroundX(-f2 * 0.015f);
                double d3 = drainEntity.prevPosX + (drainEntity.posX - drainEntity.prevPosX) * (double)f + vec3.xCoord;
                double d4 = drainEntity.prevPosY + (drainEntity.posY - drainEntity.prevPosY) * (double)f + vec3.yCoord;
                double d5 = drainEntity.prevPosZ + (drainEntity.posZ - drainEntity.prevPosZ) * (double)f + vec3.zCoord;
                double d6 = drainEntity == Minecraft.getMinecraft().thePlayer ? 0.0 : (double)drainEntity.getEyeHeight();
                UtilsFX.drawFloatyLine((double)((double)drainCollision.blockX + 0.5), (double)((double)drainCollision.blockY + 0.5), (double)((double)drainCollision.blockZ + 0.5), (double)d3, (double)(d4 + d6), (double)d5, (float)f, (int)tco.color.getRGB(), (String)"textures/misc/wispy.png", (float)-0.02f, (float)((float)Math.min(iiud, 10) / 10.0f));
                GL11.glPopMatrix();
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        UtilsFX.bindTexture((String)"thaumichorizons", (String)tx2);
        this.base.render();
        GL11.glTranslatef((float)0.5f, (float)(0.2f + tco.rise), (float)0.5f);
        GL11.glRotatef((float)tco.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)tco.rotation2, (float)1.0f, (float)0.0f, (float)0.0f);
        UtilsFX.bindTexture((String)"thaumichorizons", (String)tx1);
        GL11.glScalef((float)0.36f, (float)0.36f, (float)0.36f);
        this.model.renderAll();
        GL11.glRotatef((float)(-2.0f * tco.rotation2), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)0.5f, (float)1.0f, (float)0.5f);
        this.model.renderAll();
        GL11.glPopMatrix();
    }
}

