/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.entities;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityItemInvulnerable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityBoatThaumium
extends EntityBoat {
    private boolean isBoatEmpty = true;
    private double speedMultiplier = 0.1;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;

    public EntityBoatThaumium(World p_i1704_1_) {
        super(p_i1704_1_);
        this.preventEntitySpawning = true;
        this.setSize(1.5f, 0.6f);
        this.yOffset = this.height / 2.0f;
        this.isImmuneToFire = true;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(18, (Object)1);
        this.dataWatcher.addObject(19, (Object)Float.valueOf(0.0f));
    }

    public AxisAlignedBB getCollisionBox(Entity p_70114_1_) {
        return p_70114_1_.boundingBox;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public boolean canBePushed() {
        return true;
    }

    public EntityBoatThaumium(World p_i1705_1_, double p_i1705_2_, double p_i1705_4_, double p_i1705_6_) {
        this(p_i1705_1_);
        this.setPosition(p_i1705_2_, p_i1705_4_ + (double)this.yOffset, p_i1705_6_);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = p_i1705_2_;
        this.prevPosY = p_i1705_4_;
        this.prevPosZ = p_i1705_6_;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        if (!this.worldObj.isRemote && !this.isDead) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + p_70097_2_ * 10.0f);
            this.setBeenAttacked();
            boolean bl = flag = p_70097_1_.getEntity() instanceof EntityPlayer && ((EntityPlayer)p_70097_1_.getEntity()).capabilities.isCreativeMode;
            if (flag || this.getDamageTaken() > 40.0f) {
                if (this.riddenByEntity != null) {
                    this.riddenByEntity.mountEntity((Entity)this);
                }
                if (!flag) {
                    this.func_145778_a(ThaumicHorizons.itemBoatThaumium, 1, 0.0f);
                }
                this.setDead();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void performHurtAnimation() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double p_70056_1_, double p_70056_3_, double p_70056_5_, float p_70056_7_, float p_70056_8_, int p_70056_9_) {
        if (this.isBoatEmpty) {
            this.boatPosRotationIncrements = p_70056_9_ + 5;
        } else {
            double d3 = p_70056_1_ - this.posX;
            double d4 = p_70056_3_ - this.posY;
            double d5 = p_70056_5_ - this.posZ;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.boatPosRotationIncrements = 3;
        }
        this.boatX = p_70056_1_;
        this.boatY = p_70056_3_;
        this.boatZ = p_70056_5_;
        this.boatYaw = p_70056_7_;
        this.boatPitch = p_70056_8_;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.motionX = p_70016_1_;
        this.velocityX = p_70016_1_;
        this.motionY = p_70016_3_;
        this.velocityY = p_70016_3_;
        this.motionZ = p_70016_5_;
        this.velocityZ = p_70016_5_;
    }

    public void onUpdate() {
        int j;
        double d6;
        double d5;
        this.onEntityUpdate();
        boolean isLava = false;
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int b0 = 5;
        double d0 = 0.0;
        for (int i = 0; i < 5; ++i) {
            double d2 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)i / 5.0 - 0.125;
            double d3 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(i + 1) / 5.0 - 0.125;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)this.boundingBox.minX, (double)d2, (double)this.boundingBox.minZ, (double)this.boundingBox.maxX, (double)d3, (double)this.boundingBox.maxZ);
            if (this.worldObj.isAABBInMaterial(axisalignedbb, Material.water)) {
                d0 += 0.2;
                isLava = false;
                continue;
            }
            if (!this.worldObj.isAABBInMaterial(axisalignedbb, Material.lava)) continue;
            d0 += 0.2;
            isLava = true;
        }
        double d4 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        if (d4 > 0.26249999999999996) {
            d5 = Math.cos((double)this.rotationYaw * Math.PI / 180.0);
            d6 = Math.sin((double)this.rotationYaw * Math.PI / 180.0);
            j = 0;
            while ((double)j < 1.0 + d4 * 60.0) {
                double d10;
                double d9;
                double d7 = this.rand.nextFloat() * 2.0f - 1.0f;
                double d8 = (double)(this.rand.nextInt(2) * 2 - 1) * 0.7;
                if (this.rand.nextBoolean()) {
                    d9 = this.posX - d5 * d7 * 0.8 + d6 * d8;
                    d10 = this.posZ - d6 * d7 * 0.8 - d5 * d8;
                    if (!isLava) {
                        this.worldObj.spawnParticle("splash", d9, this.posY - 0.125, d10, this.motionX, this.motionY, this.motionZ);
                    } else if (this.rand.nextInt(5) == 1) {
                        this.worldObj.spawnParticle("lava", d9, this.posY - 0.125, d10, this.motionX, this.motionY, this.motionZ);
                    }
                } else {
                    d9 = this.posX + d5 + d6 * d7 * 0.7;
                    d10 = this.posZ + d6 - d5 * d7 * 0.7;
                    if (!isLava) {
                        this.worldObj.spawnParticle("splash", d9, this.posY - 0.125, d10, this.motionX, this.motionY, this.motionZ);
                    } else if (this.rand.nextInt(5) == 1) {
                        this.worldObj.spawnParticle("lava", d9, this.posY - 0.125, d10, this.motionX, this.motionY, this.motionZ);
                    }
                }
                ++j;
            }
        }
        if (this.worldObj.isRemote && this.isBoatEmpty) {
            if (this.boatPosRotationIncrements > 0) {
                d5 = this.posX + (this.boatX - this.posX) / (double)this.boatPosRotationIncrements;
                d6 = this.posY + (this.boatY - this.posY) / (double)this.boatPosRotationIncrements;
                double d11 = this.posZ + (this.boatZ - this.posZ) / (double)this.boatPosRotationIncrements;
                double d12 = MathHelper.wrapAngleTo180_double((double)(this.boatYaw - (double)this.rotationYaw));
                this.rotationYaw += (float)(d12 / (double)this.boatPosRotationIncrements);
                this.rotationPitch += (float)((this.boatPitch - (double)this.rotationPitch) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.setPosition(d5, d6, d11);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                d5 = this.posX + this.motionX;
                d6 = this.posY + this.motionY;
                double d11 = this.posZ + this.motionZ;
                this.setPosition(d5, d6, d11);
                if (this.onGround) {
                    this.motionX *= 0.5;
                    this.motionY *= 0.5;
                    this.motionZ *= 0.5;
                }
                this.motionX *= (double)0.99f;
                this.motionY *= (double)0.95f;
                this.motionZ *= (double)0.99f;
            }
        } else {
            double d13;
            double d52;
            Entity d3;
            if (this.riddenByEntity != null) {
                this.riddenByEntity.extinguish();
                ((EntityLivingBase)this.riddenByEntity).addPotionEffect(new PotionEffect(Potion.fireResistance.id, 10, 0, true));
            }
            if (d0 < 1.0) {
                d5 = d0 * 2.0 - 1.0;
                this.motionY += (double)0.04f * d5;
            } else {
                if (this.motionY < 0.0) {
                    this.motionY /= 2.0;
                }
                this.motionY += (double)0.007f;
            }
            if (this.riddenByEntity != null && (d3 = this.riddenByEntity) instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)d3;
                float f = this.riddenByEntity.rotationYaw + -entitylivingbase.moveStrafing * 90.0f;
                this.motionX += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.moveForward * (double)0.05f;
                this.motionZ += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.moveForward * (double)0.05f;
            }
            if ((d52 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ)) > 0.45) {
                d6 = 0.45 / d52;
                this.motionX *= d6;
                this.motionZ *= d6;
                d52 = 0.45;
            }
            if (d52 > d4 && this.speedMultiplier < 0.5) {
                this.speedMultiplier += (0.5 - this.speedMultiplier) / 50.0;
                if (this.speedMultiplier > 0.5) {
                    this.speedMultiplier = 0.5;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.1) / 50.0;
                if (this.speedMultiplier < 0.1) {
                    this.speedMultiplier = 0.1;
                }
            }
            for (int l = 0; l < 4; ++l) {
                int i2 = MathHelper.floor_double((double)(this.posX + ((double)(l % 2) - 0.5) * 0.8));
                j = MathHelper.floor_double((double)(this.posZ + ((double)(l / 2) - 0.5) * 0.8));
                for (int j2 = 0; j2 < 2; ++j2) {
                    int k = MathHelper.floor_double((double)this.posY) + j2;
                    Block block = this.worldObj.getBlock(i2, k, j);
                    if (block == Blocks.snow_layer) {
                        this.worldObj.setBlockToAir(i2, k, j);
                        this.isCollidedHorizontally = false;
                        continue;
                    }
                    if (block != Blocks.waterlily) continue;
                    this.worldObj.func_147480_a(i2, k, j, true);
                    this.isCollidedHorizontally = false;
                }
            }
            if (this.onGround) {
                this.motionX *= 0.5;
                this.motionY *= 0.5;
                this.motionZ *= 0.5;
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.99f;
            this.motionY *= (double)0.95f;
            this.motionZ *= (double)0.99f;
            this.rotationPitch = 0.0f;
            double d62 = this.rotationYaw;
            double d11 = this.prevPosX - this.posX;
            double d12 = this.prevPosZ - this.posZ;
            if (d11 * d11 + d12 * d12 > 0.001) {
                d62 = (float)(Math.atan2(d12, d11) * 180.0 / Math.PI);
            }
            if ((d13 = MathHelper.wrapAngleTo180_double((double)(d62 - (double)this.rotationYaw))) > 20.0) {
                d13 = 20.0;
            }
            if (d13 < -20.0) {
                d13 = -20.0;
            }
            this.setRotation(this.rotationYaw += (float)d13, this.rotationPitch);
            if (!this.worldObj.isRemote) {
                List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand((double)0.2f, 0.0, (double)0.2f));
                if (list != null && !list.isEmpty()) {
                    for (Object o : list) {
                        Entity entity = (Entity)o;
                        if (entity == this.riddenByEntity || !entity.canBePushed() || !(entity instanceof EntityBoat)) continue;
                        entity.applyEntityCollision((Entity)this);
                    }
                }
                if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
                    this.riddenByEntity = null;
                }
            }
        }
    }

    public void updateRiderPosition() {
        if (this.riddenByEntity != null) {
            double d0 = Math.cos((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
            double d2 = Math.sin((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
            this.riddenByEntity.setPosition(this.posX + d0, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ + d2);
        }
    }

    protected void writeEntityToNBT(NBTTagCompound p_70014_1_) {
    }

    protected void readEntityFromNBT(NBTTagCompound p_70037_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public boolean interactFirst(EntityPlayer p_130002_1_) {
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != p_130002_1_) {
            return true;
        }
        if (!this.worldObj.isRemote) {
            p_130002_1_.mountEntity((Entity)this);
        }
        return true;
    }

    protected void updateFallState(double p_70064_1_, boolean p_70064_3_) {
        int i = MathHelper.floor_double((double)this.posX);
        int j = MathHelper.floor_double((double)this.posY);
        int k = MathHelper.floor_double((double)this.posZ);
        if (!p_70064_3_ && this.worldObj.getBlock(i, j - 1, k).getMaterial() != Material.water && this.worldObj.getBlock(i, j - 1, k).getMaterial() != Material.lava && p_70064_1_ < 0.0) {
            this.fallDistance -= (float)p_70064_1_;
        }
    }

    public void setDamageTaken(float p_70266_1_) {
        this.dataWatcher.updateObject(19, (Object)Float.valueOf(p_70266_1_));
    }

    public float getDamageTaken() {
        return this.dataWatcher.getWatchableObjectFloat(19);
    }

    public void setTimeSinceHit(int p_70265_1_) {
        this.dataWatcher.updateObject(17, (Object)p_70265_1_);
    }

    public int getTimeSinceHit() {
        return this.dataWatcher.getWatchableObjectInt(17);
    }

    public void setForwardDirection(int p_70269_1_) {
        this.dataWatcher.updateObject(18, (Object)p_70269_1_);
    }

    public int getForwardDirection() {
        return this.dataWatcher.getWatchableObjectInt(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsBoatEmpty(boolean p_70270_1_) {
        this.isBoatEmpty = p_70270_1_;
    }

    public EntityItem entityDropItem(ItemStack p_70099_1_, float p_70099_2_) {
        if (p_70099_1_.stackSize != 0 && p_70099_1_.getItem() != null) {
            EntityItemInvulnerable entityitem = new EntityItemInvulnerable(this.worldObj, this.posX, this.posY + (double)p_70099_2_, this.posZ, p_70099_1_);
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.worldObj.spawnEntityInWorld((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }
}

