/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.entities;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;

public class EntitySoul
extends EntityFlying
implements IMob {
    public int courseChangeCooldown = 0;
    public double waypointX;
    public double waypointY;
    public double waypointZ;

    public EntitySoul(World world) {
        super(world);
        this.setSize(0.9f, 0.9f);
        this.experienceValue = 5;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(1.0);
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public int decreaseAirSupply(int par1) {
        return par1;
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i) {
        return false;
    }

    protected void entityInit() {
        super.entityInit();
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (this.worldObj.isRemote) {
            Thaumcraft.proxy.burst(this.worldObj, this.posX, this.posY, this.posZ, 1.0f);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote && this.worldObj.rand.nextBoolean()) {
            Color color = Color.CYAN;
            Thaumcraft.proxy.wispFX(this.worldObj, this.posX + (double)((this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.7f), this.posY + (double)((this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.7f), this.posZ + (double)((this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.7f), 0.1f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        }
    }

    protected void updateEntityActionState() {
        float n;
        double attackrange = 16.0;
        double d = this.waypointX - this.posX;
        double d2 = this.waypointY - this.posY;
        double d3 = this.waypointZ - this.posZ;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 < 1.0 || d4 > 3600.0) {
            this.waypointX = this.posX + (double)(this.rand.nextFloat() * 2.0f - 1.0f) * 16.0;
            this.waypointY = this.posY + (double)(this.rand.nextFloat() * 2.0f - 1.0f) * 16.0;
            this.waypointZ = this.posZ + (double)(this.rand.nextFloat() * 2.0f - 1.0f) * 16.0;
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.rand.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d4 = (double)MathHelper.sqrt_double((double)d4))) {
                this.motionX += d / d4 * 0.1;
                this.motionY += d2 / d4 * 0.1;
                this.motionZ += d3 / d4 * 0.1;
            } else {
                this.waypointX = this.posX;
                this.waypointY = this.posY;
                this.waypointZ = this.posZ;
            }
        }
        this.rotationYaw = n = -((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / (float)Math.PI;
        this.renderYawOffset = n;
    }

    private boolean isCourseTraversable(double d, double d1, double d2, double d3) {
        double d4 = (this.waypointX - this.posX) / d3;
        double d5 = (this.waypointY - this.posY) / d3;
        double d6 = (this.waypointZ - this.posZ) / d3;
        AxisAlignedBB axisalignedbb = this.boundingBox.copy();
        int i = 1;
        while ((double)i < d3) {
            axisalignedbb.offset(d4, d5, d6);
            if (!this.worldObj.getCollidingBoundingBoxes((Entity)this, axisalignedbb).isEmpty()) {
                return false;
            }
            ++i;
        }
        int x = (int)this.waypointX;
        int y = (int)this.waypointY;
        int z = (int)this.waypointZ;
        if (this.worldObj.getBlock(x, y, z).getMaterial().isLiquid()) {
            return false;
        }
        for (int a = 0; a < 11; ++a) {
            if (this.worldObj.isAirBlock(x, y - a, z)) continue;
            return true;
        }
        return false;
    }

    protected String getLivingSound() {
        return "thaumcraft:wisplive";
    }

    protected String getHurtSound() {
        return "random.fizz";
    }

    protected String getDeathSound() {
        return "thaumcraft:wispdead";
    }

    protected Item getDropItem() {
        return null;
    }

    protected void dropFewItems(boolean flag, int i) {
    }

    protected float getSoundVolume() {
        return 0.25f;
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean getCanSpawnHere() {
        return true;
    }

    protected boolean isValidLightLevel() {
        return true;
    }
}

