/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.handlers;

import java.util.Set;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class BehaviorDispenseBoat
extends BehaviorDefaultDispenseItem {
    private final Set<Material> validMaterials;
    private final BoatFactory boatFactory;

    public BehaviorDispenseBoat(Set<Material> validMaterials, BoatFactory boatFactory) {
        this.validMaterials = validMaterials;
        this.boatFactory = boatFactory;
    }

    protected ItemStack dispenseStack(IBlockSource dispenser, ItemStack stack) {
        float f;
        int targetZ;
        int targetY;
        EnumFacing facing = BlockDispenser.func_149937_b((int)dispenser.getBlockMetadata());
        World world = dispenser.getWorld();
        double spawnX = dispenser.getX() + (double)((float)facing.getFrontOffsetX() * 1.25f);
        double spawnY = dispenser.getY() + (double)((float)facing.getFrontOffsetY() * 1.125f) - 0.5;
        double spawnZ = dispenser.getZ() + (double)((float)facing.getFrontOffsetZ() * 1.25f);
        int targetX = dispenser.getXInt() + facing.getFrontOffsetX();
        Material frontMaterial = world.getBlock(targetX, targetY = dispenser.getYInt() + facing.getFrontOffsetY(), targetZ = dispenser.getZInt() + facing.getFrontOffsetZ()).getMaterial();
        if (this.validMaterials.contains(frontMaterial)) {
            spawnY += 1.0;
        } else if (!Material.air.equals(frontMaterial)) {
            return stack;
        }
        EntityBoat boat = this.boatFactory.create(world, spawnX, spawnY, spawnZ);
        switch (facing) {
            case NORTH: {
                f = 90.0f;
                break;
            }
            case WEST: {
                f = 180.0f;
                break;
            }
            case EAST: {
                f = 0.0f;
                break;
            }
            default: {
                f = -90.0f;
            }
        }
        boat.rotationYaw = f;
        world.spawnEntityInWorld((Entity)boat);
        --stack.stackSize;
        return stack;
    }

    public static interface BoatFactory {
        public EntityBoat create(World var1, double var2, double var4, double var6);
    }
}

