/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.items;

import com.google.common.collect.HashMultimap;
import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityBlastPhial;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSyringeInjection
extends ItemPotion {
    private IIcon field_94590_d;
    private IIcon field_94591_c;
    private IIcon field_94592_ct;

    public ItemSyringeInjection() {
        this.setHasSubtypes(true);
        this.setMaxStackSize(1);
        this.setCreativeTab(ThaumicHorizons.tabTH);
    }

    public int getMaxItemUseDuration(ItemStack p_77626_1_) {
        return 8;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public String getItemStackDisplayName(ItemStack p_77653_1_) {
        return StatCollector.translateToLocal((String)("item.injection." + p_77653_1_.getItemDamage() + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item p_150895_1_, CreativeTabs p_150895_2_, List p_150895_3_) {
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.field_94590_d = ir.registerIcon("thaumichorizons:phialBlood");
        this.field_94591_c = ir.registerIcon("thaumichorizons:phialBlood");
        this.field_94592_ct = ir.registerIcon("thaumichorizons:phialBlood");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int p_77617_1_) {
        return ItemSyringeInjection.isSplash((int)p_77617_1_) ? this.field_94591_c : this.field_94590_d;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int p_77618_1_, int p_77618_2_) {
        return p_77618_2_ == 0 ? this.field_94592_ct : super.getIconFromDamageForRenderPass(p_77618_1_, p_77618_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon func_94589_d(String p_94589_0_) {
        return p_94589_0_.equals("bottle_drinkable") ? ((ItemSyringeInjection)ThaumicHorizons.itemSyringeInjection).field_94590_d : (p_94589_0_.equals("bottle_splash") ? ((ItemSyringeInjection)ThaumicHorizons.itemSyringeInjection).field_94591_c : (p_94589_0_.equals("overlay") ? ((ItemSyringeInjection)ThaumicHorizons.itemSyringeInjection).field_94592_ct : null));
    }

    public boolean isPhial(int p_77831_0_) {
        return p_77831_0_ != 0;
    }

    public ItemStack onItemRightClick(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        if (this.isPhial(p_77659_1_.getItemDamage())) {
            if (!p_77659_3_.capabilities.isCreativeMode) {
                --p_77659_1_.stackSize;
            }
            p_77659_2_.playSoundAtEntity((Entity)p_77659_3_, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!p_77659_2_.isRemote) {
                p_77659_2_.spawnEntityInWorld((Entity)new EntityBlastPhial(p_77659_2_, (EntityLivingBase)p_77659_3_, 0.5f, p_77659_1_));
            }
            return p_77659_1_;
        }
        p_77659_3_.setItemInUse(p_77659_1_, this.getMaxItemUseDuration(p_77659_1_));
        return p_77659_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List messages, boolean ignored) {
        List potionEffects = Items.potionitem.getEffects(itemStack);
        HashMultimap preparedEffects = HashMultimap.create();
        if (potionEffects != null && !potionEffects.isEmpty()) {
            for (PotionEffect potioneffect : potionEffects) {
                String message = StatCollector.translateToLocal((String)potioneffect.getEffectName()).trim();
                Potion potion = Potion.potionTypes[potioneffect.getPotionID()];
                Map map = potion.func_111186_k();
                if (map != null && !map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier entryValue = (AttributeModifier)entry.getValue();
                        AttributeModifier attributeModifier = new AttributeModifier(entryValue.getName(), potion.func_111183_a(potioneffect.getAmplifier(), entryValue), entryValue.getOperation());
                        preparedEffects.put((Object)((IAttribute)entry.getKey()), (Object)attributeModifier);
                    }
                }
                if (potioneffect.getAmplifier() > 0) {
                    message = message + " " + StatCollector.translateToLocal((String)("potion.potency." + potioneffect.getAmplifier())).trim();
                }
                if (potioneffect.getDuration() > 20) {
                    message = message + " (" + Potion.getDurationString((PotionEffect)potioneffect) + ")";
                }
                if (potion.isBadEffect()) {
                    messages.add(EnumChatFormatting.RED + message);
                    continue;
                }
                messages.add(EnumChatFormatting.GRAY + message);
            }
        } else {
            messages.add(EnumChatFormatting.GRAY + StatCollector.translateToLocal((String)"potion.empty").trim());
        }
        if (!preparedEffects.isEmpty()) {
            messages.add("");
            messages.add(EnumChatFormatting.DARK_PURPLE + StatCollector.translateToLocal((String)"potion.effects.whenDrank"));
            for (Map.Entry entry : preparedEffects.entries()) {
                AttributeModifier entryValue = (AttributeModifier)entry.getValue();
                double valueAmount = entryValue.getAmount();
                double convertedAmount = entryValue.getOperation() != 1 && entryValue.getOperation() != 2 ? entryValue.getAmount() : entryValue.getAmount() * 100.0;
                if (valueAmount > 0.0) {
                    messages.add(EnumChatFormatting.BLUE + StatCollector.translateToLocalFormatted((String)("attribute.modifier.plus." + entryValue.getOperation()), (Object[])new Object[]{ItemStack.field_111284_a.format(convertedAmount), StatCollector.translateToLocal((String)("attribute.name." + entry.getKey()))}));
                    continue;
                }
                if (valueAmount >= 0.0) continue;
                messages.add(EnumChatFormatting.RED + StatCollector.translateToLocalFormatted((String)("attribute.modifier.take." + entryValue.getOperation()), (Object[])new Object[]{ItemStack.field_111284_a.format(convertedAmount *= -1.0), StatCollector.translateToLocal((String)("attribute.name." + entry.getKey()))}));
            }
        }
    }

    public boolean hitEntity(ItemStack is, EntityLivingBase target, EntityLivingBase hitter) {
        List list;
        if (!target.worldObj.isRemote && (list = this.getEffects(is)) != null) {
            for (PotionEffect potioneffect : list) {
                target.addPotionEffect(new PotionEffect(potioneffect));
            }
        }
        --is.stackSize;
        return super.hitEntity(is, target, hitter);
    }

    public int getColorFromItemStack(ItemStack stack, int p_82790_2_) {
        if (stack.getItem() == ThaumicHorizons.itemSyringeInjection) {
            if (stack.hasTagCompound()) {
                return stack.getTagCompound().getInteger("color");
            }
        } else if (stack.getItem() != ThaumicHorizons.itemSyringeEmpty) {
            return Color.RED.getRGB();
        }
        return 0xFFFFFF;
    }

    public ItemStack onEaten(ItemStack p_77654_1_, World p_77654_2_, EntityPlayer p_77654_3_) {
        List list;
        if (!p_77654_3_.capabilities.isCreativeMode) {
            --p_77654_1_.stackSize;
        }
        if (!p_77654_2_.isRemote && (list = this.getEffects(p_77654_1_)) != null) {
            for (PotionEffect potioneffect : list) {
                p_77654_3_.addPotionEffect(new PotionEffect(potioneffect));
            }
        }
        if (p_77654_1_.stackSize <= 0) {
            return null;
        }
        return p_77654_1_;
    }
}

