/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.lib;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.entities.EntityItemInvulnerable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.blocks.BlockAiry;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemCrystalEssence;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.tiles.TileNode;

public class ExplosionAlchemite
extends Explosion {
    public boolean isFlaming;
    public boolean isSmoking = true;
    private int field_77289_h = 16;
    private final Random explosionRNG = new Random();
    private final World worldObj;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity exploder;
    public float explosionSize;
    public List<ChunkPosition> affectedBlockPositions = new ArrayList<ChunkPosition>();
    private Map field_77288_k = new HashMap();

    public ExplosionAlchemite(World p_i1948_1_, Entity p_i1948_2_, double p_i1948_3_, double p_i1948_5_, double p_i1948_7_, float p_i1948_9_) {
        super(p_i1948_1_, p_i1948_2_, p_i1948_3_, p_i1948_5_, p_i1948_7_, p_i1948_9_);
        this.worldObj = p_i1948_1_;
        this.exploder = p_i1948_2_;
        this.explosionSize = p_i1948_9_;
        this.explosionX = p_i1948_3_;
        this.explosionY = p_i1948_5_;
        this.explosionZ = p_i1948_7_;
    }

    public void doExplosionA() {
        int k;
        int j;
        int i;
        float f = this.explosionSize;
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        for (i = 0; i < this.field_77289_h; ++i) {
            for (j = 0; j < this.field_77289_h; ++j) {
                for (k = 0; k < this.field_77289_h; ++k) {
                    if (i != 0 && i != this.field_77289_h - 1 && j != 0 && j != this.field_77289_h - 1 && k != 0 && k != this.field_77289_h - 1) continue;
                    double d0 = (float)i / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)j / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d3 = (float)k / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d4 = Math.sqrt(d0 * d0 + d2 * d2 + d3 * d3);
                    d0 /= d4;
                    d2 /= d4;
                    d3 /= d4;
                    double d5 = this.explosionX;
                    double d6 = this.explosionY;
                    double d7 = this.explosionZ;
                    float f3 = 0.3f;
                    for (float f2 = this.explosionSize * (0.7f + this.worldObj.rand.nextFloat() * 0.6f); f2 > 0.0f; f2 -= f3 * 0.75f) {
                        int j2 = MathHelper.floor_double((double)d5);
                        int k2 = MathHelper.floor_double((double)d6);
                        int l1 = MathHelper.floor_double((double)d7);
                        Block block = this.worldObj.getBlock(j2, k2, l1);
                        if (this.worldObj.getTileEntity(j2, k2, l1) != null && this.worldObj.getTileEntity(j2, k2, l1) instanceof TileNode) {
                            hashset.add(new ChunkPosition(j2, k2, l1));
                        } else if (block.getMaterial() != Material.air) {
                            float f4 = this.exploder != null ? this.exploder.func_145772_a((Explosion)this, this.worldObj, j2, k2, l1, block) : block.getExplosionResistance(this.exploder, this.worldObj, j2, k2, l1, this.explosionX, this.explosionY, this.explosionZ);
                            f2 -= (f4 + 0.3f) * f3;
                        }
                        if (f2 > 0.0f && (this.exploder == null || this.exploder.func_145774_a((Explosion)this, this.worldObj, j2, k2, l1, block, f2))) {
                            hashset.add(new ChunkPosition(j2, k2, l1));
                        }
                        d5 += d0 * (double)f3;
                        d6 += d2 * (double)f3;
                        d7 += d3 * (double)f3;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(hashset);
        this.explosionSize *= 2.0f;
        i = MathHelper.floor_double((double)(this.explosionX - (double)this.explosionSize - 1.0));
        j = MathHelper.floor_double((double)(this.explosionX + (double)this.explosionSize + 1.0));
        k = MathHelper.floor_double((double)(this.explosionY - (double)this.explosionSize - 1.0));
        int i2 = MathHelper.floor_double((double)(this.explosionY + (double)this.explosionSize + 1.0));
        int m = MathHelper.floor_double((double)(this.explosionZ - (double)this.explosionSize - 1.0));
        int j3 = MathHelper.floor_double((double)(this.explosionZ + (double)this.explosionSize + 1.0));
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this.exploder, AxisAlignedBB.getBoundingBox((double)i, (double)k, (double)m, (double)j, (double)i2, (double)j3));
        Vec3 vec3 = Vec3.createVectorHelper((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (Object o : list) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)o;
            double d8 = entity.getDistance(this.explosionX, this.explosionY, this.explosionZ) / (double)this.explosionSize;
            if (!(d8 <= 1.0) || (d9 = (double)MathHelper.sqrt_double((double)((d5 = entity.posX - this.explosionX) * d5 + (d6 = entity.posY + (double)entity.getEyeHeight() - this.explosionY) * d6 + (d7 = entity.posZ - this.explosionZ) * d7))) == 0.0) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            double d10 = this.worldObj.getBlockDensity(vec3, entity.boundingBox);
            double d11 = (1.0 - d8) * d10;
            entity.attackEntityFrom(DamageSourceThaumcraft.dissolve, (float)((int)((d11 * d11 + d11) / 2.0 * 16.0 * (double)this.explosionSize + 1.0)));
            double d12 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d11);
            entity.motionX += d5 * d12;
            entity.motionY += d6 * d12;
            entity.motionZ += d7 * d12;
            if (!(entity instanceof EntityPlayer)) continue;
            this.field_77288_k.put(entity, Vec3.createVectorHelper((double)(d5 * d11), (double)(d6 * d11), (double)(d7 * d11)));
        }
        this.explosionSize = f;
    }

    public void doExplosionB(boolean p_77279_1_) {
        Block block;
        int k;
        int j;
        int i;
        this.worldObj.playSoundEffect(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            this.worldObj.spawnParticle("hugeexplosion", this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        } else {
            this.worldObj.spawnParticle("largeexplode", this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        }
        ThaumicHorizons.proxy.alchemiteFX(this.worldObj, this.explosionX, this.explosionY, this.explosionZ);
        if (this.isSmoking) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                ItemStack stack;
                AspectList aspects;
                TileEntity tileEntity;
                i = chunkposition.chunkPosX;
                j = chunkposition.chunkPosY;
                k = chunkposition.chunkPosZ;
                block = this.worldObj.getBlock(i, j, k);
                if (this.worldObj.getTileEntity(i, j, k) != null && (tileEntity = this.worldObj.getTileEntity(i, j, k)) instanceof TileNode) {
                    TileNode node = (TileNode)tileEntity;
                    double d = Math.random();
                    if (d < 0.25) {
                        aspects = node.getAspects();
                        if (aspects != null) {
                            for (Aspect asp : aspects.getAspects()) {
                                stack = new ItemStack(ConfigItems.itemCrystalEssence, aspects.getAmount(asp));
                                ((ItemCrystalEssence)stack.getItem()).setAspects(stack, new AspectList().add(asp, 1));
                                this.worldObj.spawnEntityInWorld((Entity)new EntityItemInvulnerable(this.worldObj, i, j, k, stack));
                            }
                            ThaumicHorizons.proxy.disintegrateExplodeFX(this.worldObj, i, j, k);
                        }
                        BlockAiry.explodify((World)this.worldObj, (int)i, (int)j, (int)k);
                        continue;
                    }
                    if (d < 0.5) {
                        node.setNodeModifier(NodeModifier.FADING);
                        continue;
                    }
                    node.setNodeModifier(null);
                    node.setNodeType(NodeType.UNSTABLE);
                    continue;
                }
                if (block.getMaterial() == Material.air) continue;
                Item item = Item.getItemFromBlock((Block)block);
                int meta = this.worldObj.getBlockMetadata(i, j, k);
                if (item == null) {
                    item = block.getItemDropped(meta, this.worldObj.rand, 0);
                }
                if (item == null) continue;
                aspects = this.getAspects(item, meta);
                if (aspects != null && aspects.size() > 0) {
                    for (Aspect asp2 : aspects.getAspects()) {
                        stack = new ItemStack(ConfigItems.itemCrystalEssence, aspects.getAmount(asp2));
                        ((ItemCrystalEssence)stack.getItem()).setAspects(stack, new AspectList().add(asp2, 1));
                        this.worldObj.spawnEntityInWorld((Entity)new EntityItemInvulnerable(this.worldObj, i, j, k, stack));
                    }
                    ThaumicHorizons.proxy.disintegrateExplodeFX(this.worldObj, i, j, k);
                } else {
                    block.dropBlockAsItemWithChance(this.worldObj, i, j, k, this.worldObj.getBlockMetadata(i, j, k), 1.0f, 0);
                }
                block.onBlockExploded(this.worldObj, i, j, k, (Explosion)this);
            }
        }
        if (this.isFlaming) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                i = chunkposition.chunkPosX;
                j = chunkposition.chunkPosY;
                k = chunkposition.chunkPosZ;
                block = this.worldObj.getBlock(i, j, k);
                Block block2 = this.worldObj.getBlock(i, j - 1, k);
                if (block.getMaterial() != Material.air || !block2.func_149730_j() || this.explosionRNG.nextInt(3) != 0) continue;
                this.worldObj.setBlock(i, j, k, (Block)Blocks.fire);
            }
        }
    }

    private AspectList getAspects(Item block, int meta) {
        ItemStack tmpStack = new ItemStack(block, 1, meta);
        AspectList tmp = ThaumcraftCraftingManager.getObjectTags((ItemStack)tmpStack);
        if ((tmp = ThaumcraftCraftingManager.getBonusTags((ItemStack)tmpStack, (AspectList)tmp)) == null || tmp.size() == 0) {
            tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(block, Short.MAX_VALUE));
            if (meta == Short.MAX_VALUE && tmp == null) {
                int index = 0;
                do {
                    tmp = (AspectList)ThaumcraftApi.objectTags.get(Arrays.asList(block, index));
                } while (++index < 16 && tmp == null);
            }
        }
        return tmp;
    }

    public Map func_77277_b() {
        return this.field_77288_k;
    }

    public EntityLivingBase getExplosivePlacedBy() {
        return this.exploder == null ? null : (this.exploder instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.exploder).getTntPlacedBy() : (this.exploder instanceof EntityLivingBase ? this.exploder : null));
    }
}

