/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.lib;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.lib.ChunkProviderPocketPlane;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldProviderPocketPlane
extends WorldProvider {
    public void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManagerHell(BiomeGenBase.hell, 0.0f);
        this.dimensionId = ThaumicHorizons.dimensionPocketId;
        this.hasNoSky = true;
    }

    public IChunkProvider createChunkGenerator() {
        return new ChunkProviderPocketPlane(this.worldObj, this.worldObj.getSeed());
    }

    public int getAverageGroundLevel() {
        return 128;
    }

    public ChunkCoordinates getEntrancePortalLocation() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getFogColor(float p_76562_1_, float p_76562_2_) {
        return Vec3.createVectorHelper((double)0.02734375, (double)0.01171875, (double)0.16015625);
    }

    protected void generateLightBrightnessTable() {
        float f = 0.3f;
        for (int i = 0; i <= 15; ++i) {
            float f2 = 1.0f - (float)i / 15.0f;
            this.lightBrightnessTable[i] = (1.0f - f2) / (f2 * 3.0f + 1.0f) * 0.7f + 0.3f;
        }
    }

    public boolean isSurfaceWorld() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSkyColored() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] calcSunriseSunsetColors(float p_76560_1_, float p_76560_2_) {
        return null;
    }

    public String getWelcomeMessage() {
        return "Entering pocket plane...";
    }

    public String getDepartMessage() {
        return "Leaving pocket plane...";
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return true;
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean byWater) {
        return false;
    }

    public boolean canSnowAt(int x, int y, int z, boolean checkLight) {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public boolean canCoordinateBeSpawn(int p_76566_1_, int p_76566_2_) {
        return this.worldObj.getTopBlock(p_76566_1_, p_76566_2_).getMaterial().blocksMovement();
    }

    public float calculateCelestialAngle(long p_76563_1_, float p_76563_3_) {
        return 0.5f;
    }

    public boolean canRespawnHere() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesXZShowFog(int p_76568_1_, int p_76568_2_) {
        return false;
    }

    public String getDimensionName() {
        return "Pocket Plane";
    }
}

