/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.blocks.BlockNodeMonitor;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.INode;

public class TileNodeMonitor
extends TileThaumcraft {
    public byte direction = (byte)this.blockMetadata;
    public boolean activated = false;
    boolean lastActivated = false;
    public int rotation = 0;
    public boolean switchy = false;

    public void updateEntity() {
        ForgeDirection dir;
        if (!this.activated) {
            this.switchy = false;
            ++this.rotation;
            if (this.rotation > 360) {
                this.rotation -= 360;
            }
        } else if (this.worldObj.isRemote && Minecraft.getMinecraft().thePlayer.ticksExisted % 15 == 0) {
            boolean bl = this.switchy = !this.switchy;
        }
        if (this.direction == -1) {
            this.direction = (byte)this.getBlockMetadata();
        }
        if ((dir = ForgeDirection.getOrientation((int)this.direction)) == ForgeDirection.UP && this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord) instanceof INode) {
            this.activated = this.aspectCritical(this.xCoord, this.yCoord - 1, this.zCoord);
        } else if (dir == ForgeDirection.DOWN && this.worldObj.getTileEntity(this.xCoord, this.yCoord + 1, this.zCoord) instanceof INode) {
            this.activated = this.aspectCritical(this.xCoord, this.yCoord + 1, this.zCoord);
        } else if (dir == ForgeDirection.NORTH && this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord + 1) instanceof INode) {
            this.activated = this.aspectCritical(this.xCoord, this.yCoord, this.zCoord + 1);
        } else if (dir == ForgeDirection.SOUTH && this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord - 1) instanceof INode) {
            this.activated = this.aspectCritical(this.xCoord, this.yCoord, this.zCoord - 1);
        } else if (dir == ForgeDirection.WEST && this.worldObj.getTileEntity(this.xCoord + 1, this.yCoord, this.zCoord) instanceof INode) {
            this.activated = this.aspectCritical(this.xCoord + 1, this.yCoord, this.zCoord);
        } else if (dir == ForgeDirection.EAST && this.worldObj.getTileEntity(this.xCoord - 1, this.yCoord, this.zCoord) instanceof INode) {
            this.activated = this.aspectCritical(this.xCoord - 1, this.yCoord, this.zCoord);
        } else {
            ((BlockNodeMonitor)ThaumicHorizons.blockNodeMonitor).killMe(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        if (this.activated != this.lastActivated) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, ThaumicHorizons.blockNodeMonitor);
        }
        this.lastActivated = this.activated;
    }

    private boolean aspectCritical(int x, int y, int z) {
        TileEntity node = this.worldObj.getTileEntity(x, y, z);
        if (node instanceof INode) {
            for (Aspect asp : ((INode)node).getAspects().getAspects()) {
                if (((INode)node).getAspects().getAmount(asp) > 1) continue;
                return true;
            }
        }
        return false;
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setBoolean("active", this.activated);
        nbttagcompound.setBoolean("lastactive", this.lastActivated);
        nbttagcompound.setByte("dir", this.direction);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.activated = nbttagcompound.getBoolean("active");
        this.lastActivated = nbttagcompound.getBoolean("lastactive");
        this.direction = nbttagcompound.getByte("dir");
    }
}

