/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import com.kentington.thaumichorizons.common.ThaumicHorizons;
import com.kentington.thaumichorizons.common.lib.PocketPlaneData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.items.wands.ItemWandCasting;

public class TileSlot
extends TileThaumcraft {
    public boolean hasKeystone = false;
    public boolean portalOpen = false;
    public int pocketID = 0;
    public int which = 0;
    public boolean xAligned = false;

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setInteger("pocketPlaneID", this.pocketID);
        nbttagcompound.setInteger("which", this.which);
        nbttagcompound.setBoolean("hasKeystone", this.hasKeystone);
        nbttagcompound.setBoolean("portalOpen", this.portalOpen);
        nbttagcompound.setBoolean("aligned", this.xAligned);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.pocketID = nbttagcompound.getInteger("pocketPlaneID");
        this.which = nbttagcompound.getInteger("which");
        this.hasKeystone = nbttagcompound.getBoolean("hasKeystone");
        this.portalOpen = nbttagcompound.getBoolean("portalOpen");
        this.xAligned = nbttagcompound.getBoolean("aligned");
    }

    public void destroyPortal() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.xAligned) {
            int y;
            int x;
            this.worldObj.setBlock(this.xCoord - 2, this.yCoord, this.zCoord, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord + 2, this.yCoord, this.zCoord, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord - 2, this.yCoord - 4, this.zCoord, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord + 2, this.yCoord - 4, this.zCoord, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord - 1, this.yCoord, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord + 1, this.yCoord, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord - 1, this.yCoord - 4, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 4, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord + 1, this.yCoord - 4, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord - 2, this.yCoord - 1, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord - 2, this.yCoord - 2, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord - 2, this.yCoord - 3, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord + 2, this.yCoord - 1, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord + 2, this.yCoord - 2, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord + 2, this.yCoord - 3, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            for (x = -1; x <= 1; ++x) {
                for (y = -1; y >= -3; --y) {
                    this.worldObj.setBlockToAir(this.xCoord + x, this.yCoord + y, this.zCoord);
                }
            }
            for (x = -2; x <= 2; ++x) {
                for (y = 0; y >= -4; --y) {
                    this.worldObj.markBlockForUpdate(this.xCoord + x, this.yCoord + y, this.zCoord);
                }
            }
        } else {
            int y;
            int z;
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord - 2, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord + 2, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 4, this.zCoord - 2, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 4, this.zCoord + 2, ConfigBlocks.blockMetalDevice, 3, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord - 1, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord + 1, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 4, this.zCoord - 1, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 4, this.zCoord, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 4, this.zCoord + 1, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 1, this.zCoord - 2, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 2, this.zCoord - 2, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 3, this.zCoord - 2, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 1, this.zCoord + 2, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 2, this.zCoord + 2, ConfigBlocks.blockCosmeticSolid, 11, 1);
            this.worldObj.setBlock(this.xCoord, this.yCoord - 3, this.zCoord + 2, ConfigBlocks.blockCosmeticSolid, 11, 1);
            for (z = -1; z <= 1; ++z) {
                for (y = -1; y >= -3; --y) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord + y, this.zCoord + z);
                }
            }
            for (z = -2; z <= 2; ++z) {
                for (y = 0; y >= -4; --y) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord + y, this.zCoord + z);
                }
            }
        }
        PocketPlaneData.destroyPortal(this.pocketID, this.which);
        this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:craftfail", 1.0f, 1.0f);
        this.portalOpen = false;
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public void makePortal(EntityPlayer player) {
        if (this.worldObj.isRemote) {
            return;
        }
        int portalNum = PocketPlaneData.firstAvailablePortal(this.pocketID);
        ItemWandCasting wand = (ItemWandCasting)player.getHeldItem().getItem();
        if (portalNum != 0 && wand.consumeAllVisCrafting(player.getHeldItem(), player, new AspectList().add(Aspect.WATER, 250).add(Aspect.EARTH, 250).add(Aspect.ORDER, 250).add(Aspect.FIRE, 250).add(Aspect.AIR, 250).add(Aspect.ENTROPY, 250), false)) {
            int md;
            boolean madePortal = false;
            if (this.checkPortalX()) {
                this.xAligned = true;
                md = 0;
                for (int x = -2; x <= 2; ++x) {
                    for (int y = 0; y >= -4; --y) {
                        if (!(this.worldObj.isAirBlock(this.xCoord + x, this.yCoord + y, this.zCoord) || x == 0 && y == 0)) {
                            this.worldObj.setBlock(this.xCoord + x, this.yCoord + y, this.zCoord, ThaumicHorizons.blockGateway, md, 3);
                            ++md;
                            continue;
                        }
                        if (x == 0 && y == 0) continue;
                        this.worldObj.setBlock(this.xCoord + x, this.yCoord + y, this.zCoord, ThaumicHorizons.blockPortal, 0, 3);
                    }
                }
                madePortal = true;
            } else if (this.checkPortalZ()) {
                this.xAligned = false;
                md = 0;
                for (int z = -2; z <= 2; ++z) {
                    for (int y = 0; y >= -4; --y) {
                        if (!(this.worldObj.isAirBlock(this.xCoord, this.yCoord + y, this.zCoord + z) || z == 0 && y == 0)) {
                            this.worldObj.setBlock(this.xCoord, this.yCoord + y, this.zCoord + z, ThaumicHorizons.blockGateway, md, 3);
                            ++md;
                            continue;
                        }
                        if (z == 0 && y == 0) continue;
                        this.worldObj.setBlock(this.xCoord, this.yCoord + y, this.zCoord + z, ThaumicHorizons.blockPortal, 0, 3);
                    }
                }
                madePortal = true;
            }
            if (madePortal) {
                PocketPlaneData planeData = PocketPlaneData.planes.get(this.pocketID);
                switch (portalNum) {
                    case 1: {
                        int[] portal = planeData.portalA = new int[4];
                        break;
                    }
                    case 2: {
                        planeData.portalB = new int[4];
                        int[] portal = planeData.portalB;
                        break;
                    }
                    case 3: {
                        planeData.portalC = new int[4];
                        int[] portal = planeData.portalC;
                        break;
                    }
                    case 4: {
                        planeData.portalD = new int[4];
                        int[] portal = planeData.portalD;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                portal[0] = this.xCoord;
                portal[1] = this.yCoord;
                portal[2] = this.zCoord;
                portal[3] = player.dimension;
                PocketPlaneData.makePortal(this.pocketID, portalNum, this.xCoord, this.yCoord, this.zCoord);
                this.which = portalNum;
                this.portalOpen = true;
                wand.consumeAllVisCrafting(player.getHeldItem(), player, new AspectList().add(Aspect.WATER, 250).add(Aspect.EARTH, 250).add(Aspect.ORDER, 250).add(Aspect.FIRE, 250).add(Aspect.AIR, 250).add(Aspect.ENTROPY, 250), true);
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    boolean checkPortalX() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y >= -3; --y) {
                if (this.worldObj.isAirBlock(this.xCoord + x, this.yCoord + y, this.zCoord)) continue;
                return false;
            }
        }
        return this.checkBlocksX(this.xCoord, this.yCoord, this.zCoord);
    }

    boolean checkPortalZ() {
        for (int z = -1; z <= 1; ++z) {
            for (int y = -1; y >= -3; --y) {
                if (this.worldObj.isAirBlock(this.xCoord, this.yCoord + y, this.zCoord + z)) continue;
                return false;
            }
        }
        return this.checkBlocksZ(this.xCoord, this.yCoord, this.zCoord);
    }

    boolean checkBlocksX(int x, int y, int z) {
        boolean isValid = true;
        isValid &= this.checkCornerBlock(x - 2, y, z);
        isValid &= this.checkCornerBlock(x + 2, y, z);
        isValid &= this.checkCornerBlock(x - 2, y - 4, z);
        isValid &= this.checkCornerBlock(x + 2, y - 4, z);
        isValid &= this.checkEdgeBlock(x - 1, y, z);
        isValid &= this.checkEdgeBlock(x + 1, y, z);
        isValid &= this.checkEdgeBlock(x - 2, y - 1, z);
        isValid &= this.checkEdgeBlock(x + 2, y - 1, z);
        isValid &= this.checkEdgeBlock(x - 2, y - 2, z);
        isValid &= this.checkEdgeBlock(x + 2, y - 2, z);
        isValid &= this.checkEdgeBlock(x - 2, y - 3, z);
        isValid &= this.checkEdgeBlock(x + 2, y - 3, z);
        isValid &= this.checkEdgeBlock(x - 1, y - 4, z);
        isValid &= this.checkEdgeBlock(x, y - 4, z);
        return isValid &= this.checkEdgeBlock(x + 1, y - 4, z);
    }

    boolean checkBlocksZ(int x, int y, int z) {
        boolean isValid = true;
        isValid &= this.checkCornerBlock(x, y, z - 2);
        isValid &= this.checkCornerBlock(x, y, z + 2);
        isValid &= this.checkCornerBlock(x, y - 4, z - 2);
        isValid &= this.checkCornerBlock(x, y - 4, z + 2);
        isValid &= this.checkEdgeBlock(x, y, z - 1);
        isValid &= this.checkEdgeBlock(x, y, z + 1);
        isValid &= this.checkEdgeBlock(x, y - 1, z - 2);
        isValid &= this.checkEdgeBlock(x, y - 1, z + 2);
        isValid &= this.checkEdgeBlock(x, y - 2, z - 2);
        isValid &= this.checkEdgeBlock(x, y - 2, z + 2);
        isValid &= this.checkEdgeBlock(x, y - 3, z - 2);
        isValid &= this.checkEdgeBlock(x, y - 3, z + 2);
        isValid &= this.checkEdgeBlock(x, y - 4, z - 1);
        isValid &= this.checkEdgeBlock(x, y - 4, z);
        return isValid &= this.checkEdgeBlock(x, y - 4, z + 1);
    }

    boolean checkCornerBlock(int x, int y, int z) {
        return this.worldObj.getBlock(x, y, z) == ConfigBlocks.blockMetalDevice && this.worldObj.getBlockMetadata(x, y, z) == 3;
    }

    boolean checkEdgeBlock(int x, int y, int z) {
        return this.worldObj.getBlock(x, y, z) == ConfigBlocks.blockCosmeticSolid && this.worldObj.getBlockMetadata(x, y, z) == 11;
    }

    public void insertKeystone(int pocketNum) {
        this.hasKeystone = true;
        this.pocketID = pocketNum;
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public int removeKeystone() {
        this.hasKeystone = false;
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return this.pocketID;
    }
}

