/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.visnet.TileVisNode;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemWispEssence;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.EntityUtils;

public class TileSyntheticNode
extends TileVisNode
implements INode,
IWandable {
    AspectList aspects = new AspectList();
    AspectList fractionalAspects = new AspectList();
    AspectList aspectsMax = new AspectList();
    private final NodeType nodeType = NodeType.NORMAL;
    private final NodeModifier nodeModifier = null;
    public float rotation = 0.0f;
    float increment = 1.0f;
    public Entity drainEntity = null;
    public MovingObjectPosition drainCollision = null;
    public int drainColor = 0xFFFFFF;
    public Color targetColor = new Color(0xFFFFFF);
    public Color color = new Color(0xFFFFFF);

    public void debug() {
        if (this.worldObj.isRemote) {
            // empty if block
        }
    }

    public AspectList getAspects() {
        if (this.aspects.getAspects().length > 0 && this.aspects.getAspects()[0] != null) {
            return this.aspects;
        }
        return new AspectList();
    }

    public AspectList getMaxAspects() {
        return this.aspectsMax;
    }

    public void setAspects(AspectList aspects) {
        this.aspectsMax = aspects;
        this.aspects = new AspectList();
        this.fractionalAspects = new AspectList();
        for (Aspect asp : aspects.getAspectsSortedAmount()) {
            this.aspects.add(asp, 0);
            this.fractionalAspects.add(asp, 0);
        }
    }

    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    public int addToContainer(Aspect tag, int amount) {
        this.aspects.add(tag, amount);
        int toReturn = amount;
        if (this.aspectsMax.getAmount(tag) < this.aspects.getAmount(tag)) {
            toReturn -= this.aspectsMax.getAmount(tag) - this.aspects.getAmount(tag);
            this.aspects.reduce(tag, this.aspectsMax.getAmount(tag) - this.aspects.getAmount(tag));
        }
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.markDirty();
        return toReturn;
    }

    public boolean addFractionalToContainer(Aspect tag, int amount) {
        if (this.aspects.getAmount(tag) < this.aspectsMax.getAmount(tag)) {
            this.fractionalAspects.add(tag, amount);
            while (this.fractionalAspects.getAmount(tag) > 100) {
                this.addToContainer(tag, 1);
                this.fractionalAspects.remove(tag, 100);
            }
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return this.aspects.reduce(tag, amount);
    }

    public boolean takeFromContainer(AspectList ot) {
        Aspect[] toRemove;
        for (Aspect aspect : toRemove = ot.getAspects()) {
            if (this.aspects.reduce(aspect, ot.getAmount(aspect))) continue;
            return false;
        }
        return true;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.aspects.getAmount(tag) >= amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        for (Aspect asp : ot.getAspectsSortedAmount()) {
            if (this.aspects.getAmount(asp) > 0) continue;
            return false;
        }
        return true;
    }

    public int containerContains(Aspect tag) {
        return this.aspects.getAmount(tag);
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        return -1;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        player.setItemInUse(wandstack, Integer.MAX_VALUE);
        ItemWandCasting wand = (ItemWandCasting)wandstack.getItem();
        wand.setObjectInUse(wandstack, this.xCoord, this.yCoord, this.zCoord);
        return wandstack;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
        boolean mfu = false;
        ItemWandCasting wand = (ItemWandCasting)wandstack.getItem();
        MovingObjectPosition movingobjectposition = EntityUtils.getMovingObjectPositionFromPlayer((World)this.worldObj, (EntityPlayer)player, (boolean)true);
        if (movingobjectposition == null || movingobjectposition.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            player.stopUsingItem();
        } else {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (i != this.xCoord || j != this.yCoord || k != this.zCoord) {
                player.stopUsingItem();
            }
        }
        if (count % 5 == 0) {
            int tap = 1;
            if (ResearchManager.isResearchComplete((String)player.getCommandSenderName(), (String)"NODETAPPER1")) {
                ++tap;
            }
            if (ResearchManager.isResearchComplete((String)player.getCommandSenderName(), (String)"NODETAPPER2")) {
                ++tap;
            }
            boolean preserve = !player.isSneaking() && ResearchManager.isResearchComplete((String)player.getCommandSenderName(), (String)"NODEPRESERVE") && !wand.getRod(wandstack).getTag().equals("wood") && !wand.getCap(wandstack).getTag().equals("iron");
            boolean success = false;
            Aspect aspect = null;
            aspect = this.chooseRandomFilteredFromSource(wand.getAspectsWithRoom(wandstack), preserve);
            if (aspect != null) {
                int rem;
                int amt = this.getAspects().getAmount(aspect);
                if (tap > amt) {
                    tap = amt;
                }
                if (preserve && tap == amt) {
                    --tap;
                }
                if (tap > 0 && (rem = wand.addVis(wandstack, aspect, tap, !this.worldObj.isRemote)) < tap) {
                    this.drainColor = aspect.getColor();
                    if (!this.worldObj.isRemote) {
                        this.takeFromContainer(aspect, tap - rem);
                        mfu = true;
                    }
                    success = true;
                }
            }
            if (success) {
                this.drainEntity = player;
                this.drainCollision = movingobjectposition;
                this.targetColor = new Color(this.drainColor);
            } else {
                this.drainEntity = null;
                this.drainCollision = null;
            }
            if (mfu) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.markDirty();
            }
        }
        if (player.worldObj.isRemote) {
            int r = this.targetColor.getRed();
            int g = this.targetColor.getGreen();
            int b = this.targetColor.getBlue();
            int r2 = this.color.getRed() * 4;
            int g2 = this.color.getGreen() * 4;
            int b2 = this.color.getBlue() * 4;
            this.color = new Color((r + r2) / 5, (g + g2) / 5, (b + b2) / 5);
        }
    }

    public Aspect chooseRandomFilteredFromSource(AspectList filter, boolean preserve) {
        int min = preserve ? 1 : 0;
        ArrayList<Aspect> validaspects = new ArrayList<Aspect>();
        for (Aspect prim : this.aspects.getAspects()) {
            if (filter.getAmount(prim) <= 0 || this.aspects.getAmount(prim) <= min) continue;
            validaspects.add(prim);
        }
        if (validaspects.size() == 0) {
            return null;
        }
        Aspect asp = (Aspect)validaspects.get(this.worldObj.rand.nextInt(validaspects.size()));
        if (asp != null && this.aspects.getAmount(asp) > min) {
            return asp;
        }
        return null;
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
        this.drainEntity = null;
        this.drainCollision = null;
    }

    public String getId() {
        return "SYNTHETIC";
    }

    public AspectList getAspectsBase() {
        return this.aspectsMax;
    }

    public NodeType getNodeType() {
        return NodeType.NORMAL;
    }

    public void setNodeType(NodeType nodeType) {
    }

    public void setNodeModifier(NodeModifier nodeModifier) {
    }

    public NodeModifier getNodeModifier() {
        return null;
    }

    public int getNodeVisBase(Aspect aspect) {
        return this.aspectsMax.getAmount(aspect);
    }

    public void setNodeVisBase(Aspect aspect, short nodeVisBase) {
    }

    public int getRange() {
        return 8;
    }

    public boolean isSource() {
        return false;
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            for (Aspect aspect : this.aspectsMax.getAspectsSortedAmount()) {
                if (aspect == null || this.aspects.getAmount(aspect) >= this.aspectsMax.getAmount(aspect)) continue;
                if (aspect.isPrimal()) {
                    int drained = VisNetHandler.drainVis((World)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (Aspect)aspect, (int)10);
                    if (drained <= 0) continue;
                    this.addFractionalToContainer(aspect, drained);
                    continue;
                }
                AspectList primalComponents = ResearchManager.reduceToPrimals((AspectList)new AspectList().add(aspect, 1));
                int actuallyDrained = 100;
                for (Aspect primal : primalComponents.getAspects()) {
                    int drained2 = VisNetHandler.drainVis((World)this.worldObj, (int)this.xCoord, (int)this.yCoord, (int)this.zCoord, (Aspect)primal, (int)10);
                    if (drained2 >= actuallyDrained) continue;
                    actuallyDrained = drained2;
                }
                if (actuallyDrained <= 0) continue;
                this.addFractionalToContainer(aspect, actuallyDrained);
            }
        } else {
            this.rotation += this.increment;
            if (this.rotation > 360.0f) {
                this.rotation -= 360.0f;
            }
        }
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.setTag("AspectsMax", (NBTBase)tlist);
        for (Aspect aspect : this.aspectsMax.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.setString("key", aspect.getTag());
            f.setInteger("amount", this.aspectsMax.getAmount(aspect));
            tlist.appendTag((NBTBase)f);
        }
        NBTTagList tlist2 = new NBTTagList();
        nbttagcompound.setTag("Aspects", (NBTBase)tlist2);
        for (Aspect aspect2 : this.aspects.getAspects()) {
            if (aspect2 == null) continue;
            NBTTagCompound f2 = new NBTTagCompound();
            f2.setString("key", aspect2.getTag());
            f2.setInteger("amount", this.aspects.getAmount(aspect2));
            tlist2.appendTag((NBTBase)f2);
        }
        NBTTagList tlist3 = new NBTTagList();
        nbttagcompound.setTag("AspectsFractional", (NBTBase)tlist3);
        for (Aspect aspect3 : this.fractionalAspects.getAspects()) {
            if (aspect3 == null) continue;
            NBTTagCompound f3 = new NBTTagCompound();
            f3.setString("key", aspect3.getTag());
            f3.setInteger("amount", this.fractionalAspects.getAmount(aspect3));
            tlist3.appendTag((NBTBase)f3);
        }
        if (this.drainEntity != null && this.drainEntity instanceof EntityPlayer) {
            nbttagcompound.setString("drainer", this.drainEntity.getCommandSenderName());
        }
        nbttagcompound.setInteger("draincolor", this.drainColor);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        AspectList al = new AspectList();
        NBTTagList tlist = nbttagcompound.getTagList("AspectsMax", 10);
        for (int j = 0; j < tlist.tagCount(); ++j) {
            NBTTagCompound rs = tlist.getCompoundTagAt(j);
            if (!rs.hasKey("key")) continue;
            al.add(Aspect.getAspect((String)rs.getString("key")), rs.getInteger("amount"));
        }
        this.aspectsMax = al.copy();
        AspectList al2 = new AspectList();
        NBTTagList tlist2 = nbttagcompound.getTagList("Aspects", 10);
        for (int i = 0; i < tlist2.tagCount(); ++i) {
            NBTTagCompound rs2 = tlist2.getCompoundTagAt(i);
            if (!rs2.hasKey("key")) continue;
            al2.add(Aspect.getAspect((String)rs2.getString("key")), rs2.getInteger("amount"));
        }
        this.aspects = al2.copy();
        AspectList al3 = new AspectList();
        NBTTagList tlist3 = nbttagcompound.getTagList("AspectsFractional", 10);
        for (int k = 0; k < tlist3.tagCount(); ++k) {
            NBTTagCompound rs3 = tlist3.getCompoundTagAt(k);
            if (!rs3.hasKey("key")) continue;
            al3.add(Aspect.getAspect((String)rs3.getString("key")), rs3.getInteger("amount"));
        }
        this.fractionalAspects = al3.copy();
        String de = nbttagcompound.getString("drainer");
        if (de != null && de.length() > 0 && this.getWorldObj() != null) {
            this.drainEntity = this.getWorldObj().getPlayerEntityByName(de);
            if (this.drainEntity != null) {
                this.drainCollision = new MovingObjectPosition(this.xCoord, this.yCoord, this.zCoord, 0, Vec3.createVectorHelper((double)this.drainEntity.posX, (double)this.drainEntity.posY, (double)this.drainEntity.posZ));
            }
        }
        this.drainColor = nbttagcompound.getInteger("draincolor");
    }

    public void addEssence(EntityPlayer player) {
        ItemWispEssence essence;
        ItemStack heldItem = player.getHeldItem();
        if (heldItem == null) {
            return;
        }
        if (heldItem.stackSize == 0) {
            return;
        }
        Item item = heldItem.getItem();
        if (item instanceof ItemWispEssence && (essence = (ItemWispEssence)item) == ConfigItems.itemWispEssence) {
            if (essence.getAspects(heldItem) == null) {
                return;
            }
            Aspect[] aspectList = essence.getAspects(heldItem).getAspects();
            if (aspectList == null || aspectList.length == 0) {
                return;
            }
            Aspect asp = aspectList[0];
            this.aspectsMax.add(asp, 4 * heldItem.stackSize);
            this.aspects.add(asp, 0);
            this.fractionalAspects.add(asp, 0);
            heldItem.stackSize = 0;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
    }
}

