/*
 * Decompiled with CFR 0.152.
 */
package com.kentington.thaumichorizons.common.tiles;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.visnet.TileVisNode;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;

public class TileVisDynamo
extends TileVisNode
implements IAspectContainer,
IWandable {
    AspectList primalsActuallyProvided = new AspectList();
    AspectList primalsProvided = new AspectList();
    public boolean provideAer = true;
    public boolean provideAqua = true;
    public boolean provideIgnis = true;
    public boolean provideOrdo = true;
    public boolean providePerditio = true;
    public boolean provideTerra = true;
    public int ticksProvided = 0;
    public float rise = 0.0f;
    public float rotation = 0.0f;
    public float rotation2 = 0.0f;
    public Entity drainEntity = null;
    public MovingObjectPosition drainCollision = null;
    public int drainColor = 0xFFFFFF;
    public Color targetColor = new Color(0xFFFFFF);
    public Color color = new Color(0xFFFFFF);

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && p_70300_1_.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public AspectList getAspects() {
        if (this.primalsProvided.getAspects().length > 0 && this.primalsProvided.getAspects()[0] != null) {
            return this.primalsProvided;
        }
        return null;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    public int addToContainer(Aspect tag, int amount) {
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        return 0;
    }

    public int getRange() {
        return 0;
    }

    public boolean isSource() {
        return this.ticksProvided > 0;
    }

    public int consumeVis(Aspect aspect, int amount) {
        int drain = Math.min(this.primalsActuallyProvided.getAmount(aspect), amount);
        if (drain > 0) {
            this.primalsActuallyProvided.reduce(aspect, drain);
        }
        return drain;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.ticksProvided > 0) {
            if (this.rise < 0.3f) {
                this.rise += 0.02f;
            } else {
                this.rotation2 += 2.0f;
                if (this.rotation2 >= 360.0f) {
                    this.rotation2 -= 360.0f;
                }
            }
            this.rotation += 2.0f;
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
            }
            --this.ticksProvided;
            if (this.ticksProvided == 0) {
                this.primalsProvided = new AspectList();
                this.markDirty();
            }
            this.primalsActuallyProvided = this.primalsProvided.copy();
        } else if (this.ticksProvided == 0) {
            --this.ticksProvided;
            if (VisNetHandler.sources.get(this.worldObj.provider.dimensionId) != null) {
                ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).remove(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId));
            }
            this.removeThisNode();
        } else if (this.ticksProvided < 0 && (this.rise > 0.0f || this.rotation2 != 0.0f)) {
            if (this.rotation2 > 0.0f) {
                this.rotation2 -= 8.0f;
                if (this.rotation2 < 0.0f) {
                    this.rotation2 = 0.0f;
                }
            } else if (this.rise > 0.0f) {
                this.rise -= 0.02f;
            }
        }
    }

    public void killMe() {
        if (VisNetHandler.sources.get(this.worldObj.provider.dimensionId) != null) {
            ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).remove(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId));
        }
        this.removeThisNode();
    }

    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setInteger("ticks", this.ticksProvided);
        nbttagcompound.setBoolean("aer", this.provideAer);
        nbttagcompound.setBoolean("aqua", this.provideAqua);
        nbttagcompound.setBoolean("ignis", this.provideIgnis);
        nbttagcompound.setBoolean("ordo", this.provideOrdo);
        nbttagcompound.setBoolean("perditio", this.providePerditio);
        nbttagcompound.setBoolean("terra", this.provideTerra);
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.setTag("AspectsProvided", (NBTBase)tlist);
        for (Aspect aspect : this.primalsProvided.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.setString("key", aspect.getTag());
            f.setInteger("amount", this.primalsProvided.getAmount(aspect));
            tlist.appendTag((NBTBase)f);
        }
        if (this.drainEntity != null && this.drainEntity instanceof EntityPlayer) {
            nbttagcompound.setString("drainer", this.drainEntity.getCommandSenderName());
        }
        nbttagcompound.setInteger("draincolor", this.drainColor);
    }

    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.ticksProvided = nbttagcompound.getInteger("ticks");
        this.provideAer = nbttagcompound.getBoolean("aer");
        this.provideAqua = nbttagcompound.getBoolean("aqua");
        this.provideIgnis = nbttagcompound.getBoolean("ignis");
        this.provideOrdo = nbttagcompound.getBoolean("ordo");
        this.providePerditio = nbttagcompound.getBoolean("perditio");
        this.provideTerra = nbttagcompound.getBoolean("terra");
        AspectList al = new AspectList();
        NBTTagList tlist = nbttagcompound.getTagList("AspectsProvided", 10);
        for (int j = 0; j < tlist.tagCount(); ++j) {
            NBTTagCompound rs = tlist.getCompoundTagAt(j);
            if (!rs.hasKey("key")) continue;
            al.add(Aspect.getAspect((String)rs.getString("key")), rs.getInteger("amount"));
        }
        this.primalsProvided = al.copy();
        String de = nbttagcompound.getString("drainer");
        if (de != null && de.length() > 0 && this.getWorldObj() != null) {
            this.drainEntity = this.getWorldObj().getPlayerEntityByName(de);
            if (this.drainEntity != null) {
                this.drainCollision = new MovingObjectPosition(this.xCoord, this.yCoord, this.zCoord, 0, Vec3.createVectorHelper((double)this.drainEntity.posX, (double)this.drainEntity.posY, (double)this.drainEntity.posZ));
            }
        }
        this.drainColor = nbttagcompound.getInteger("draincolor");
    }

    public int onWandRightClick(World paramWorld, ItemStack paramItemStack, EntityPlayer paramEntityPlayer, int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5) {
        return -1;
    }

    public ItemStack onWandRightClick(World paramWorld, ItemStack wandstack, EntityPlayer player) {
        player.setItemInUse(wandstack, Integer.MAX_VALUE);
        ItemWandCasting wand = (ItemWandCasting)wandstack.getItem();
        wand.setObjectInUse(wandstack, this.xCoord, this.yCoord, this.zCoord);
        if (this.provideAer || this.provideAqua || this.provideIgnis || this.provideOrdo || this.providePerditio || this.provideTerra) {
            VisNetHandler.sources.computeIfAbsent(this.worldObj.provider.dimensionId, k -> new HashMap());
            if (((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).get(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId)) == null) {
                ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).put(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId), new WeakReference<TileVisDynamo>(this));
            } else if (((WeakReference)((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).get(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId))).get() == null) {
                ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).remove(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId));
                ((HashMap)VisNetHandler.sources.get(this.worldObj.provider.dimensionId)).put(new WorldCoordinates(this.xCoord, this.yCoord, this.zCoord, this.worldObj.provider.dimensionId), new WeakReference<TileVisDynamo>(this));
            }
        }
        return wandstack;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
        boolean mfu = false;
        ItemWandCasting wand = (ItemWandCasting)wandstack.getItem();
        MovingObjectPosition movingobjectposition = EntityUtils.getMovingObjectPositionFromPlayer((World)this.worldObj, (EntityPlayer)player, (boolean)true);
        if (movingobjectposition == null || movingobjectposition.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            player.stopUsingItem();
        } else {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (i != this.xCoord || j != this.yCoord || k != this.zCoord) {
                player.stopUsingItem();
            }
        }
        if (count % 5 == 0) {
            boolean success = false;
            AspectList aspectsToProvide = new AspectList();
            this.primalsProvided = new AspectList();
            if (this.provideAer) {
                aspectsToProvide = aspectsToProvide.add(Aspect.AIR, 25);
            }
            if (this.provideAqua) {
                aspectsToProvide = aspectsToProvide.add(Aspect.WATER, 25);
            }
            if (this.provideIgnis) {
                aspectsToProvide = aspectsToProvide.add(Aspect.FIRE, 25);
            }
            if (this.provideOrdo) {
                aspectsToProvide = aspectsToProvide.add(Aspect.ORDER, 25);
            }
            if (this.providePerditio) {
                aspectsToProvide = aspectsToProvide.add(Aspect.ENTROPY, 25);
            }
            if (this.provideTerra) {
                aspectsToProvide = aspectsToProvide.add(Aspect.EARTH, 25);
            }
            for (Aspect asp : aspectsToProvide.getAspects()) {
                if (!wand.consumeVis(wandstack, player, asp, 40, false)) continue;
                this.primalsProvided = this.primalsProvided.add(asp, 5);
                success = true;
            }
            if (success) {
                this.ticksProvided = 10;
                this.drainEntity = player;
                this.drainCollision = movingobjectposition;
                int r = 0;
                int g = 0;
                int b = 0;
                int num = 0;
                for (Aspect asp2 : this.primalsProvided.getAspects()) {
                    Color col = new Color(asp2.getColor());
                    r += col.getRed();
                    g += col.getGreen();
                    b += col.getBlue();
                    ++num;
                }
                this.drainColor = new Color(r /= num, g /= num, b /= num).getRGB();
                this.targetColor = new Color(this.drainColor);
                if (!this.worldObj.isRemote) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    this.markDirty();
                }
            } else {
                this.drainEntity = null;
                this.drainCollision = null;
            }
        }
        if (player.worldObj.isRemote) {
            int r2 = this.targetColor.getRed();
            int g2 = this.targetColor.getGreen();
            int b2 = this.targetColor.getBlue();
            int r3 = this.color.getRed() * 4;
            int g3 = this.color.getGreen() * 4;
            int b3 = this.color.getBlue() * 4;
            this.color = new Color((r2 + r3) / 5, (g2 + g3) / 5, (b2 + b3) / 5);
        }
    }

    public void onWandStoppedUsing(ItemStack paramItemStack, World paramWorld, EntityPlayer paramEntityPlayer, int paramInt) {
    }
}

